unit ScnPrmsDlg;
{
    
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Spin, ExtCtrls, inifiles, sgr_data,
  sgr_def;

type
  TParamsForm = class(TForm)
    seBCod: TSpinEdit;
    Label1: TLabel;
    Label2: TLabel;
    seECod: TSpinEdit;
    OKBtn: TButton;
    CancelBtn: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ParamsForm: TParamsForm;

Type
 TScanParams=record
  bCod,
  eCod:word;
  sMode:integer;
  Loop:integer;
 end;

var
 SP:TScanParams;

procedure RunParamsDlg;

IMPLEMENTATION

{$R *.DFM}

procedure GetParams(var SP:TScanParams);
begin
 with SP, ParamsForm do
 begin
  bCod:=seBCod.Value;
  eCod:=seECod.Value;
  sMode:=0;
  Loop:=1;
 end;
end;

procedure SetParams(SP:TScanParams);
begin
 with SP, ParamsForm do
 begin
   seBCod.Value:=SP.bCod;
   seECod.Value:=SP.eCod;
{   rbgSMode.ItemIndex:=sMode;
   if (SMode>1) or (SMode<0) then SMode:=0;
   cbxLoop.Checked:=Loop<>0; }
 end;
end;

procedure RunParamsDlg;
begin
 with ParamsForm do
 begin
   SetParams(SP);
   if ShowModal=mrOk then
   begin
    GetParams(SP);
   end;
 end;
end;

Const
 sScanParams='ScanParams';
 kSCod='StartCod';
 kECod='EndCod';
 kSMode='ScanMode';
 kLoop='AutoLoop';

procedure ReadSP(const FN:string);
var INIF:TIniFile;
begin
 INIF:=TIniFile.Create(FN);
 try
  with SP, INIF do
  begin
   bCod:=ReadInteger(sScanParams, kSCod, 0);
   eCod:=ReadInteger(sScanParams, kECod, 10);
   sMode:=ReadInteger(sScanParams,kSMode, 0) and 1;
   Loop:=ReadInteger(sScanParams, kLoop, 0) and 1;
  end;
 finally
  INIF.Free;                    
 end;
end;

procedure WriteSP(const FN:string);
var INIF:TIniFile;
begin
 INIF:=TIniFile.Create(FN);
 try
  with SP, INIF do
  begin
   WriteInteger(sScanParams, kSCod, bCod);
   WriteInteger(sScanParams, kECod, eCod);
   WriteInteger(sScanParams, kSMode,sMode and 1);
   WriteInteger(sScanParams, kLoop, Loop and 1);
  end;
 finally
  INIF.Free;
 end;
end;

procedure TParamsForm.FormCreate(Sender: TObject);
begin
 ReadSP( ChangeFileExt(Application.ExeName, '.ini') );
end;

procedure TParamsForm.FormDestroy(Sender: TObject);
begin
 WriteSP(ChangeFileExt(Application.ExeName, '.ini'));
end;

END.
{
var n,j:integer;
begin
 if Not(CanRun) then Exit;
 try
  with DAQDLL do
  begin
    BufCount:=GetFifoData(@Buf, SizeOf(Buf)) div SizeOf(TFIFOCell);
    if (Total+BufCount)>MaxPntsNum then
    begin
      StopScan;
      BufCount:=MaxPntsNum-Total;
    end;
    if BufCount>0 then
    begin
      inc(Total,BufCount);
      for n:=0 to BufCount-1 do with Buf[n] do
      begin
       for j:=0 to 7 do Curves[j].QuickAddXY(CT, AW[j]);
      end;
    end;
    StatusBar.SimpleText:=IntToStr(Total);
  end;
 except
  StopScan;
  raise;
 end;
}
