unit Recorder;
{*
MainForm
*}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus, ExtCtrls, ComCtrls,
  sgr_def, sgr_data,
  {MMSystem,} Spin;



Type
  TMainForm = class(TForm)
    BackPanel: TPanel;
    MainMenu1: TMainMenu;
    mbFile: TMenuItem;
    mbCopy: TMenuItem;
    mCopyPlotDIB: TMenuItem;
    mExit: TMenuItem;
    mbHelp: TMenuItem;
    mAbout: TMenuItem;
    N3: TMenuItem;
    mStartScan: TMenuItem;
    mAbortScan: TMenuItem;
    mScanParams: TMenuItem;
    mSaveData: TMenuItem;
    N7: TMenuItem;
    mCopyPlotMF: TMenuItem;
    StatusBar: TStatusBar;
    mbView: TMenuItem;
    mStndLimits: TMenuItem;
    mAutoLimits: TMenuItem;
    N9: TMenuItem;
    mShowAllCurves: TMenuItem;
    mHideAllCurves: TMenuItem;
    Panelcb: TPanel;
    GroupBox1: TGroupBox;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    XYPlot: Tsp_XYPlot;
    Timer: TTimer;
    N4: TMenuItem;
    N1: TMenuItem;
    mBufferedDisplay: TMenuItem;
    mOnDrawEnd: TMenuItem;
    mOnFieldDraw: TMenuItem;
    SpinEdit1: TSpinEdit;
    Label1: TLabel;
    mbZoom: TMenuItem;
    mZH: TMenuItem;
    mZV: TMenuItem;
    mZB: TMenuItem;
    mZN: TMenuItem;
    procedure mExitClick(Sender: TObject);
    procedure mAboutClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CheckBoxClick(Sender: TObject);
    procedure mShowAllCurvesClick(Sender: TObject);
    procedure mHideAllCurvesClick(Sender: TObject);
    procedure mStndLimitsClick(Sender: TObject);
    procedure mAutoLimitsClick(Sender: TObject);
    procedure mScanParamsClick(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure mStartScanClick(Sender: TObject);
    procedure mAbortScanClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure XYPlotDrawEnd(Sender: TObject);
    procedure mCopyPlotMFClick(Sender: TObject);
    procedure XYPlotFieldDraw(Sender: TObject);
    procedure mBufferedDisplayClick(Sender: TObject);
    procedure mOnDrawEndClick(Sender: TObject);
    procedure mOnFieldDrawClick(Sender: TObject);
    procedure mCopyPlotDIBClick(Sender: TObject);
    procedure XYPlotMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SpinEdit1Change(Sender: TObject);
    procedure XYPlotAxisZoom(Sender: Tsp_Axis; var min, max: Double;
      var CanZoom: Boolean);
    procedure mZVClick(Sender: TObject);
    procedure mZHClick(Sender: TObject);
    procedure mZBClick(Sender: TObject);
    procedure mZNClick(Sender: TObject);
  private
    { Private declarations }
    Checks: array [0..4] of TCheckBox;
    procedure ShowHint(Sender: TObject);
    procedure EndScan;
    procedure PrepareToScan;
    procedure NewTimerScan;
  public
    { Public declarations }
   procedure StopTimerScan;
{   procedure StartScan;}
  end;

var
  MainForm: TMainForm;

IMPLEMENTATION

uses About, AxisDlg, ScnPrmsDlg;

{$R *.DFM}


type
 TScanMode=(smTimer, smQuickScan);

var
// StartCod:word;
 CodInc:smallInt;
 PntNum:integer;
 Cntr:integer;
 ScanMode:TScanMode;
 LoopScan:boolean;
 BreakScan:boolean=False;

procedure TMainForm.PrepareToScan;
var  j:integer;
begin
 StatusBar.Panels[0].Text:='';
 with SP do
 begin
  if bCod>eCod then  begin
   CodInc:=-1;
   PntNum:=bCod-eCod+1;
  end  else  begin
   CodInc:=1;
   PntNum:=eCod-bCod+1;
  end;
  LoopScan:=Loop=1;
  if sMode<>1 then ScanMode:=smTimer else ScanMode:=smQuickScan;
 end;
 for j:=0 to 4 do with XYPlot.Series[j] as Tsp_xyLine do
 begin
  Clear;
  SetCapacity(PntNum);
 end;
 Cntr:=0;
 mStartScan.Enabled:=False;
 mScanParams.Enabled:=False;
end;

procedure TMainForm.EndScan;
begin
 mStartScan.Enabled:=True;
 mScanParams.Enabled:=True;
end;

{var
 ExchBuf: array [0..48] of TSFIFOCell; //    
}
procedure TMainForm.NewTimerScan;
var j:integer;
begin
 for j:=0 to 4 do with XYPlot.Series[j] as Tsp_xyLine do Clear;
 Cntr:=0;
 Timer.Enabled:=True;
end;

procedure TMainForm.StopTimerScan;
begin
 Timer.Enabled:=False;
 EndScan;
end;

procedure TMainForm.TimerTimer(Sender: TObject);
var j:integer;
    //n,BufCount:integer;
begin
 try
   Inc(Cntr);
   for j:=0 to 4 do Tsp_xyLine(XYPlot.Series[j]).AddXY(Cntr, Random(4095));
   if Cntr=PntNum then StopTimerScan;
 except
  StopTimerScan;
  raise;
 end;
end;

{---------------------}
//StatusBar.Panels[0].Text:=Format('Scan %d Plot %d ms',[st1, st2]);
{---------------------}


procedure TMainForm.FormCreate(Sender: TObject);
var j:integer;
 procedure CreateCurve(gb: TCheckBox);
 begin
   with Tsp_XYLine.Create(gb.Owner) do begin
    LineAttr.Color:=gb.Font.Color;
    Active:=gb.Checked;
    Plot:=XYPlot;
    AddXY(2+gb.Tag,2); AddXY(20,10+10*gb.Tag);
   end;
 end;
 procedure FillChecks;
 begin
  Checks[0]:=CheckBox1;
  Checks[1]:=CheckBox2;
  Checks[2]:=CheckBox3;
  Checks[3]:=CheckBox4;
  Checks[4]:=CheckBox5;
 end;
begin //FormCreate
 FillChecks;
 for j:=0 to 4 do CreateCurve(Checks[j]);
 mBufferedDisplay.Checked:=XYPlot.BufferedDisplay;
 Application.OnHint:=ShowHint;
end;  //FormCreate

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 //     
 if not mStartScan.Enabled then  mAbortScanClick(Sender);
end;

procedure TMainForm.ShowHint(Sender: TObject);
begin
 StatusBar.Panels[1].Text:=GetLongHint(Application.Hint);
end;

procedure TMainForm.CheckBoxClick(Sender: TObject);
begin
 with Sender as TCheckBox do
 begin
  XYPlot.Series[Tag].Active:=Checked;
 end;
end;

procedure TMainForm.SpinEdit1Change(Sender: TObject);
begin
  with Sender as TSpinEdit, XYPlot do
  begin
   LeftAxis.TicksCount:=Value;
   BottomAxis.TicksCount:=Value;
  end;
end;


procedure TMainForm.mExitClick(Sender: TObject);
begin
 Close;
end;

procedure TMainForm.mAboutClick(Sender: TObject);
begin
 AboutBox.ShowModal;
end;


procedure TMainForm.mStndLimitsClick(Sender: TObject);
begin
 with XYPlot.LeftAxis do
 begin
  Min:=0; Max:=4096;
 end;
 with XYPlot.BottomAxis, SP do
 begin
  Min:=1; Max:=abs(SP.eCod-SP.bCod)+1;
 end;
end;

procedure TMainForm.mAutoLimitsClick(Sender: TObject);
begin
 SetPlotLimits(XYPlot);
end;

procedure TMainForm.mShowAllCurvesClick(Sender: TObject);
var j:integer;
begin
 for j:=0 to 4 do Checks[j].Checked:=True;
end;

procedure TMainForm.mHideAllCurvesClick(Sender: TObject);
 var j:integer;
begin
 for j:=0 to 4 do Checks[j].Checked:=False;
end;

procedure TMainForm.mBufferedDisplayClick(Sender: TObject);
begin
 mBufferedDisplay.Checked:=Not mBufferedDisplay.Checked;
 XYPlot.BufferedDisplay:=mBufferedDisplay.Checked;
end;

procedure TMainForm.mOnDrawEndClick(Sender: TObject);
begin
 mOnDrawEnd.Checked:=Not mOnDrawEnd.Checked;
 XYPlot.Invalidate;
end;

procedure TMainForm.mOnFieldDrawClick(Sender: TObject);
begin
 mOnFieldDraw.Checked:=Not mOnFieldDraw.Checked;
 XYPlot.Invalidate;
end;

procedure TMainForm.mStartScanClick(Sender: TObject);
begin
 mStndLimitsClick(Self);
 PrepareToScan;
 case ScanMode of
  smTimer: NewTimerScan;
  smQuickScan: ;
 end;
end;

procedure TMainForm.mAbortScanClick(Sender: TObject);
begin
 case ScanMode of
  smTimer: StopTimerScan;
  smQuickScan: BreakScan:=True;
 end;
end;

procedure TMainForm.mScanParamsClick(Sender: TObject);
begin
 RunParamsDlg;
end;

const
 EDS='This is Quasi Title by OnDrawEnd Event';

procedure TMainForm.XYPlotFieldDraw(Sender: TObject);
begin
  if Not mOnFieldDraw.Checked then Exit;
  with Sender as Tsp_xyPlot do
  with DCanvas do
  begin
    Pen.Color:=clWhite;
    Pen.Width:=1;
    with FieldRect do
    begin
      MoveTo((Left+Right) div 2, Top+1);
      LineTo((Left+Right) div 2, Bottom-1);
      MoveTo(Left+1, (Bottom+Top) div 2);
      LineTo(Right-1, (Bottom+Top) div 2);
      Font.Color:=clWhite;
      Font.Style:=[fsBold];
      TextOut((Left+Right) div 2+3, (Bottom+Top) div 2+3, 'OnFieldDraw')
    end;
  end
end;

procedure TMainForm.XYPlotDrawEnd(Sender: TObject);
begin
 if Not mOnDrawEnd.Checked then Exit;
 with Sender as Tsp_xyPlot do
  with DCanvas do
  begin
    Brush.Style:=bsClear;
    Font.Color:=clBlack;
    Font.Style:=[fsBold];
    TextOut((Width-TextWidth(EDS))div 2,
             (TopAxis.Margin-TextHeight(EDS))div 2  , EDS);
  end;
end;

procedure TMainForm.mCopyPlotMFClick(Sender: TObject);
begin
 XYPlot.CopyToClipboardMetafile;
end;

procedure TMainForm.mCopyPlotDIBClick(Sender: TObject);
begin
 XYPlot.CopyToClipboardBitmap;
end;

procedure TMainForm.XYPlotMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
 with StatusBar, XYPlot do
  Panels[0].Text:=Format('X %3.1f  Y %3.1f',
  [BottomAxis.P2V(X), LeftAxis.P2V(Y)])
end;


procedure TMainForm.XYPlotAxisZoom(Sender: Tsp_Axis; var min, max: Double;
  var CanZoom: Boolean);
begin
 with XYPlot do
  if (Sender=RightAxis) or (Sender=TopAxis) then CanZoom:=False;
end;

procedure TMainForm.mZVClick(Sender: TObject);
begin
 mZV.Checked:=True;
 if mZV.Checked then XYPlot.Zoom:=zpdVertical
end;

procedure TMainForm.mZHClick(Sender: TObject);
begin
 mZH.Checked:=True;
 if mZH.Checked then XYPlot.Zoom:=zpdHorizontal;
end;

procedure TMainForm.mZBClick(Sender: TObject);
begin
 mZB.Checked:=True;
 if mZB.Checked then XYPlot.Zoom:=zpdBoth;
end;

procedure TMainForm.mZNClick(Sender: TObject);
begin
 mZN.Checked :=True;
 if mZN.Checked then XYPlot.Zoom:=zpdNone;
end;

END.

