unit AxisDlg;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, sgr_def, Spin;

type
  TAxisesDlg = class(TForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    GroupBox1: TGroupBox;
    cbAutoY: TCheckBox;
    GroupBox2: TGroupBox;
    cbAutoX: TCheckBox;
    rseMaxY: TSpinEdit;
    rseMinY: TSpinEdit;
    rseMaxX: TSpinEdit;
    rseMinX: TSpinEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    procedure cbAutoYClick(Sender: TObject);
    procedure cbAutoXClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AxisesDlg: TAxisesDlg;

procedure SetPlotLimits(G:Tsp_XYPlot);

implementation

{$R *.DFM}

procedure SetPlotLimits(G:Tsp_XYPlot);
begin
 with AxisesDlg do begin
   with G.LeftAxis do begin
//    cbAutoY.Checked:=False;
    cbAutoYClick(nil);
    rseMinY.Value:=Round(Min);
    rseMaxY.Value:=Round(Max);
   end;
   with G.BottomAxis do begin
//    cbAutoX.Checked:=False;
    cbAutoXClick(nil);
    rseMinX.Value:=Round(Min);
    rseMaxX.Value:=Round(Max);
   end;
   if ShowModal<>mrOk then Exit;
   with G.LeftAxis  do begin
     if cbAutoY.Checked then
     begin
      AutoMin:=True; AutoMax:=True;
     end
     else begin
      Min:=rseMinY.Value;
      Max:=rseMaxY.Value;
     end;
   end;
   with G.BottomAxis do begin
     if cbAutoX.Checked then
     begin
      AutoMin:=True; AutoMax:=True;
     end
     else begin
      Min:=rseMinX.Value;
      Max:=rseMaxX.Value;
     end;
   end;
   with G.LeftAxis do
   begin
    AutoMin:=False; AutoMax:=False;
   end;
   with G.BottomAxis do
   begin
    AutoMin:=False; AutoMax:=False;
   end;
 end;
end;

procedure TAxisesDlg.cbAutoYClick(Sender: TObject);
begin
 if cbAutoY.Checked then begin
  rseMinY.Enabled:=False;
  rseMaxY.Enabled:=False;
 end else begin
  rseMinY.Enabled:=True;
  rseMaxY.Enabled:=True;
 end;
end;

procedure TAxisesDlg.cbAutoXClick(Sender: TObject);
begin
 if cbAutoX.Checked then begin
  rseMinX.Enabled:=False;
  rseMaxX.Enabled:=False;
 end else begin
  rseMinX.Enabled:=True;
  rseMaxX.Enabled:=True;
 end;
end;





end.
