unit ButtonList;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	FileCtrl, StdCtrls, Buttons, AdvSplitter, ExtCtrls, Clipbrd, RXSpin;

type
	TListButton = class(TObject)
		Btn: TSpeedButton;
		GlyphFile: string;
		constructor Create(AOwner: TComponent; FileName: string);
		destructor Destroy; override;
	end;

	TListButtonList = class(TList)
		constructor Create;
		destructor DestroyOwned;
		function ReadItem(Index: Integer): TListButton;
		procedure WriteItem(Index: Integer; Value: TListButton);
		procedure Add(Item: TListButton);
		function LastIndex: Integer;
		procedure Remove(Item: TListButton);
		procedure Clear;
		property Items[Index: Integer]: TListButton read ReadItem write WriteItem; default;
	end;


	TFrmButtonList = class(TForm)
		Panel1: TPanel;
		DriveComboBox1: TDriveComboBox;
    Split: TAdvSplitter;
		DirBox: TDirectoryListBox;
		XAutoRead: TCheckBox;
		BtnReadDir: TBitBtn;
    ScrlBtns: TScrollBox;
    Panel2: TPanel;
    BtnUp: TSpeedButton;
    BtnDown: TSpeedButton;
    BtnInactive: TSpeedButton;
    Label1: TLabel;
    Label2: TLabel;
    LbWidth: TLabel;
    Label3: TLabel;
    LbHeight: TLabel;
    LbFileName: TLabel;
    BMPFiles: TFileListBox;
    SpeedButton1: TSpeedButton;
    EdNumGlyphs: TRxSpinEdit;
		procedure BtnReadDirClick(Sender: TObject);
		procedure ScrlBtnsResize(Sender: TObject);
		procedure FormCreate(Sender: TObject);
    procedure ListButtonClick(Sender: TObject);
    procedure EdNumGlyphsClick(Sender: TObject);
    procedure DirBoxChange(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
	private
		BtnList: TListButtonList;
		BtnsPerRow: Integer;
		SelectedBtn: TListButton;
		procedure AddButton(PicFile: string; List: TListButtonList; BtnParent: TWinControl);
		procedure ReorderButtons(List: TListButtonList);
		function FindButton(Btn: TSpeedButton; List: TListButtonList): TListButton;
	public
		{ Public-Deklarationen }
	end;

const
	SpacingX = 50;
	SpacingY = 50;
	OffsX = 10;
	OffsY = 10;

var
	FrmButtonList: TFrmButtonList;

implementation

{$R *.DFM}


constructor TListButton.Create(AOwner: TComponent; FileName: string);
begin
	inherited Create;
	Btn := TSpeedButton.Create(AOwner);
	GlyphFile := FileName;
end;

destructor TListButton.Destroy;
begin
	Btn.Free;
	inherited;
end;

{	******************************************************************************
	*****          Klasse TListButtonList - Liste aus TListButton            *******
	******************************************************************************}

constructor TListButtonList.Create;
begin
	inherited Create;
end;

function TListButtonList.ReadItem(Index: Integer): TListButton;
begin
	Result := inherited Items[Index];
end;

procedure TListButtonList.WriteItem(Index: Integer; Value: TListButton);
begin
	inherited Items[Index] := Value;
end;

procedure TListButtonList.Add(Item: TListButton);
begin
	inherited Add(Item);
end;

function TListButtonList.LastIndex: Integer;
begin
	Result := Count - 1;
end;

procedure TListButtonList.Remove(Item: TListButton);
begin
	inherited Remove(Item);
end;

procedure TListButtonList.Clear;
begin
	while Count > 0 do begin
		Items[0].Free;
		Delete(0);
	end;
end;

destructor TListButtonList.DestroyOwned;
begin
	Clear;
	inherited Destroy;
end;


//******************************************************************************
//******************************************************************************
//******************************************************************************

procedure TFrmButtonList.AddButton(PicFile: string; List: TListButtonList; BtnParent: TWinControl);
var
	Btn: TListButton;
	Nr, GCount: Integer;
begin
	Nr := List.Count;
	Btn := TListButton.Create(Self, PicFile);
	with Btn.Btn do begin
		Parent := BtnParent;
		Width := 30;
		Height := 30;
		Left := (Nr MOD BtnsPerRow) * SpacingX + OffsX;
		Top := (Nr DIV BtnsPerRow) * SpacingY + OffsY;
		GroupIndex := Nr + 1;
		AllowAllUp := True;
		Glyph.LoadFromFile(PicFile);
		OnClick := ListButtonClick;
		if Glyph.Width MOD Glyph.Height = 0 then
		begin
			GCount := Glyph.Width DIV Glyph.Height;
			if GCount > 4 then
				GCount := 1;
			NumGlyphs := GCount;
		end
		else
			NumGlyphs := 1;
		List.Add(Btn);
	end;
end;

procedure TFrmButtonList.ReorderButtons(List: TListButtonList);
var
	I: Integer;
begin
	for I := 0 to List.LastIndex do
	begin
		List[I].Btn.Left := (I MOD BtnsPerRow) * SpacingX + OffsX;
		List[I].Btn.Top := (I DIV BtnsPerRow) * SpacingY + OffsY;
	end;
end;

procedure TFrmButtonList.BtnReadDirClick(Sender: TObject);
var
	I: Integer;
begin
	SelectedBtn := nil;
	BtnList.Clear;
	for I := 0 to BMPFiles.Items.Count-1 do
		AddButton(BMPFiles.Items[I], BtnList, ScrlBtns);
end;

procedure TFrmButtonList.ScrlBtnsResize(Sender: TObject);
begin
	BtnsPerRow := (ScrlBtns.Width-OffsX) DIV SpacingX;
	ReorderButtons(BtnList);
end;

procedure TFrmButtonList.FormCreate(Sender: TObject);
begin
	BtnList := TListButtonList.Create;
	ScrlBtnsResize(ScrlBtns);
end;


function TFrmButtonList.FindButton(Btn: TSpeedButton; List: TListButtonList): TListButton;
var
	I: Integer;
begin
	Result := nil;
	for I := 0 to List.LastIndex do begin
		if List[I].Btn = Btn then
		begin
			Result := List[I];
			Break;
		end;
	end;
end;

procedure TFrmButtonList.ListButtonClick(Sender: TObject);
begin
	if Assigned(SelectedBtn) then
		SelectedBtn.Btn.Down := False;
	if Sender is TSpeedButton then
		SelectedBtn := FindButton(TSpeedButton(Sender), BtnList)
	else
		SelectedBtn := nil;
	if Assigned(SelectedBtn) then
	begin
		BtnUp.Down := False;
		BtnUp.Glyph := SelectedBtn.Btn.Glyph;
		BtnDown.Glyph := SelectedBtn.Btn.Glyph;
		BtnInactive.Glyph := SelectedBtn.Btn.Glyph;
		BtnUp.NumGlyphs := SelectedBtn.Btn.NumGlyphs;
		BtnDown.NumGlyphs := SelectedBtn.Btn.NumGlyphs;
		BtnInactive.NumGlyphs := SelectedBtn.Btn.NumGlyphs;
		EdNumGlyphs.Value := SelectedBtn.Btn.NumGlyphs;
		LbFileName.Caption := SelectedBtn.GlyphFile;
		EdNumGlyphs.Enabled := True;
		LbWidth.Caption := IntToStr(SelectedBtn.Btn.Glyph.Width);
		LbHeight.Caption := IntToStr(SelectedBtn.Btn.Glyph.Height);
	end
	else begin
		BtnUp.Down := False;
		BtnUp.Glyph := nil;
		BtnDown.Glyph := nil;
		BtnInactive.Glyph := nil;
		EdNumGlyphs.Value := 1;
		EdNumGlyphs.Enabled := False;
		LbFileName.Caption := 'Button nicht gefunden!';
		LbWidth.Caption := '?';
		LbHeight.Caption := '?';
	end;
end;

procedure TFrmButtonList.EdNumGlyphsClick(Sender: TObject);
begin
	BtnUp.NumGlyphs := Trunc(EdNumGlyphs.Value);
	BtnDown.NumGlyphs := Trunc(EdNumGlyphs.Value);
	BtnInactive.NumGlyphs := Trunc(EdNumGlyphs.Value);
	if Assigned(SelectedBtn) then
		SelectedBtn.Btn.NumGlyphs := Trunc(EdNumGlyphs.Value);
end;

procedure TFrmButtonList.DirBoxChange(Sender: TObject);
begin
	if XAutoRead.Checked then
		BtnReadDir.OnClick(BtnReadDir);
	ListButtonClick(Self);
end;

procedure TFrmButtonList.SpeedButton1Click(Sender: TObject);
begin
	if Assigned(SelectedBtn) then
		Clipboard.Assign(SelectedBtn.Btn.Glyph);
end;

end.
