program scrnlite;
{**********************************************}
{       Screen Lights v1.0                     }
{       Display flashing red lights on desktop }
{       written by Martin Platt                }
{       29th December 97                       }
{       Freeware 1997 SoftSol                  }
{                                              }
{       Software Solutions                     }
{       martin.platt@usa.net                   }
{**********************************************}

{
 A friend (thanks John!) gave me a copy of xmaslite, a small Win32
 program that placed a number of flashing lights on the Win95 desktop.
 I found it amusing and was amazed how small it was, only 29k!  I set
 myself the task of recreating the program using Delphi in an attempt
 to make a similar program with a smaller 'footprint' and this is
 the result.  Initially I used Delphi's TCanvas component to place
 the lights but the Graphics unit made the program a bloating 150k so
 it became obvious that a delve into the depths of Win API was required.
 Borland have several API examples on their web site and with their
 help and my limited knowledge of Win API, I fumbled and groped and
 eventually came up with this program.  It's only 23k and has a couple
 of additional features (popup Menu and About box) and Borland must
 be congratulated for producing such an excellent compiler... and
 Delphi too!

 If you alter the source (for better or worse) and produce some
 amazing graphical delight, I'd be very gratful for a copy!

 martin.platt@usa.net
 }

{$D scrnlite}

{$C MOVEABLE PRELOAD PERMANENT}

{$IFDEF Win32}

{$R SSXMAS32.RES}
{$R CANDLES.RES}
 
uses
  ShellAPI,
  Windows,
  Messages;

type
  TwMsg = Longint;
  TwParam = Longint;
  TlParam = Longint;

{$ELSE}

uses
 {$IFDEF VER15}
  WinTypes, WinProcs, Win31;
 {$ELSE}
 {$IFDEF VER70}
  WinTypes, WinProcs, Win31;
 {$ELSE}
  WinTypes, WinProcs, Messages;
 {$ENDIF}
 {$ENDIF}

type
  TwMsg = Word;
  TwParam = Word;
  TlParam = Longint;

{$ENDIF}

type
  TWinVersion = record
   WinMajor : Byte;
   WinMinor : Byte;
   DosMajor : Byte;
   DosMinor : Byte;
  end;

const
  APPNAME = 'Screen Lights';
  CLASSNAME ='SSXMASDIALOGCLASS';
  sAbout = 'Screen Lights!' + chr(13) + 'by Software Solutions' + chr(13) + chr(13) + 'martin.platt@usa.net' ;

  LIGHT_WIDTH   = 32 ;
  LIGHT_HEIGHT  = 16 ;
  TLIGHT_WIDTH  = 16 ;
  TLIGHT_HEIGHT = 32 ;

  LEFT  = 1 ;
  RIGHT = 2 ;

  LIGHTS_ON = 1 ;
  LIGHTS_OFF = 2 ;

  ITEM_ABOUT = 101 ; {Menu item}
  ITEM_CLOSE = 102 ; {Menu item}

  WM_TOOLTRAYICON = WM_USER+1;
  WM_RESETTOOLTIP = WM_USER+2;

var
  boolHigh : boolean ;
  DC: HDC;
  hDCMemory   : HDC ;
  iScreenX    : integer ;
  iScreenY    : integer ;
  iVSpace     : integer ; {Vertical spacing between lights}
  iHSpace     : integer ; {Horizontal spacing between lights}
  message     : TMsg ;
  IconData    : TNOTIFYICONDATA;
  TimerID     : UINT ;
  hPopMenu    : HMENU ;
  cursorPoint : TPoint ;

  {Left bmps}
  bmpL90Mask  : HBITMAP ;
  bmpL45Mask  : HBITMAP ;
  bmpL135Mask : HBITMAP ;
  bmpL90      : HBITMAP ;
  bmpL45      : HBITMAP ;
  bmpL135     : HBITMAP ;
  bmpL90Low   : HBITMAP ;
  bmpL45Low   : HBITMAP ;
  bmpL135Low  : HBITMAP ;

  {Right bmps}
  bmpR90Mask  : HBITMAP ;
  bmpR45Mask  : HBITMAP ;
  bmpR135Mask : HBITMAP ;
  bmpR90      : HBITMAP ;
  bmpR45      : HBITMAP ;
  bmpR135     : HBITMAP ;
  bmpR90Low   : HBITMAP ;
  bmpR45Low   : HBITMAP ;
  bmpR135Low  : HBITMAP ;

  {Top bmps}
  bmpT90Mask  : HBITMAP ;
  bmpT45Mask  : HBITMAP ;
  bmpT135Mask : HBITMAP ;
  bmpT90      : HBITMAP ;
  bmpT45      : HBITMAP ;
  bmpT135     : HBITMAP ;
  bmpT90Low   : HBITMAP ;
  bmpT45Low   : HBITMAP ;
  bmpT135Low  : HBITMAP ;

{-------------------------------------------------------------------}

procedure HorizontalLightsOdd(iState : integer) ;
{Switch Odd numbered horizontal lights on or off}

var
  bmp90Show  : HBITMAP ;
  bmp45Show  : HBITMAP ;
  bmp135Show : HBITMAP ;
  bmp90MaskShow  : HBITMAP ;
  bmp45MaskShow  : HBITMAP ;
  bmp135MaskShow : HBITMAP ;

begin
  bmp90MaskShow  := bmpT90Mask ;
  bmp45MaskShow  := bmpT45Mask ;
  bmp135MaskShow := bmpT135Mask ;

  if iState = LIGHTS_ON then
  begin
    {Left Lights 90 High}
    bmp90Show := bmpT90  ;
    bmp45Show := bmpT45 ;
    bmp135Show := bmpT135 ;
  end
  else
  begin
    bmp90Show := bmpT90Low  ;
    bmp45Show := bmpT45Low  ;
    bmp135Show := bmpT135Low  ;
  end ;

  {Top Lights 90}
  SelectObject(hDCMemory, bmp90MaskShow);
  BitBlt(DC, (iHSpace * 1) + 0, 0, TLIGHT_WIDTH, TLIGHT_HEIGHT, hDCMemory, 0, 0, SRCAND) ;
  BitBlt(DC, (iHSpace * 7) + 0, 0, TLIGHT_WIDTH, TLIGHT_HEIGHT, hDCMemory, 0, 0, SRCAND) ;

  SelectObject(hDCMemory, bmp90Show);
  BitBlt(DC, (iHSpace * 1) + 0, 0,TLIGHT_WIDTH, TLIGHT_HEIGHT, hDCMemory, 0, 0, SRCPAINT) ;
  BitBlt(DC, (iHSpace * 7) + 0, 0,TLIGHT_WIDTH, TLIGHT_HEIGHT, hDCMemory, 0, 0, SRCPAINT) ;

  {Left Lights 45}

  SelectObject(hDCMemory, bmp45MaskShow);
  BitBlt(DC, (iHSpace * 5) + 0, 0, TLIGHT_WIDTH, TLIGHT_HEIGHT, hDCMemory, 0, 0, SRCAND) ;
  BitBlt(DC, (iHSpace * 11) + 0, 0, TLIGHT_WIDTH, TLIGHT_HEIGHT, hDCMemory, 0, 0, SRCAND) ;

  SelectObject(hDCMemory, bmp45Show);
  BitBlt(DC, (iHSpace * 5) + 0, 0, TLIGHT_WIDTH, TLIGHT_HEIGHT, hDCMemory, 0, 0, SRCPAINT) ;
  BitBlt(DC, (iHSpace * 11) + 0, 0, TLIGHT_WIDTH, TLIGHT_HEIGHT, hDCMemory, 0, 0, SRCPAINT) ;

  {Left Lights 135}

  SelectObject(hDCMemory, bmp135MaskShow);
  BitBlt(DC, (iHSpace * 3) + 0, 0, TLIGHT_WIDTH, TLIGHT_HEIGHT, hDCMemory, 0, 0, SRCAND) ;
  BitBlt(DC, (iHSpace * 9) + 0, 0, TLIGHT_WIDTH, TLIGHT_HEIGHT, hDCMemory, 0, 0, SRCAND) ;

  SelectObject(hDCMemory, bmp135Show);
  BitBlt(DC, (iHSpace * 3) + 0, 0, TLIGHT_WIDTH, TLIGHT_HEIGHT, hDCMemory, 0, 0, SRCPAINT) ;
  BitBlt(DC, (iHSpace * 9) + 0, 0, TLIGHT_WIDTH, TLIGHT_HEIGHT, hDCMemory, 0, 0, SRCPAINT) ;
end;

{-------------------------------------------------------------------}

procedure HorizontalLightsEven(iState : integer) ;
{Switch Odd numbered horizontal lights on or off}

var
  bmp90Show  : HBITMAP ;
  bmp45Show  : HBITMAP ;
  bmp135Show : HBITMAP ;
  bmp90MaskShow  : HBITMAP ;
  bmp45MaskShow  : HBITMAP ;
  bmp135MaskShow : HBITMAP ;

begin
  bmp90MaskShow  := bmpT90Mask ;
  bmp45MaskShow  := bmpT45Mask ;
  bmp135MaskShow := bmpT135Mask ;

  if iState = LIGHTS_ON then
  begin
    {Left Lights 90 High}
    bmp90Show := bmpT90  ;
    bmp45Show := bmpT45 ;
    bmp135Show := bmpT135 ;
  end
  else
  begin
    bmp90Show := bmpT90Low  ;
    bmp45Show := bmpT45Low  ;
    bmp135Show := bmpT135Low  ;
  end ;

  {Top Lights 90}
  SelectObject(hDCMemory, bmp90MaskShow);
  BitBlt(DC, (iHSpace * 4) + 0, 0, TLIGHT_WIDTH, TLIGHT_HEIGHT, hDCMemory, 0, 0, SRCAND) ;
  BitBlt(DC, (iHSpace * 10) + 0, 0, TLIGHT_WIDTH, TLIGHT_HEIGHT, hDCMemory, 0, 0, SRCAND) ;

  SelectObject(hDCMemory, bmp90Show);
  BitBlt(DC, (iHSpace * 4) + 0, 0,TLIGHT_WIDTH, TLIGHT_HEIGHT, hDCMemory, 0, 0, SRCPAINT) ;
  BitBlt(DC, (iHSpace * 10) + 0, 0,TLIGHT_WIDTH, TLIGHT_HEIGHT, hDCMemory, 0, 0, SRCPAINT) ;

  {Left Lights 45}
  SelectObject(hDCMemory, bmp45MaskShow);
  BitBlt(DC, (iHSpace * 2) + 0, 0, TLIGHT_WIDTH, TLIGHT_HEIGHT, hDCMemory, 0, 0, SRCAND) ;
  BitBlt(DC, (iHSpace * 8) + 0, 0, TLIGHT_WIDTH, TLIGHT_HEIGHT, hDCMemory, 0, 0, SRCAND) ;

  SelectObject(hDCMemory, bmp45Show);
  BitBlt(DC, (iHSpace * 2) + 0, 0, TLIGHT_WIDTH, TLIGHT_HEIGHT, hDCMemory, 0, 0, SRCPAINT) ;
  BitBlt(DC, (iHSpace * 8) + 0, 0, TLIGHT_WIDTH, TLIGHT_HEIGHT, hDCMemory, 0, 0, SRCPAINT) ;

  {Left Lights 135}
  SelectObject(hDCMemory, bmp135MaskShow);
  BitBlt(DC, (iHSpace * 6) + 0, 0, TLIGHT_WIDTH, TLIGHT_HEIGHT, hDCMemory, 0, 0, SRCAND) ;
  BitBlt(DC, (iHSpace * 12) + 0, 0, TLIGHT_WIDTH, TLIGHT_HEIGHT, hDCMemory, 0, 0, SRCAND) ;

  SelectObject(hDCMemory, bmp135Show);
  BitBlt(DC, (iHSpace * 6) + 0, 0, TLIGHT_WIDTH, TLIGHT_HEIGHT, hDCMemory, 0, 0, SRCPAINT) ;
  BitBlt(DC, (iHSpace * 12) + 0, 0, TLIGHT_WIDTH, TLIGHT_HEIGHT, hDCMemory, 0, 0, SRCPAINT) ;
end;

{-------------------------------------------------------------------}

procedure VerticalLightsOdd(iState : integer; iSide : integer) ;
{Switch Odd numbered vertical lights on or off}

var
  bmp90Show  : HBITMAP ;
  bmp45Show  : HBITMAP ;
  bmp135Show : HBITMAP ;
  bmp90MaskShow  : HBITMAP ;
  bmp45MaskShow  : HBITMAP ;
  bmp135MaskShow : HBITMAP ;
  iStart : integer ; {starting horizontal position}

begin
  if iSide = LEFT then
  begin
    iStart := 0 ;
    bmp90MaskShow  := bmpL90Mask ;
    bmp45MaskShow  := bmpL45Mask ;
    bmp135MaskShow := bmpL135Mask ;
  end
  else {Right of screen}
  begin
    iStart := iScreenX - 32 - 5 ;
    bmp90MaskShow  := bmpR90Mask ;
    bmp45MaskShow  := bmpR45Mask ;
    bmp135MaskShow := bmpR135Mask ;
  end ;

  if iState = LIGHTS_ON then
  begin
    if iSide = LEFT then
    begin
      {Left Lights 90 High}
      bmp90Show := bmpL90  ;
      bmp45Show := bmpL45 ;
      bmp135Show := bmpL135 ;
    end
    else {Right of screen}
    begin
      bmp90Show := bmpR90  ;
      bmp45Show := bmpR45 ;
      bmp135Show := bmpR135 ;
    end ;
  end
  else
  begin
    if iSide = LEFT then
    begin
      {Left Lights 90 Low}
      bmp90Show := bmpL90Low  ;
      bmp45Show := bmpL45Low  ;
      bmp135Show := bmpL135Low  ;
    end
    else
    begin
      {Right Lights 90 Low}
      bmp90Show := bmpR90Low  ;
      bmp45Show := bmpR45Low  ;
      bmp135Show := bmpR135Low  ;
    end ;
  end ;

  {Left Lights 90}
  SelectObject(hDCMemory, bmp90MaskShow);
  BitBlt(DC, iStart, (iVSpace * 5) + 5, LIGHT_WIDTH, LIGHT_HEIGHT, hDCMemory, 0, 0, SRCAND) ;

  SelectObject(hDCMemory, bmp90Show);
  BitBlt(DC, iStart, (iVSpace * 5) + 5, LIGHT_WIDTH, LIGHT_HEIGHT, hDCMemory, 0, 0, SRCPAINT) ;

  {Left Lights 45}
  SelectObject(hDCMemory, bmp45MaskShow);
  BitBlt(DC, iStart, (iVSpace * 7) + 5, LIGHT_WIDTH, LIGHT_HEIGHT, hDCMemory, 0, 0, SRCAND) ;

  SelectObject(hDCMemory, bmp45Show);
  BitBlt(DC, iStart, (iVSpace * 7) + 5, LIGHT_WIDTH, LIGHT_HEIGHT, hDCMemory, 0, 0, SRCPAINT) ;

  {Left Lights 135}
  SelectObject(hDCMemory, bmp135MaskShow);
  BitBlt(DC, iStart, (iVSpace * 1) + 5, LIGHT_WIDTH, LIGHT_HEIGHT, hDCMemory, 0, 0, SRCAND) ;
  BitBlt(DC, iStart, (iVSpace * 3) + 5, LIGHT_WIDTH, LIGHT_HEIGHT, hDCMemory, 0, 0, SRCAND) ;

  SelectObject(hDCMemory, bmp135Show);
  BitBlt(DC, iStart, (iVSpace * 1) + 5, LIGHT_WIDTH, LIGHT_HEIGHT, hDCMemory, 0, 0, SRCPAINT) ;
  BitBlt(DC, iStart, (iVSpace * 3) + 5, LIGHT_WIDTH, LIGHT_HEIGHT, hDCMemory, 0, 0, SRCPAINT) ;
end;

{-------------------------------------------------------------------}

procedure VerticalLightsEven(iState : integer; iSide : integer) ;
{Switch Even numbered vertical lights on or off}

var
  bmp90Show  : HBITMAP ;
  bmp45Show  : HBITMAP ;
  bmp135Show : HBITMAP ;
  bmp90MaskShow  : HBITMAP ;
  bmp45MaskShow  : HBITMAP ;
  bmp135MaskShow : HBITMAP ;
  iStart : integer ; {starting horizontal position}

begin
  if iSide = LEFT then
  begin
    iStart := 0 ;
    bmp90MaskShow  := bmpL90Mask ;
    bmp45MaskShow  := bmpL45Mask ;
    bmp135MaskShow := bmpL135Mask ;
  end
  else {Right of screen}
  begin
    iStart := iScreenX - 32 - 3 ;
    bmp90MaskShow  := bmpR90Mask ;
    bmp45MaskShow  := bmpR45Mask ;
    bmp135MaskShow := bmpR135Mask ;
  end ;

  if iState = LIGHTS_ON then
  begin
    if iSide = LEFT then
    begin
      {Left Lights 90 High}
      bmp90Show := bmpL90  ;
      bmp45Show := bmpL45 ;
      bmp135Show := bmpL135 ;
    end
    else {Right of screen}
    begin
      bmp90Show := bmpR90  ;
      bmp45Show := bmpR45 ;
      bmp135Show := bmpR135 ;
    end ;
  end
  else
  begin
    if iSide = LEFT then
    begin
      {Left Lights 90 Low}
      bmp90Show := bmpL90Low  ;
      bmp45Show := bmpL45Low  ;
      bmp135Show := bmpL135Low  ;
    end
    else
    begin
      {Right Lights 90 Low}
      bmp90Show := bmpR90Low  ;
      bmp45Show := bmpR45Low  ;
      bmp135Show := bmpR135Low  ;
    end ;
  end ;

  {Left Lights 90}
  SelectObject(hDCMemory, bmp90MaskShow);
  BitBlt(DC, iStart, (iVSpace * 2) + 5, LIGHT_WIDTH, LIGHT_HEIGHT, hDCMemory, 0, 0, SRCAND) ;
  BitBlt(DC, iStart, (iVSpace * 8) + 5, LIGHT_WIDTH, LIGHT_HEIGHT, hDCMemory, 0, 0, SRCAND) ;

  SelectObject(hDCMemory, bmp90Show);
  BitBlt(DC, iStart, (iVSpace * 2) + 5, LIGHT_WIDTH, LIGHT_HEIGHT, hDCMemory, 0, 0, SRCPAINT) ;
  BitBlt(DC, iStart, (iVSpace * 8) + 5, LIGHT_WIDTH, LIGHT_HEIGHT, hDCMemory, 0, 0, SRCPAINT) ;

  {Left Lights 45}
  SelectObject(hDCMemory, bmp45MaskShow);
  BitBlt(DC, iStart, (iVSpace * 4) + 5, LIGHT_WIDTH, LIGHT_HEIGHT, hDCMemory, 0, 0, SRCAND) ;

  SelectObject(hDCMemory, bmp45Show);
  BitBlt(DC, iStart, (iVSpace * 4) + 5, LIGHT_WIDTH, LIGHT_HEIGHT, hDCMemory, 0, 0, SRCPAINT) ;

  {Left Lights 135}
  SelectObject(hDCMemory, bmp135MaskShow);
  BitBlt(DC, iStart, (iVSpace * 6) + 5, LIGHT_WIDTH, LIGHT_HEIGHT, hDCMemory, 0, 0, SRCAND) ;

  SelectObject(hDCMemory, bmp135Show);
  BitBlt(DC, iStart, (iVSpace * 6) + 5, LIGHT_WIDTH, LIGHT_HEIGHT, hDCMemory, 0, 0, SRCPAINT) ;
end;

{-------------------------------------------------------------------}

function MyTimerProc(Dialog: HWnd; Msg: TwMsg; idEvent: UINT; dwTime: DWORD): Bool
{$IFDEF Win32}
stdcall;
{$ELSE} ;
export;
{$ENDIF}

begin
  if boolHigh then
  begin
    {Switch even numbered lights on}
    VerticalLightsEven(LIGHTS_ON, LEFT) ;
    VerticalLightsEven(LIGHTS_ON, RIGHT) ;
    HorizontalLightsEven(LIGHTS_ON) ;

    {Switch odd numbered lights off}
    VerticalLightsOdd(LIGHTS_OFF, LEFT) ;
    VerticalLightsOdd(LIGHTS_OFF, RIGHT) ;
    HorizontalLightsOdd(LIGHTS_OFF) ;
    boolHigh := False
  end
  else
  begin
    {Switch even numbered lights off}
    VerticalLightsEven(LIGHTS_OFF, LEFT) ;
    VerticalLightsEven(LIGHTS_OFF, RIGHT) ;
    HorizontalLightsEven(LIGHTS_OFF) ;

    {Switch odd numbered lights on}
    VerticalLightsOdd(LIGHTS_ON, LEFT) ;
    VerticalLightsOdd(LIGHTS_ON, RIGHT) ;
    HorizontalLightsOdd(LIGHTS_ON) ;
    boolHigh := True ;
  end ;
end;


{-------------------------------------------------------------------}

function SSWindowProc(ssWindow: HWnd; Msg: TwMsg; WParam: TwParam; LParam: TlParam): Longbool
{$IFDEF Win32}
stdcall;
{$ELSE} ;
export;
{$ENDIF}

begin
  SSWindowProc := True;
  case Msg Of
    WM_TOOLTRAYICON:
    begin
      case lParam of
         WM_LBUTTONUP :
         begin
           PostMessage(ssWindow, WM_DESTROY, WParam, LParam) ;
           SSWindowProc := False;
           exit;
         end ;
         WM_RBUTTONUP :
         begin
           GetCursorPos(cursorPoint) ;
           TrackPopupMenu(hPopMenu, TPM_RIGHTALIGN, cursorPoint.x, cursorPoint.y, 0, ssWindow, nil) ;
         end ;
      end;
    end ;
    WM_COMMAND:
    begin
      case wParam of
        ITEM_ABOUT :
        begin
          Messagebox(0, sAbout,
                APPNAME,
                MB_ICONINFORMATION + MB_OK);
        end ;
        ITEM_CLOSE:
        begin
          PostMessage(ssWindow, WM_DESTROY, WParam, LParam) ;
          SSWindowProc := False;
          exit;
        end ;
      end ;
    end ;
    WM_CLOSE: {No close icon so not processed}
    begin
      PostQuitMessage(0) ;
    end ;
    WM_DESTROY:
    begin
      PostQuitMessage(0) ;
      KillTimer(ssWindow, TimerID) ;
      SSWindowProc := False;
      exit;
    end ;
  end ;
 {do any default class handling here for Window Proc}
  SSWindowProc := Longbool(DefWindowProc(ssWindow, Msg, WParam, LParam));
end;

{-------------------------------------------------------------------}

function MainDlgProc(Dialog: HWnd; Msg: TwMsg; WParam: TwParam; LParam: TlParam): Longbool
{$IFDEF Win32}
stdcall;
{$ELSE} ;
export;
{$ENDIF}

begin
  MainDlgProc := True;
  case Msg Of
    WM_CREATE:
    begin
    end ;
    WM_CLOSE:
    begin
      EndDialog(Dialog, IDOK);
    end ;
  end ;
 {do any default class handling here for Dialog Proc}
  MainDlgProc := Longbool(DefDlgProc(Dialog, Msg, WParam, LParam));
end;

{-------------------------------------------------------------------}

procedure Init;
var
  WindowClass: TWndClass;
  WinVer: TWinVersion;
  ProgramIcon : HICON ;
  Window: HWnd;

begin
  Longint(WinVer) := GetVersion;
  if ((WinVer.WinMajor < 3) OR
      ((WinVer.WinMajor = 3) AND
       (WinVer.WinMinor < 10)) ) then
  begin
    Messagebox(0, 'Microsoft Windows 3.10 or greater required!',
               APPNAME,
               MB_OK);
    halt;
  end;

  if FindWindow(CLASSNAME, APPNAME) <> 0 then
  begin
    Messagebox(0, 'Multiple Sessions not allowed',
               APPNAME,
               MB_OK);
    halt;
  end
  else
  begin
    WindowClass.Style := CS_BYTEALIGNWINDOW;
    WindowClass.lpfnWndProc := @SSWindowProc;
    WindowClass.cbClsExtra := 0;
    WindowClass.cbWndExtra := DLGWINDOWEXTRA;
    WindowClass.hInstance  := hInstance;
    WindowClass.hIcon      := LoadIcon(0, IDI_APPLICATION);
    WindowClass.hCursor    := LoadCursor(0, IDC_ARROW);
    WindowClass.hbrBackground  := GetStockObject(WHITE_BRUSH);
    WindowClass.lpszMenuName   := nil;
    WindowClass.lpszClassName  := CLASSNAME;

    if not Bool(RegisterClass(WindowClass)) then
    begin
      Messagebox(0, 'RegisterClass Failed!',
                 APPNAME,
                 MB_OK);
      halt;
    end;

    {Create Window}
    Window := CreateWindow(CLASSNAME,               {Class name}
            'SoftSol',          {Window name}
            ws_OverlappedWindow,  {style}
            cw_UseDefault,        {X}
            cw_UseDefault,        {Y}
            300,                  {Width}
            300,                  {Height}
            HWND_DESKTOP ,        {WndParent}
            0,                    {Menu}
            HInstance,            {Instance}
            nil);                 {structure creation parameter}



//  ShowWindow(Window, CmdShow);
//  UpdateWindow(Window);

    {Get Desktop Device Context}
    DC := CreateDC('DISPLAY', nil, nil, nil);
    hdcMemory := CreateCompatibleDC(DC);

    {Get Screen Size}
    iScreenX := GetSystemMetrics(SM_CXSCREEN) ;
    iScreenY := GetSystemMetrics(SM_CYSCREEN) ;
    iVSpace := (iScreenY - 50) div 8 ;
    iHSpace := (iScreenX - 50) div 12 ;

    {Create Popup Menu}
    hPopMenu := CreatePopupMenu ;
    AppendMenu(hPopMenu, MF_ENABLED, ITEM_ABOUT, 'About') ;
    AppendMenu(hPopMenu, MF_ENABLED, ITEM_CLOSE, 'Close') ;

    {Load the Lights}
    {Left Masks}
    bmpL90Mask := LoadBitmap(HInstance, 'L90MASK') ;
    bmpL45Mask := LoadBitmap(HInstance, 'L45MASK') ;
    bmpL135Mask := LoadBitmap(HInstance, 'L135MASK') ;

    {Right Masks}
    bmpR90Mask := LoadBitmap(HInstance, 'R90MASK') ;
    bmpR45Mask := LoadBitmap(HInstance, 'R45MASK') ;
    bmpR135Mask := LoadBitmap(HInstance, 'R135MASK') ;

    {Top Masks}
    bmpT90Mask := LoadBitmap(HInstance, 'T90MASK') ;
    bmpT45Mask := LoadBitmap(HInstance, 'T45MASK') ;
    bmpT135Mask := LoadBitmap(HInstance, 'T135MASK') ;

    {Left Lights High}
    bmpL90 := LoadBitmap(HInstance, 'L90PIC') ;
    bmpL45 := LoadBitmap(HInstance, 'L45PIC') ;
    bmpL135 := LoadBitmap(HInstance, 'L135PIC') ;

    {Right Lights High}
    bmpR90 := LoadBitmap(HInstance, 'R90PIC') ;
    bmpR45 := LoadBitmap(HInstance, 'R45PIC') ;
    bmpR135 := LoadBitmap(HInstance, 'R135PIC') ;

    {Top Lights High}
    bmpT90 := LoadBitmap(HInstance, 'T90PIC') ;
    bmpT45 := LoadBitmap(HInstance, 'T45PIC') ;
    bmpT135 := LoadBitmap(HInstance, 'T135PIC') ;

    {Left Lights Low}
    bmpL90Low := LoadBitmap(HInstance, 'L90PICLOW') ;
    bmpL45Low := LoadBitmap(HInstance, 'L45PICLOW') ;
    bmpL135Low := LoadBitmap(HInstance, 'L135PICLOW') ;

    {Right Lights Low}
    bmpR90Low := LoadBitmap(HInstance, 'R90PICLOW') ;
    bmpR45Low := LoadBitmap(HInstance, 'R45PICLOW') ;
    bmpR135Low := LoadBitmap(HInstance, 'R135PICLOW') ;

    {Top Lights Low}
    bmpT90Low := LoadBitmap(HInstance, 'T90PICLOW') ;
    bmpT45Low := LoadBitmap(HInstance, 'T45PICLOW') ;
    bmpT135Low := LoadBitmap(HInstance, 'T135PICLOW') ;

    {Load Program Icon}
    ProgramIcon := LoadIcon(HInstance, 'SSICON') ;

    {Install the Tray Icon}
    IconData.cbSize := sizeof(TNOTIFYICONDATA);
    IconData.wnd := Window;
    IconData.uID := 0;
    IconData.uFlags := NIF_MESSAGE + NIF_ICON + NIF_TIP;
    IconData.hIcon := ProgramIcon;
    IconData.szTip := 'Screen Lights!' ;
    IconData.uCallbackMessage := WM_TOOLTRAYICON;

    if not Shell_NotifyIcon(NIM_ADD,@IconData) then
    begin
      Messagebox(0, 'Shell Notify Failed!',
                 APPNAME,
                 MB_OK);
      halt;
    end ;

    {Install the Timer callback function}
    TimerID := SetTimer(0, 0, 500, @MyTimerProc);
    if TimerID = 0 then
    begin
      Messagebox(0, 'SetTimer Failed!',
                 APPNAME,
                 MB_OK);
      halt;
    end ;
  end;
end;

{-------------------------------------------------------------------}

procedure MyWinMain;
begin
//  DialogBox(hInstance, 'SSXMAS', 0, @MainDlgProc);
end;


{-------------------------------------------------------------------}

{WinMain}
begin
  Init;
  MyWinMain;

  while GetMessage(Message, 0, 0, 0) do
  begin
    TranslateMessage(Message);
    DispatchMessage(Message);
  end;

  Shell_NotifyIcon(NIM_DELETE, @IconData);
  DeleteDC(DC) ;

  {Redraw the display (erasing dead lighs)}
  RedrawWindow(0, nil, 0, RDW_ERASE + RDW_INVALIDATE + RDW_UPDATENOW + RDW_ALLCHILDREN) ;
end.

