unit RefLine;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ScGraph, Menus;

type
  TRefForm = class(TForm)
    ScGraph1: TScGraph;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    Help1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Help1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  RefForm: TRefForm;
  RefText: TStringList;
implementation

uses DemoMain, Help;

{$R *.DFM}

///////////////////////////////////////////////
procedure TRefForm.FormCreate(Sender: TObject);
var i: integer;
    TempPen: TPen;
    TempBrush: TBrush;
begin
  with ScGraph1 do
  begin
    // set up series
    SetSeries(1, true, true, clRed, '');
    // get a nice function for the data
    for i := 10 to 50 do
      AddPoint(1, i, 10 + i * 0.3 + 5 * (random - 0.5), -1, -1);
    for i := 51 to 100 do
      AddPoint(1, i, 25 + 5 * (random - 0.5), -1, -1);

    SetSeries(2, true, true, clNavy, '');
    for i := 60 to 110 do
      AddPoint(2, i, 10 + i * 0.15 * (random - 0.5),
          -1, i * 0.14 * (random - 0.5) + 3);

    SetSeriesPoints(1, true, psCircle, 9);
    SetSeriesPoints(2, true, psCircleFilled, 8);
    SetSeriesErrBars(2, false, true, 0, 8);

    TempPen:= TPen.Create;
    TempPen.Color:= clSilver;
    TempPen.Width:= 3;
    TempPen.Style:= psDash;
    SetReferenceLine(1, true, [WPoint(3, 10.9), WPoint(50, 25),
         WPoint(110 ,25)], 3, TempPen);

    TempPen.Style:= psDot;
    SetReferenceLine(2, true, [WPoint(3, 8.4), WPoint(50, 22.5),
         WPoint(110 ,22.5)], 3, TempPen);

    SetReferenceLine(3, true, [WPoint(3, 13.4), WPoint(50, 27.5),
         WPoint(110 ,27.5)], 3, TempPen);

    TempPen.Style:= psClear;
    SetReferencePolygon(1, true, [WPoint(30, 23), WPoint(50, 30),
         WPoint(70, 33), WPoint(70, 20), WPoint(50, 21),
         WPoint(30, 15)], 6, TempPen, nil);

    TempBrush:= TBrush.Create;
    TempBrush.Style:= bsSolid;
    TempBrush.Color:= clAqua;
    SetReferencePolygon(2, true, [WPoint(65, 6), WPoint(105, 3),
         WPoint(105, 17), WPoint(65, 14)], 4, TempPen, TempBrush);


    TempPen.Free;
    TempBrush.Free;
    // paint always to get something on the graph
    Paint;
  end;

  RefText := TStringList.Create;
  with RefText do begin
    Add(' ');
    Add(' Shows some examples for reference lines       ');
    Add('         and reference polygons.               ');
    Add('                                               ');
  end;
end;

procedure TRefForm.FormDestroy(Sender: TObject);
begin
  RefText.Free;
end;

procedure TRefForm.Help1Click(Sender: TObject);
begin
  HelpForm.HelpMemo.Lines.Assign(RefText);
  HelpForm.ShowModal;
end;

procedure TRefForm.Exit1Click(Sender: TObject);
begin
  DemoForm.Exit1Click(Self);
end;

end.
