unit Plotting;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, ExtCtrls, ScGraph;

type
  TPlottingForm = class(TForm)
    MainMenu1: TMainMenu;
    Color1: TMenuItem;
    Mode1: TMenuItem;
    Symbols1: TMenuItem;
    LineStyle1: TMenuItem;
    Widthup1: TMenuItem;
    Widthdown1: TMenuItem;
    N1: TMenuItem;
    Solid1: TMenuItem;
    Dashed1: TMenuItem;
    DashDot1: TMenuItem;
    DashDotDot1: TMenuItem;
    Dotted1: TMenuItem;
    ScGraph1: TScGraph;
    Lines2: TMenuItem;
    Histogram1: TMenuItem;
    Sticks1: TMenuItem;
    ColorDialog1: TColorDialog;
    SizeUp1: TMenuItem;
    SizeDown1: TMenuItem;
    N2: TMenuItem;
    Square1: TMenuItem;
    FilledSquare1: TMenuItem;
    Diamond1: TMenuItem;
    FilledDiamond1: TMenuItem;
    Triangleup1: TMenuItem;
    Triangledown1: TMenuItem;
    Filledtriangleup1: TMenuItem;
    Filledtrinagledown1: TMenuItem;
    Cross1: TMenuItem;
    HatchedCross1: TMenuItem;
    Circle1: TMenuItem;
    Filledcircle1: TMenuItem;
    File1: TMenuItem;
    Print1: TMenuItem;
    Edit1: TMenuItem;
    CopyGraph1: TMenuItem;
    N3: TMenuItem;
    Exit1: TMenuItem;
    Close1: TMenuItem;
    Printersetup1: TMenuItem;
    Symbols2: TMenuItem;
    Plotlines1: TMenuItem;
    N4: TMenuItem;
    Autometrics1: TMenuItem;
    Help1: TMenuItem;
    Errorbars1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure ScGraph1Resize(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure AnyLineMenuClick(Sender: TObject);
    procedure Lines2Click(Sender: TObject);
    procedure Histogram1Click(Sender: TObject);
    procedure Sticks1Click(Sender: TObject);
    procedure Color1Click(Sender: TObject);
    procedure AnySymbolMenuClick(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure CopyGraph1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure Printersetup1Click(Sender: TObject);
    procedure Symbols2Click(Sender: TObject);
    procedure Plotlines1Click(Sender: TObject);
    procedure Autometrics1Click(Sender: TObject);
    procedure Help1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Errorbars1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  PlottingForm: TPlottingForm;
  PlottingText: TStringList;
  lSymb: TPointShape;
  lStyle: TPenStyle;
  lMode: TPlotMode;
  lErrBarsX, lErrBarsY: boolean;
  lw: integer;
  eblw: integer;

const
  lLines : boolean = true;
  lColor: TColor = clRed;
  lSymbs: boolean = true;
  lSymbSize: integer = 10;

implementation

uses DemoMain, Help;

{$R *.DFM}

procedure TPlottingForm.FormCreate(Sender: TObject);
var i: integer;
begin
  // initialize Graph
  ScGraph1Resize(Self);
  lSymb:= psCircle;
  Circle1.Checked:= true;
  lw:= 5;
  lStyle:= psDot;
  Dotted1.Checked:= true;
  lMode:= pmLine;
  Lines2.Checked:= true;
  lErrBarsX:= true;
  lErrBarsY:= true;
  ErrorBars1.Checked:= true;
  eblw:= 1;

  with ScGraph1 do
  begin
    // setup series
    SetSeries(1, true, true, lColor, 'Series #1');
    // get some random data
    for i := 1 to 19 do
      AddPoint(1, i/2, 5*random + 3, random*0.2 + 0.1, random + 0.5);
    // set attributes
    SetSeriesLine(1, lLines, lMode, lw, lStyle);
    SetSeriesPoints(1, lSymbs, lSymb, lSymbSize);
    SetSeriesErrBars(1, lErrBarsX, lErrBarsY, eblw, lSymbSize);
  end;

  // always paint to see something
  ScGraph1.Paint;

  PlottingText := TStringList.Create;
  with PlottingText do begin
    Add(' Edit  : Copy Graph - copies graph to clipboard');
    Add('         Autometrics- autoadjust various sizes,');
    Add('         line widths and distances');
    Add(' Color : sets color of lines and symbols');
    Add(' Mode  : choose symbols and/or lines and/or');
    Add('         error bars, and the available plotting');
    Add('         modes from: Lines, Histogram or Sticks');
    Add(' Symbols  : choose symbol type and size');
    Add(' LineStyle: choose linewidth and line pattern');
  end;
end;

procedure TPlottingForm.FormDestroy(Sender: TObject);
begin
  PlottingText.Free;
end;

procedure TPlottingForm.ScGraph1Resize(Sender: TObject);
begin
  ScGraph1.Left := 10;
  ScGraph1.Top := 10;
  ScGraph1.Width := ClientWidth - 20;
  ScGraph1.Height := ClientHeight - 20;
end;

procedure TPlottingForm.FormResize(Sender: TObject);
begin
  ScGraph1Resize(Self);
end;

/////// change line color /////////////////////
procedure TPlottingForm.Color1Click(Sender: TObject);
begin
  ColorDialog1.Execute;
  lColor := ColorDialog1.Color;
  ScGraph1.SetSeries(1, true, false, lColor, 'Series #1');
  ScGraph1.Paint;
end;

/////// toggle symbol drawing /////////////////////
procedure TPlottingForm.Symbols2Click(Sender: TObject);
begin
  Symbols2.Checked := not Symbols2.Checked;
  lSymbs := Symbols2.Checked;
  ScGraph1.SetSeriesPoints(1, lSymbs, lSymb, lSymbSize);
  ScGraph1.Paint;
end;

/////// toggle line drawing /////////////////////
procedure TPlottingForm.Plotlines1Click(Sender: TObject);
begin
  PlotLines1.Checked := not PlotLines1.Checked;
  lErrBarsX := false;
  lLines := PlotLines1.Checked;
  ScGraph1.SetSeriesLine(1, lLines, lMode, lw, lStyle);
  ScGraph1.Paint;
end;

/////// toggle error bar drawing /////////////////////
procedure TPlottingForm.Errorbars1Click(Sender: TObject);
begin
  ErrorBars1.Checked := not ErrorBars1.Checked;
  lErrBarsX := ErrorBars1.Checked;
  lErrBarsY := ErrorBars1.Checked;
  ScGraph1.SetSeriesErrBars(1, lErrBarsX and not Histogram1.Checked,
          lErrBarsY and not Sticks1.Checked, eblw, lSymbSize);
  ScGraph1.Paint;
end;

/////// select line, histo or sticks mode /////////////////////
procedure TPlottingForm.Lines2Click(Sender: TObject);
begin
  lMode := pmLine;
  Lines2.Checked:= true;
  Histogram1.Checked:= false;
  Sticks1.Checked:= false;
  ScGraph1.SetSeriesLine(1, lLines, lMode, lw, lStyle);
  ScGraph1.SetSeriesErrBars(1, lErrBarsX, lErrBarsY, eblw, lSymbSize);
  ScGraph1.Paint;
end;

procedure TPlottingForm.Histogram1Click(Sender: TObject);
begin
  lMode := pmHisto;
  Lines2.Checked:= false;
  Histogram1.Checked:= true;
  Sticks1.Checked:= false;
  ScGraph1.SetSeriesLine(1, lLines, lMode, lw, lStyle);
  ScGraph1.SetSeriesErrBars(1, lErrBarsX and not Histogram1.Checked,
          lErrBarsY and not Sticks1.Checked, eblw, lSymbSize);
  ScGraph1.Paint;
end;

procedure TPlottingForm.Sticks1Click(Sender: TObject);
begin
  lMode := pmSticks;
  Lines2.Checked:= false;
  Histogram1.Checked:= false;
  Sticks1.Checked:= true;
  ScGraph1.SetSeriesLine(1, lLines, lMode, lw, lStyle);
  ScGraph1.SetSeriesErrBars(1, lErrBarsX, false, eblw, lSymbSize);
  ScGraph1.Paint;
end;

/////// select symbol size and type /////////////////////
procedure TPlottingForm.AnySymbolMenuClick(Sender: TObject);
var i, j: integer;
    parent: TMenuItem;
begin
  parent:= (Sender as TMenuItem).Parent;
  j:= parent.IndexOf(Sender as TMenuItem);
  if j >= 3 then
  begin
    with (Sender as TMenuItem) do
      for i := 3 to (Parent.Count - 1) do Parent[i].Checked := FALSE;
    parent[j].Checked:= true;
  end;

  case j of
      0: lSymbSize := lSymbSize + 1;
      1: if lSymbSize > 0 then lSymbSize := lSymbSize - 1;
      3: lSymb := psCircle;
      4: lSymb := psCircleFilled;
      5: lSymb := psSquare;
      6: lSymb := psSquareFilled;
      7: lSymb := psDiamond;
      8: lSymb := psDiamondFilled;
      9: lSymb := psTriangleUp;
      10: lSymb := psTriangleDown;
      11: lSymb := psTriangleUpFilled;
      12: lSymb := psTriangleDownFilled;
      13: lSymb := psHCross;
      14: lSymb := psCross;
    end;
  ScGraph1.SetSeriesPoints(1, lSymbs, lSymb, lSymbSize);
  ScGraph1.Paint;
end;

/////// select line thickness and pen type /////////////////////
procedure TPlottingForm.AnyLineMenuClick(Sender: TObject);
var i, j: integer;
    parent: TMenuItem;
begin
  parent:= (Sender as TMenuItem).Parent;
  j:= parent.IndexOf(Sender as TMenuItem);
  if j >= 3 then
  begin
    with (Sender as TMenuItem) do
      for i := 3 to (Parent.Count - 1) do Parent[i].Checked := FALSE;
    parent[j].Checked:= true;
  end;
  case j of
       0: lw := lw + 1;
       1: if lw > 0 then lw := lw - 1;
       3: lStyle := psSolid;
       4: lStyle := psDash;
       5: lStyle := psDot;
       6: lStyle := psDashDot;
       7: lStyle := psDashDotDot;
      end;
  ScGraph1.SetSeriesLine(1, lLines, lMode, lw, lStyle);
  ScGraph1.Paint;
end;

//////// remaining crap /////////////////////////////
procedure TPlottingForm.Close1Click(Sender: TObject);
begin
  DemoForm.CloseWindow1Click(Self);
end;

procedure TPlottingForm.Exit1Click(Sender: TObject);
begin
  DemoForm.Exit1Click(Self);
end;

procedure TPlottingForm.CopyGraph1Click(Sender: TObject);
begin
  ScGraph1.CopyGraphToClipboard;
end;

procedure TPlottingForm.Print1Click(Sender: TObject);
begin
  // print horiz and vert centered, 140 mm wide, 120 mm high
  ScGraph1.PrintGraph(-1, -1, 140, 120);
end;

procedure TPlottingForm.Printersetup1Click(Sender: TObject);
begin
  DemoForm.PrinterSetupDialog1.Execute;
end;

procedure TPlottingForm.Autometrics1Click(Sender: TObject);
begin
  ScGraph1.Autometrics := ScGraph1.Autometrics xor true;
  Autometrics1.Checked := ScGraph1.Autometrics;
  ScGraph1.Paint;
end;

procedure TPlottingForm.Help1Click(Sender: TObject);
begin
  HelpForm.HelpMemo.Lines.Assign(PlottingText);
  HelpForm.ShowModal;
end;

end.



