unit Griddemo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ExtCtrls, ScGraph;

type
  TGridForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Close1: TMenuItem;
    Printersetup1: TMenuItem;
    Print1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Edit1: TMenuItem;
    Copygraph1: TMenuItem;
    HorizGrid: TMenuItem;
    VertGrid1: TMenuItem;
    ScGraph1: TScGraph;
    MajorGrid1: TMenuItem;
    MinorGrid1: TMenuItem;
    N21: TMenuItem;
    N31: TMenuItem;
    N41: TMenuItem;
    N51: TMenuItem;
    N61: TMenuItem;
    N71: TMenuItem;
    N81: TMenuItem;
    N91: TMenuItem;
    N151: TMenuItem;
    N201: TMenuItem;
    N251: TMenuItem;
    N301: TMenuItem;
    N351: TMenuItem;
    N401: TMenuItem;
    N451: TMenuItem;
    N501: TMenuItem;
    N551: TMenuItem;
    N601: TMenuItem;
    N651: TMenuItem;
    N701: TMenuItem;
    N751: TMenuItem;
    N801: TMenuItem;
    N851: TMenuItem;
    N901: TMenuItem;
    N951: TMenuItem;
    Step1: TMenuItem;
    minorTickNumber1: TMenuItem;
    Autometrics1: TMenuItem;
    Help1: TMenuItem;
    procedure Close1Click(Sender: TObject);
    procedure Printersetup1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Copygraph1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure N21Click(Sender: TObject);
    procedure N31Click(Sender: TObject);
    procedure N41Click(Sender: TObject);
    procedure N51Click(Sender: TObject);
    procedure N61Click(Sender: TObject);
    procedure N71Click(Sender: TObject);
    procedure N81Click(Sender: TObject);
    procedure N91Click(Sender: TObject);
    procedure N151Click(Sender: TObject);
    procedure N201Click(Sender: TObject);
    procedure N251Click(Sender: TObject);
    procedure N351Click(Sender: TObject);
    procedure N451Click(Sender: TObject);
    procedure N551Click(Sender: TObject);
    procedure N651Click(Sender: TObject);
    procedure N751Click(Sender: TObject);
    procedure N851Click(Sender: TObject);
    procedure N951Click(Sender: TObject);
    procedure N301Click(Sender: TObject);
    procedure N401Click(Sender: TObject);
    procedure N501Click(Sender: TObject);
    procedure N601Click(Sender: TObject);
    procedure N701Click(Sender: TObject);
    procedure N801Click(Sender: TObject);
    procedure N901Click(Sender: TObject);
    procedure Step1Click(Sender: TObject);
    procedure minorTickNumber1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Autometrics1Click(Sender: TObject);
    procedure Help1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  GridForm: TGridForm;
  GridsText: TStringList;

implementation

uses DemoMain, Help;

{$R *.DFM}

procedure TGridForm.Close1Click(Sender: TObject);
begin
  DemoForm.CloseWindow1Click(Self);
end;

procedure TGridForm.Printersetup1Click(Sender: TObject);
begin
  DemoForm.PrinterSetupDialog1.Execute;
end;

procedure TGridForm.Exit1Click(Sender: TObject);
begin
  DemoForm.Exit1Click(Self);
end;

procedure TGridForm.Copygraph1Click(Sender: TObject);
begin
  ScGraph1.CopyGraphToClipboard;
end;

procedure TGridForm.Print1Click(Sender: TObject);
begin
  ScGraph1.PrintGraph(-1, -1, 140, 120);
end;

///////// awful hack: duplicating is easy, everything
///////// should be clear by now (?)
procedure TGridForm.N21Click(Sender: TObject);
begin
  N21.Checked := N21.Checked xor true;
  if N21.Checked then
    ScGraph1.XScale.MajorLogPattern:= ScGraph1.XScale.MajorLogPattern + [lt20]
  else
    ScGraph1.XScale.MajorLogPattern:= ScGraph1.XScale.MajorLogPattern - [lt20];
  ScGraph1.Paint;
end;

procedure TGridForm.N31Click(Sender: TObject);
begin
  N31.Checked := N31.Checked xor true;
  if N31.Checked then
    ScGraph1.XScale.MajorLogPattern:= ScGraph1.XScale.MajorLogPattern + [lt30]
  else
    ScGraph1.XScale.MajorLogPattern:= ScGraph1.XScale.MajorLogPattern - [lt30];
  ScGraph1.Paint;
end;

procedure TGridForm.N41Click(Sender: TObject);
begin
  N41.Checked := N41.Checked xor true;
  if N41.Checked then
    ScGraph1.XScale.MajorLogPattern:= ScGraph1.XScale.MajorLogPattern + [lt40]
  else
    ScGraph1.XScale.MajorLogPattern:= ScGraph1.XScale.MajorLogPattern - [lt40];
  ScGraph1.Paint;
end;

procedure TGridForm.N51Click(Sender: TObject);
begin
  N51.Checked := N51.Checked xor true;
  if N51.Checked then
    ScGraph1.XScale.MajorLogPattern:= ScGraph1.XScale.MajorLogPattern + [lt50]
  else
    ScGraph1.XScale.MajorLogPattern:= ScGraph1.XScale.MajorLogPattern - [lt50];
  ScGraph1.Paint;
end;

procedure TGridForm.N61Click(Sender: TObject);
begin
  N61.Checked := N61.Checked xor true;
  if N61.Checked then
    ScGraph1.XScale.MajorLogPattern:= ScGraph1.XScale.MajorLogPattern + [lt60]
  else
    ScGraph1.XScale.MajorLogPattern:= ScGraph1.XScale.MajorLogPattern - [lt60];
  ScGraph1.Paint;
end;

procedure TGridForm.N71Click(Sender: TObject);
begin
  N71.Checked := N71.Checked xor true;
  if N71.Checked then
    ScGraph1.XScale.MajorLogPattern:= ScGraph1.XScale.MajorLogPattern + [lt70]
  else
    ScGraph1.XScale.MajorLogPattern:= ScGraph1.XScale.MajorLogPattern - [lt70];
  ScGraph1.Paint;
end;

procedure TGridForm.N81Click(Sender: TObject);
begin
  N81.Checked := N81.Checked xor true;
  if N81.Checked then
    ScGraph1.XScale.MajorLogPattern:= ScGraph1.XScale.MajorLogPattern + [lt80]
  else
    ScGraph1.XScale.MajorLogPattern:= ScGraph1.XScale.MajorLogPattern - [lt80];
  ScGraph1.Paint;
end;

procedure TGridForm.N91Click(Sender: TObject);
begin
  N91.Checked := N91.Checked xor true;
  if N91.Checked then
    ScGraph1.XScale.MajorLogPattern:= ScGraph1.XScale.MajorLogPattern + [lt90]
  else
    ScGraph1.XScale.MajorLogPattern:= ScGraph1.XScale.MajorLogPattern - [lt90];
  ScGraph1.Paint;
end;

procedure TGridForm.N151Click(Sender: TObject);
begin
  N151.Checked := N151.Checked xor true;
  if N151.Checked then
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern + [st15]
  else
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern - [st15];
  ScGraph1.Paint;
end;

procedure TGridForm.N201Click(Sender: TObject);
begin
  N201.Checked := N201.Checked xor true;
  if N201.Checked then
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern + [st20]
  else
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern - [st20];
  ScGraph1.Paint;
end;

procedure TGridForm.N251Click(Sender: TObject);
begin
  N251.Checked := N251.Checked xor true;
  if N251.Checked then
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern + [st25]
  else
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern - [st25];
  ScGraph1.Paint;
end;

procedure TGridForm.N351Click(Sender: TObject);
begin
  N351.Checked := N351.Checked xor true;
  if N351.Checked then
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern + [st35]
  else
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern - [st35];
  ScGraph1.Paint;
end;

procedure TGridForm.N451Click(Sender: TObject);
begin
  N451.Checked := N451.Checked xor true;
  if N451.Checked then
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern + [st45]
  else
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern - [st45];
  ScGraph1.Paint;
end;

procedure TGridForm.N551Click(Sender: TObject);
begin
  N551.Checked := N551.Checked xor true;
  if N551.Checked then
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern + [st55]
  else
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern - [st55];
  ScGraph1.Paint;
end;

procedure TGridForm.N651Click(Sender: TObject);
begin
  N651.Checked := N651.Checked xor true;
  if N651.Checked then
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern + [st65]
  else
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern - [st65];
  ScGraph1.Paint;
end;

procedure TGridForm.N751Click(Sender: TObject);
begin
  N751.Checked := N751.Checked xor true;
  if N751.Checked then
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern + [st75]
  else
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern - [st75];
  ScGraph1.Paint;
end;

procedure TGridForm.N851Click(Sender: TObject);
begin
  N851.Checked := N851.Checked xor true;
  if N851.Checked then
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern + [st85]
  else
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern - [st85];
  ScGraph1.Paint;
end;

procedure TGridForm.N951Click(Sender: TObject);
begin
  N951.Checked := N951.Checked xor true;
  if N951.Checked then
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern + [st95]
  else
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern - [st95];
  ScGraph1.Paint;
end;

procedure TGridForm.N301Click(Sender: TObject);
begin
  N301.Checked := N301.Checked xor true;
  if N301.Checked then
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern + [st30]
  else
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern - [st30];
  ScGraph1.Paint;
end;

procedure TGridForm.N401Click(Sender: TObject);
begin
  N401.Checked := N401.Checked xor true;
  if N401.Checked then
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern + [st40]
  else
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern - [st40];
  ScGraph1.Paint;
end;

procedure TGridForm.N501Click(Sender: TObject);
begin
  N501.Checked := N501.Checked xor true;
  if N501.Checked then
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern + [st50]
  else
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern - [st50];
  ScGraph1.Paint;
end;

procedure TGridForm.N601Click(Sender: TObject);
begin
  N601.Checked := N601.Checked xor true;
  if N601.Checked then
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern + [st60]
  else
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern - [st60];
  ScGraph1.Paint;
end;

procedure TGridForm.N701Click(Sender: TObject);
begin
  N701.Checked := N701.Checked xor true;
  if N701.Checked then
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern + [st70]
  else
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern - [st70];
  ScGraph1.Paint;
end;

procedure TGridForm.N801Click(Sender: TObject);
begin
  N801.Checked := N801.Checked xor true;
  if N801.Checked then
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern + [st80]
  else
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern - [st80];
  ScGraph1.Paint;
end;

procedure TGridForm.N901Click(Sender: TObject);
begin
  N901.Checked := N901.Checked xor true;
  if N901.Checked then
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern + [st90]
  else
    ScGraph1.XScale.MinorLogPattern:= ScGraph1.XScale.MinorLogPattern - [st90];
  ScGraph1.Paint;
end;

procedure TGridForm.Step1Click(Sender: TObject);
var InpStr: string;
begin
  InpStr:= InputBox('Step interval',
     'Enter interval (0.5-10):', FloatToStr(ScGraph1.YScale.LinStep));
  try
    ScGraph1.YScale.LinStep:= StrToFloat(InpStr);
  except
  end;
  ScGraph1.Paint;
end;

procedure TGridForm.minorTickNumber1Click(Sender: TObject);
var InpStr: string;
begin
  InpStr:= InputBox('Number of Minor Ticks',
     'Enter number (0-10):', IntToStr(ScGraph1.YScale.MinorTickNumber));
  try
    ScGraph1.YScale.MinorTickNumber:= StrToInt(InpStr);
  except
  end;
  ScGraph1.Paint;
end;

procedure TGridForm.FormCreate(Sender: TObject);
  function F(v: double): double;
  begin
    Result:= 0.7 + 8*exp(-sqr((v - 40)/5)) + 3.5*exp(-sqr((v - 10)/3));
  end;

var i: integer;
begin
  with ScGraph1 do
  begin
    SetSeries(1, true, true, clNavy, '---');
    for i := 1 to 600 do AddPoint(1, i/6, F(i/6), -1, -1);
    SetSeriesLine(1, true, pmLine, 0, psSolid);
    SetSeries(2, true, true, clNavy, '---');
    for i := 1 to 100 do AddPoint(2, i, F(i), -1, -1);
    SetSeriesPoints(2, true, psCircle, 10);

    Paint;
  end;

  GridsText := TStringList.Create;
  with GridsText do begin
    Add(' Edit  : Copy Graph - copies graph to clipboard');
    Add('         Autometrics- autoadjust various sizes,');
    Add('         line widths and distances');
    Add(' HorizGrid: example for a linear scale type');
    Add('    - step interval: value on scale for the ');
    Add('         interval between major ticks/grid lines');
    Add('    - minor grid number: number of minor ticks/');
    Add('         grid lines between major ticks');
    Add(' VertGrid : example for a logarithmic scale type');
    Add('    - major grid: select major ticks/grid lines,');
    Add('         numbers are given for decade 1 to 10');
    Add('    - minor grid: select major ticks/grid lines,');
    Add('         numbers are given for decade 1 to 10');
  end;
end;

procedure TGridForm.FormDestroy(Sender: TObject);
begin
  GridsText.Free
end;

procedure TGridForm.Autometrics1Click(Sender: TObject);
begin
  ScGraph1.Autometrics := ScGraph1.Autometrics xor true;
  Autometrics1.Checked := ScGraph1.Autometrics;
  ScGraph1.Paint;
end;

procedure TGridForm.Help1Click(Sender: TObject);
begin
  HelpForm.HelpMemo.Lines.Assign(GridsText);
  HelpForm.ShowModal;
end;

end.
