unit DemoMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Buttons, ExtCtrls, Menus;

type
  TDemoForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    Demos1: TMenuItem;
    Plotting1: TMenuItem;
    Titles1: TMenuItem;
    Axes1: TMenuItem;
    Help1: TMenuItem;
    PrintDialog1: TPrintDialog;
    PrinterSetupDialog1: TPrinterSetupDialog;
    Grids1: TMenuItem;
    About1: TMenuItem;
    ReferenceLines1: TMenuItem;
    procedure Exit1Click(Sender: TObject);
    procedure Plotting1Click(Sender: TObject);
    procedure Titles1Click(Sender: TObject);
    procedure CloseWindow1Click(Sender: TObject);
    procedure SetupPrinter1Click(Sender: TObject);
    procedure Grids1Click(Sender: TObject);
    procedure Axes1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ReferenceLines1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DemoForm: TDemoForm;
  AboutText: TStringList;

implementation

{$R *.DFM}

uses Plotting, Titles, Griddemo, Axes, RefLine, Help;

procedure TDemoForm.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TDemoForm.Plotting1Click(Sender: TObject);
begin
  CloseWindow1Click(Self);
  TPlottingForm.Create(Self);
end;

procedure TDemoForm.Titles1Click(Sender: TObject);
begin
  CloseWindow1Click(Self);
  TTitlesForm.Create(Self);
end;

procedure TDemoForm.Axes1Click(Sender: TObject);
begin
  CloseWindow1Click(Self);
  TAxesForm.Create(Self);
end;

procedure TDemoForm.Grids1Click(Sender: TObject);
begin
  CloseWindow1Click(Self);
  TGridForm.Create(Self);
end;

procedure TDemoForm.ReferenceLines1Click(Sender: TObject);
begin
  CloseWindow1Click(Self);
  TRefForm.Create(Self);
end;

procedure TDemoForm.CloseWindow1Click(Sender: TObject);
begin
  while MDIChildCount > 0 do MDIChildren[0].Free;
end;

procedure TDemoForm.SetupPrinter1Click(Sender: TObject);
begin
  PrinterSetupDialog1.Execute;
end;

procedure TDemoForm.About1Click(Sender: TObject);
begin
  HelpForm.HelpMemo.Lines.Assign(AboutText);
  HelpForm.ShowModal;
end;

procedure TDemoForm.FormCreate(Sender: TObject);
begin
  AboutText := TStringList.Create;
  with AboutText do begin
   Add(' TScGraph is a Delphi32 component for scientific/');
   Add(' technical graphing of x/y-data. Basis for this ');
   Add(' component was txyGraph (version 1.0) which was ');
   Add(' made available by:');
   Add(' Grahame Grieve, Biochemistry, St Vincents Hosp.,');
   Add(' Victoria Parade, Fitzroy, 3065, Australia');
   Add(' (g.grieve@pgrad.unimelb.edu.au)');
   Add(' which is gratefully acknowledged. ');
   Add(' ');
   Add(' Choose plot demonstrations from the Demo Menu.');
  end;
end;

end.
