unit Titles;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ExtCtrls, ScGraph;

type
  TTitlesForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Close1: TMenuItem;
    Printersetup1: TMenuItem;
    Print1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Edit1: TMenuItem;
    CopyGraph1: TMenuItem;
    GraphTitle1: TMenuItem;
    ScGraph1: TScGraph;
    XTitle1: TMenuItem;
    YTitle: TMenuItem;
    Text1: TMenuItem;
    Font1: TMenuItem;
    Position1: TMenuItem;
    FontDialog1: TFontDialog;
    Text2: TMenuItem;
    Font2: TMenuItem;
    Position2: TMenuItem;
    Direction1: TMenuItem;
    Text3: TMenuItem;
    Font3: TMenuItem;
    Position3: TMenuItem;
    Direction2: TMenuItem;
    Legends: TMenuItem;
    Legends1: TMenuItem;
    N2: TMenuItem;
    Font4: TMenuItem;
    Position4: TMenuItem;
    Top1: TMenuItem;
    Right1: TMenuItem;
    Bottom1: TMenuItem;
    Northwest1: TMenuItem;
    Northeast1: TMenuItem;
    Southwest1: TMenuItem;
    Southeast1: TMenuItem;
    N0deg1: TMenuItem;
    N90deg1: TMenuItem;
    N270deg1: TMenuItem;
    N0deg2: TMenuItem;
    N90deg2: TMenuItem;
    N270deg2: TMenuItem;
    Autometrics1: TMenuItem;
    Help1: TMenuItem;
    procedure Close1Click(Sender: TObject);
    procedure Printersetup1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure CopyGraph1Click(Sender: TObject);
    procedure Font1Click(Sender: TObject);
    procedure Text1Click(Sender: TObject);
    procedure Position1Click(Sender: TObject);
    procedure Text2Click(Sender: TObject);
    procedure Font2Click(Sender: TObject);
    procedure Position2Click(Sender: TObject);
    procedure Text3Click(Sender: TObject);
    procedure Position3Click(Sender: TObject);
    procedure N0deg1Click(Sender: TObject);
    procedure N90deg1Click(Sender: TObject);
    procedure N270deg1Click(Sender: TObject);
    procedure N0deg2Click(Sender: TObject);
    procedure N90deg2Click(Sender: TObject);
    procedure N270deg2Click(Sender: TObject);
    procedure Legends1Click(Sender: TObject);
    procedure Font4Click(Sender: TObject);
    procedure Top1Click(Sender: TObject);
    procedure Right1Click(Sender: TObject);
    procedure Bottom1Click(Sender: TObject);
    procedure Northwest1Click(Sender: TObject);
    procedure Northeast1Click(Sender: TObject);
    procedure Southwest1Click(Sender: TObject);
    procedure Southeast1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Autometrics1Click(Sender: TObject);
    procedure Help1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  TitlesForm: TTitlesForm;
  TitlesText: TStringList;

implementation

uses DemoMain, Help;

{$R *.DFM}

procedure TTitlesForm.Close1Click(Sender: TObject);
begin
  DemoForm.CloseWindow1Click(Self);
end;

procedure TTitlesForm.Printersetup1Click(Sender: TObject);
begin
  DemoForm.PrinterSetupDialog1.Execute;
end;

procedure TTitlesForm.Print1Click(Sender: TObject);
begin
  ScGraph1.PrintGraph(-1, -1, 140, 120);
end;

procedure TTitlesForm.Exit1Click(Sender: TObject);
begin
  DemoForm.Exit1Click(Self);
end;

procedure TTitlesForm.CopyGraph1Click(Sender: TObject);
begin
  ScGraph1.CopyGraphToClipboard;
end;

procedure TTitlesForm.Font1Click(Sender: TObject);
begin
  FontDialog1.Font:= ScGraph1.GraphTitleFont;
  if FontDialog1.Execute then
    ScGraph1.GraphTitleFont := FontDialog1.Font;
end;

procedure TTitlesForm.Text1Click(Sender: TObject);
begin
  ScGraph1.GraphTitle.Caption:= InputBox('Graph Title',
     'Enter caption:', ScGraph1.GraphTitle.Caption);
end;

procedure TTitlesForm.Position1Click(Sender: TObject);
var InpStr: string;
begin
  InpStr:= InputBox('Graph Title Position',
     'Enter position (0-1000):', IntToStr(ScGraph1.GraphTitle.Position));
  try
    ScGraph1.GraphTitle.Position:= StrToInt(InpStr);
  except
  end;
end;

procedure TTitlesForm.Text2Click(Sender: TObject);
begin
  ScGraph1.XAxis.TitleText:= InputBox('X-Axis Title',
     'Enter caption:', ScGraph1.XAxis.TitleText);
end;

procedure TTitlesForm.Font2Click(Sender: TObject);
begin
  FontDialog1.Font:= ScGraph1.AxisTitleFont;
  if FontDialog1.Execute then
    ScGraph1.AxisTitleFont := FontDialog1.Font;
end;

procedure TTitlesForm.Position2Click(Sender: TObject);
begin
  try
    ScGraph1.XAxis.TitlePos:= StrToInt(InputBox('X-Axis Title Position',
     'Enter position (0-1000):', IntToStr(ScGraph1.XAxis.TitlePos)));
  except
  end;
end;

procedure TTitlesForm.Text3Click(Sender: TObject);
begin
  ScGraph1.YAxis.TitleText:= InputBox('Y-Axis Title',
     'Enter caption:', ScGraph1.YAxis.TitleText);
end;

procedure TTitlesForm.Position3Click(Sender: TObject);
begin
  try
    ScGraph1.YAxis.TitlePos:= StrToInt(InputBox('Y-Axis Title Position',
     'Enter position (0-1000):', IntToStr(ScGraph1.YAxis.TitlePos)));
  except
  end;
end;

procedure TTitlesForm.N0deg1Click(Sender: TObject);
begin
  ScGraph1.XAxis.TitleAngle := lr0;
end;

procedure TTitlesForm.N90deg1Click(Sender: TObject);
begin
  ScGraph1.XAxis.TitleAngle := lr90;
end;

procedure TTitlesForm.N270deg1Click(Sender: TObject);
begin
  ScGraph1.XAxis.TitleAngle := lr270;
end;

procedure TTitlesForm.N0deg2Click(Sender: TObject);
begin
  ScGraph1.YAxis.TitleAngle := lr0;
end;

procedure TTitlesForm.N90deg2Click(Sender: TObject);
begin
  ScGraph1.YAxis.TitleAngle := lr90;
end;

procedure TTitlesForm.N270deg2Click(Sender: TObject);
begin
  ScGraph1.YAxis.TitleAngle := lr270;
end;

////////////////////////
procedure TTitlesForm.Legends1Click(Sender: TObject);
begin
  Legends1.Checked := Legends1.Checked xor true;
  ScGraph1.LegendBox.ShowLegends := Legends1.Checked;
end;

procedure TTitlesForm.Font4Click(Sender: TObject);
begin
  FontDialog1.Font:= ScGraph1.LegendFont;
  if FontDialog1.Execute then
    ScGraph1.LegendFont := FontDialog1.Font;
end;

procedure TTitlesForm.Top1Click(Sender: TObject);
begin
  ScGraph1.LegendBox.BoxColor := clTeal;
  ScGraph1.LegendBox.Placement := lbxTop;
  ScGraph1.LegendFOnt.Color := clSilver;
end;

procedure TTitlesForm.Right1Click(Sender: TObject);
begin
  ScGraph1.LegendBox.BoxColor := clTeal;
  ScGraph1.LegendBox.Placement := lbxRight;
  ScGraph1.LegendFOnt.Color := clSilver;
end;

procedure TTitlesForm.Bottom1Click(Sender: TObject);
begin
  ScGraph1.LegendBox.BoxColor := clTeal;
  ScGraph1.LegendBox.Placement := lbxBottom;
  ScGraph1.LegendFOnt.Color := clSilver;
end;

procedure TTitlesForm.Northwest1Click(Sender: TObject);
begin
  ScGraph1.LegendBox.BoxColor := clSilver;
  ScGraph1.LegendBox.Placement := lbxNorthwest;
  ScGraph1.LegendFOnt.Color := clBlack;
end;

procedure TTitlesForm.Northeast1Click(Sender: TObject);
begin
  ScGraph1.LegendBox.BoxColor := clSilver;
  ScGraph1.LegendBox.Placement := lbxNortheast;
  ScGraph1.LegendFOnt.Color := clBlack;
end;

procedure TTitlesForm.Southwest1Click(Sender: TObject);
begin
  ScGraph1.LegendBox.BoxColor := clSilver;
  ScGraph1.LegendBox.Placement := lbxSouthwest;
  ScGraph1.LegendFOnt.Color := clBlack;
end;

procedure TTitlesForm.Southeast1Click(Sender: TObject);
begin
  ScGraph1.LegendBox.BoxColor := clSilver;
  ScGraph1.LegendBox.Placement := lbxSoutheast;
  ScGraph1.LegendFOnt.Color := clBlack;
end;

procedure TTitlesForm.FormCreate(Sender: TObject);
var i: integer;
    s: double;
begin
  with ScGraph1 do
  begin
    Plotting := false;

    SetSeries(1, true, true, clYellow, 'Function');
    SetSeries(2, true, true, clLime, 'Noise');
    SetSeries(3, true, true, clAqua, 'Sum');

    for i := 0 to 200 do
    begin
      s := 3 * random;
      AddPoint(1, i, sqrt(i));
      AddPoint(2, i, s);
      AddPoint(3, i, sqrt(i) + s);
    end;

    SetSeriesLine(1, true, pmLine, 1, psDash);
    SetSeriesLine(2, true, pmLine, 1, psSolid);
    SetSeriesLine(3, true, pmLine, 1, psSolid);

    Plotting := true;
  end;

  TitlesText := TStringList.Create;
  with TitlesText do begin
   Add(' Edit  : Copy Graph - copies graph to clipboard');
   Add('         Autometrics- autoadjust various sizes,');
   Add('         line widths and distances');
   Add(' GraphTitle: choose text, font and position');
   Add('         for the title of the plot');
   Add(' X-title, Y-title: ');
   Add('         choose text, font, position and ');
   Add('         direction for the axis legends');
   Add(' LegendBox : choose font and position of the');
   Add('         legend box');
   Add(' ');
   Add('  (see also ScGraph.txt for further properties)');
  end;
end;

procedure TTitlesForm.FormDestroy(Sender: TObject);
begin
  TitlesText.Free;
end;

procedure TTitlesForm.Autometrics1Click(Sender: TObject);
begin
  ScGraph1.Autometrics := ScGraph1.Autometrics xor true;
  Autometrics1.Checked := ScGraph1.Autometrics;
end;

procedure TTitlesForm.Help1Click(Sender: TObject);
begin
  HelpForm.HelpMemo.Lines.Assign(TitlesText);
  HelpForm.ShowModal;
end;

end.
