unit Plotting;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ExtCtrls, ScGraph;

type
  TPlottingForm = class(TForm)
    MainMenu1: TMainMenu;
    Color1: TMenuItem;
    Mode1: TMenuItem;
    Symbols1: TMenuItem;
    LineStyle1: TMenuItem;
    Widthup1: TMenuItem;
    Widthdown1: TMenuItem;
    N1: TMenuItem;
    Solid1: TMenuItem;
    Dashed1: TMenuItem;
    DashDot1: TMenuItem;
    DashDotDot1: TMenuItem;
    Dotted1: TMenuItem;
    ScGraph1: TScGraph;
    Lines2: TMenuItem;
    Histogram1: TMenuItem;
    Sticks1: TMenuItem;
    ColorDialog1: TColorDialog;
    SizeUp1: TMenuItem;
    SizeDown1: TMenuItem;
    N2: TMenuItem;
    Square1: TMenuItem;
    FilledSquare1: TMenuItem;
    Diamond1: TMenuItem;
    FilledDiamond1: TMenuItem;
    Triangleup1: TMenuItem;
    Triangledown1: TMenuItem;
    Filledtriangleup1: TMenuItem;
    Filledtrinagledown1: TMenuItem;
    Cross1: TMenuItem;
    HatchedCross1: TMenuItem;
    Circle1: TMenuItem;
    Filledcircle1: TMenuItem;
    File1: TMenuItem;
    Print1: TMenuItem;
    Edit1: TMenuItem;
    CopyGraph1: TMenuItem;
    N3: TMenuItem;
    Exit1: TMenuItem;
    Close1: TMenuItem;
    Printersetup1: TMenuItem;
    Symbols2: TMenuItem;
    Plotlines1: TMenuItem;
    N4: TMenuItem;
    Autometrics1: TMenuItem;
    Help1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure ScGraph1Resize(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure Solid1Click(Sender: TObject);
    procedure Dashed1Click(Sender: TObject);
    procedure Dotted1Click(Sender: TObject);
    procedure DashDot1Click(Sender: TObject);
    procedure DashDotDot1Click(Sender: TObject);
    procedure Widthup1Click(Sender: TObject);
    procedure Widthdown1Click(Sender: TObject);
    procedure Lines2Click(Sender: TObject);
    procedure Histogram1Click(Sender: TObject);
    procedure Sticks1Click(Sender: TObject);
    procedure Color1Click(Sender: TObject);
    procedure SizeUp1Click(Sender: TObject);
    procedure SizeDown1Click(Sender: TObject);
    procedure Square1Click(Sender: TObject);
    procedure FilledSquare1Click(Sender: TObject);
    procedure Diamond1Click(Sender: TObject);
    procedure FilledDiamond1Click(Sender: TObject);
    procedure Triangleup1Click(Sender: TObject);
    procedure Triangledown1Click(Sender: TObject);
    procedure Filledtriangleup1Click(Sender: TObject);
    procedure Filledtrinagledown1Click(Sender: TObject);
    procedure HatchedCross1Click(Sender: TObject);
    procedure Cross1Click(Sender: TObject);
    procedure Circle1Click(Sender: TObject);
    procedure Filledcircle1Click(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure CopyGraph1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure Printersetup1Click(Sender: TObject);
    procedure Symbols2Click(Sender: TObject);
    procedure Plotlines1Click(Sender: TObject);
    procedure Autometrics1Click(Sender: TObject);
    procedure Help1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  PlottingForm: TPlottingForm;
  PlottingText: TStringList;

const
  lLines : boolean = true;
  lw: integer = 3;
  lStyle: TPenStyle = psSolid;
  lColor: TColor = clRed;
  lMode: pmPlotMode = pmLine;
  lSymbs: boolean = true;
  lSymb: etPointShape = psCircle;
  lSymbSize: integer = 12;

implementation

uses DemoMain, Help;

{$R *.DFM}

procedure TPlottingForm.FormCreate(Sender: TObject);
var i: integer;
begin
  ScGraph1Resize(Self);
  with ScGraph1 do
  begin
    Plotting := false;
    SetSeries(1, true, true, lColor, 'Series #1');
    for i := 1 to 20 do AddPoint(1, i/2, 10*random);
    SetSeriesLine(1, lLines, lMode, lw, lStyle);
    SetSeriesPoints(1, lSymbs, lSymb, lSymbSize);
    Plotting := true;
  end;

  PlottingText := TStringList.Create;
  with PlottingText do begin
   Add(' Edit  : Copy Graph - copies graph to clipboard');
   Add('         Autometrics- autoadjust various sizes,');
   Add('         line widths and distances');
   Add(' Color : sets color of lines and symbols');
   Add(' Mode  : choose symbols and/or lines');
   Add('         Lines/Histogram/Sticks - plotting modes');
   Add(' Symbols  : choose symbol type and size');
   Add(' LineStyle: choose linewidth and line pattern');
   Add(' ');
   Add('  (see also ScGraph.txt for further properties)');
  end;
end;

procedure TPlottingForm.FormDestroy(Sender: TObject);
begin
  PlottingText.Free;
end;

procedure TPlottingForm.ScGraph1Resize(Sender: TObject);
begin
  ScGraph1.Left := 10;
  ScGraph1.Top := 10;
  ScGraph1.Width := ClientWidth - 20;
  ScGraph1.Height := ClientHeight - 20;
end;

procedure TPlottingForm.FormResize(Sender: TObject);
begin
  ScGraph1Resize(Self);
end;

procedure TPlottingForm.Solid1Click(Sender: TObject);
begin
  lStyle := psSolid;
  ScGraph1.SetSeriesLine(1, lLines, lMode, lw, lStyle);
end;

procedure TPlottingForm.Dashed1Click(Sender: TObject);
begin
  lStyle := psDash;
  ScGraph1.SetSeriesLine(1, lLines, lMode, lw, lStyle);
end;

procedure TPlottingForm.Dotted1Click(Sender: TObject);
begin
  lStyle := psDot;
  ScGraph1.SetSeriesLine(1, lLines, lMode, lw, lStyle);
end;

procedure TPlottingForm.DashDot1Click(Sender: TObject);
begin
  lStyle := psDashDot;
  ScGraph1.SetSeriesLine(1, lLines, lMode, lw, lStyle);
end;

procedure TPlottingForm.DashDotDot1Click(Sender: TObject);
begin
  lStyle := psDashDotDot;
  ScGraph1.SetSeriesLine(1, lLines, lMode, lw, lStyle);
end;

procedure TPlottingForm.Widthup1Click(Sender: TObject);
begin
  lw := lw + 1;
  ScGraph1.SetSeriesLine(1, lLines, lMode, lw, lStyle);
end;

procedure TPlottingForm.Widthdown1Click(Sender: TObject);
begin
  if lw > 0 then lw := lw - 1;
  ScGraph1.SetSeriesLine(1, lLines, lMode, lw, lStyle);
end;

procedure TPlottingForm.Lines2Click(Sender: TObject);
begin
  lMode := pmLine;
  ScGraph1.SetSeriesLine(1, lLines, lMode, lw, lStyle);
end;

procedure TPlottingForm.Histogram1Click(Sender: TObject);
begin
  lMode := pmHisto;
  ScGraph1.SetSeriesLine(1, lLines, lMode, lw, lStyle);
end;

procedure TPlottingForm.Sticks1Click(Sender: TObject);
begin
  lMode := pmSticks;
  ScGraph1.SetSeriesLine(1, lLines, lMode, lw, lStyle);
end;

procedure TPlottingForm.Color1Click(Sender: TObject);
begin
  ColorDialog1.Execute;
  lColor := ColorDialog1.Color;
  ScGraph1.SetSeries(1, true, false, lColor, 'Series #1');
end;

//////////////////
procedure TPlottingForm.SizeUp1Click(Sender: TObject);
begin
  lSymbSize := lSymbSize + 1;
  ScGraph1.SetSeriesPoints(1, lSymbs, lSymb, lSymbSize);
end;

procedure TPlottingForm.SizeDown1Click(Sender: TObject);
begin
  if lSymbSize > 0 then lSymbSize := lSymbSize - 1;
  ScGraph1.SetSeriesPoints(1, lSymbs, lSymb, lSymbSize);
end;

procedure TPlottingForm.Square1Click(Sender: TObject);
begin
  lSymb := psSquare;
  ScGraph1.SetSeriesPoints(1, lSymbs, lSymb, lSymbSize);
end;

procedure TPlottingForm.FilledSquare1Click(Sender: TObject);
begin
  lSymb := psSquareFilled;
  ScGraph1.SetSeriesPoints(1, lSymbs, lSymb, lSymbSize);
end;

procedure TPlottingForm.Diamond1Click(Sender: TObject);
begin
  lSymb := psDiamond;
  ScGraph1.SetSeriesPoints(1, lSymbs, lSymb, lSymbSize);
end;

procedure TPlottingForm.FilledDiamond1Click(Sender: TObject);
begin
  lSymb := psDiamondFilled;
  ScGraph1.SetSeriesPoints(1, lSymbs, lSymb, lSymbSize);
end;

procedure TPlottingForm.Triangleup1Click(Sender: TObject);
begin
  lSymb := psTriangleUp;
  ScGraph1.SetSeriesPoints(1, lSymbs, lSymb, lSymbSize);
end;

procedure TPlottingForm.Triangledown1Click(Sender: TObject);
begin
  lSymb := psTriangleDown;
  ScGraph1.SetSeriesPoints(1, lSymbs, lSymb, lSymbSize);
end;

procedure TPlottingForm.Filledtriangleup1Click(Sender: TObject);
begin
  lSymb := psTriangleUpFilled;
  ScGraph1.SetSeriesPoints(1, lSymbs, lSymb, lSymbSize);
end;

procedure TPlottingForm.Filledtrinagledown1Click(Sender: TObject);
begin
  lSymb := psTriangleDownFilled;
  ScGraph1.SetSeriesPoints(1, lSymbs, lSymb, lSymbSize);
end;

procedure TPlottingForm.HatchedCross1Click(Sender: TObject);
begin
  lSymb := psHCross;
  ScGraph1.SetSeriesPoints(1, lSymbs, lSymb, lSymbSize);
end;

procedure TPlottingForm.Cross1Click(Sender: TObject);
begin
  lSymb := psCross;
  ScGraph1.SetSeriesPoints(1, lSymbs, lSymb, lSymbSize);
end;

procedure TPlottingForm.Circle1Click(Sender: TObject);
begin
  lSymb := psCircle;
  ScGraph1.SetSeriesPoints(1, lSymbs, lSymb, lSymbSize);
end;

procedure TPlottingForm.Filledcircle1Click(Sender: TObject);
begin
  lSymb := psCircleFilled;
  ScGraph1.SetSeriesPoints(1, lSymbs, lSymb, lSymbSize);
end;

procedure TPlottingForm.Close1Click(Sender: TObject);
begin
  DemoForm.CloseWindow1Click(Self);
end;

procedure TPlottingForm.Exit1Click(Sender: TObject);
begin
  DemoForm.Exit1Click(Self);
end;

procedure TPlottingForm.CopyGraph1Click(Sender: TObject);
begin
  ScGraph1.CopyGraphToClipboard;
end;

procedure TPlottingForm.Print1Click(Sender: TObject);
begin
  ScGraph1.PrintGraph(-1, -1, 140, 120);
end;

procedure TPlottingForm.Printersetup1Click(Sender: TObject);
begin
  DemoForm.PrinterSetupDialog1.Execute;
end;

procedure TPlottingForm.Symbols2Click(Sender: TObject);
begin
  Symbols2.Checked := Symbols2.Checked xor true;
  lSymbs := Symbols2.Checked;
  ScGraph1.SetSeriesPoints(1, lSymbs, lSymb, lSymbSize);
end;

procedure TPlottingForm.Plotlines1Click(Sender: TObject);
begin
  PlotLines1.Checked := PlotLines1.Checked xor true;
  lLines := PlotLines1.Checked;
  ScGraph1.SetSeriesLine(1, lLines, lMode, lw, lStyle);
end;

procedure TPlottingForm.Autometrics1Click(Sender: TObject);
begin
  ScGraph1.Autometrics := ScGraph1.Autometrics xor true;
  Autometrics1.Checked := ScGraph1.Autometrics;
end;

procedure TPlottingForm.Help1Click(Sender: TObject);
begin
  HelpForm.HelpMemo.Lines.Assign(PlottingText);
  HelpForm.ShowModal;
end;

end.



