unit Axes;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ScGraph, Menus, StdCtrls;

type
  TAxesForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Close1: TMenuItem;
    Printersetup1: TMenuItem;
    Print1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Edit1: TMenuItem;
    Copygraph1: TMenuItem;
    Mouse1: TMenuItem;
    ScGraph1: TScGraph;
    Scaling1: TMenuItem;
    Moving1: TMenuItem;
    Label1: TLabel;
    Label2: TLabel;
    Drawing1: TMenuItem;
    Autometrics1: TMenuItem;
    Help1: TMenuItem;
    procedure Close1Click(Sender: TObject);
    procedure Printersetup1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure Copygraph1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Scaling(Sender: TObject);
    procedure ScGraph1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ScGraph1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Moving1Click(Sender: TObject);
    procedure ScGraph1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Drawing1Click(Sender: TObject);
    procedure Autometrics1Click(Sender: TObject);
    procedure Help1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AxesForm: TAxesForm;
  AxesText: TStringList;

implementation

uses DemoMain, Help;

{$R *.DFM}

const
  ScaleMode: boolean = false;
  DrawMode : boolean = false;

var
  XX1, YY1, XX2, YY2, MinXX, MaxXX, MinYY, MaxYY: double;

procedure TAxesForm.Close1Click(Sender: TObject);
begin
  DemoForm.CloseWindow1Click(Self);
end;

procedure TAxesForm.Printersetup1Click(Sender: TObject);
begin
  DemoForm.PrinterSetupDialog1.Execute;
end;

procedure TAxesForm.Print1Click(Sender: TObject);
begin
  ScGraph1.PrintGraph(-1, -1, 140, 120);
end;

procedure TAxesForm.Copygraph1Click(Sender: TObject);
begin
  ScGraph1.CopyGraphToClipboard;
end;

procedure TAxesForm.FormCreate(Sender: TObject);
var i: integer;
begin
  with ScGraph1 do
  begin
    Plotting := false;

    SetSeries(1, true, true, clNavy, '---');
    AddPoint(1, 0, 1);
    for i := 1 to 100 do
    begin
      AddPoint(1, i/10, sin(i/2)/i*2);
      AddPoint(1, -i/10, sin(i/2)/i*2);
    end;
    SetSeriesLine(1, true, pmLine, 2, psSolid);

    SetSeries(2, true, true, clRed, '');
    SetSeriesLine(2, true, pmLine, 2, psDot);
    SetSeriesPoints(2, true, psTriangleUp, 10);
    Scaling(Self);
    Plotting := true;
  end;

  AxesText := TStringList.Create;
  with AxesText do begin
   Add(' Edit  : Copy Graph - copies graph to clipboard');
   Add('         Autometrics- autoadjust various sizes,');
   Add('         line widths and distances');
   Add(' Mouse : ');
   Add('    - Scaling: clicking and dragging the mouse ');
   Add('         changes both x- and y-scale factors   ');
   Add('    - Moving : clicking and dragging the mouse ');
   Add('         moves the plot                        ');
   Add('    - Drawing: clicking the mouse button draws ');
   Add('         symbols and lines on the plot         ');
   Add(' ');
   Add('  (see also ScGraph.txt for further properties)');
  end;
end;

procedure TAxesForm.FormDestroy(Sender: TObject);
begin
  AxesText.Free;
end;

procedure TAxesForm.Exit1Click(Sender: TObject);
begin
  DemoForm.Exit1Click(Self);
end;

procedure TAxesForm.Scaling(Sender: TObject);
begin
  Scaling1.Checked:= true;
  Moving1.Checked:= false;
  Drawing1.Checked:= false;
  ScaleMode:= true;
  DrawMode:= false;
  ScGraph1.Cursor:= crSizeNESW;
end;

procedure TAxesForm.Moving1Click(Sender: TObject);
begin
  Scaling1.Checked:= false;
  Moving1.Checked:= true;
  Drawing1.Checked:= false;
  ScaleMode:= false;
  DrawMode:= false;
  ScGraph1.Cursor:= crDefault;
end;

procedure TAxesForm.Drawing1Click(Sender: TObject);
begin
  Scaling1.Checked:= false;
  Moving1.Checked:= false;
  Drawing1.Checked:= true;
  ScaleMode:= false;
  DrawMode:= true;
  ScGraph1.Cursor:= crCross;
end;

procedure TAxesForm.ScGraph1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  with ScGraph1 do
  begin
    XX1:= GetMouseX(X);  YY1:= GetMouseY(Y);
    MinXX:= XScale.Min;  MaxXX:= XScale.Max;
    MinYY:= YScale.Min;  MaxYY:= YScale.Max;
    if DrawMode then AddPoint(2, XX1, YY1);
  end;
end;

procedure TAxesForm.ScGraph1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if not DrawMode then
    with ScGraph1 do
    begin
      XX2:= GetMouseX(X);
      YY2:= GetMouseY(Y);
      if ScaleMode then
      begin // change scales
        XScale.Max:= XScale.Min + (XScale.Max - XScale.Min) /
                         (XX2 - XScale.Min) * (XX1 - XScale.Min);
        YScale.Max:= YScale.Min + (YScale.Max - YScale.Min) /
                         (YY2 - YScale.Min) * (YY1 - YScale.Min);
      end
      else
      begin // move graph
        XScale.Min:= XScale.Min - XX2 + XX1;
        XScale.Max:= XScale.Max - XX2 + XX1;
        YScale.Min:= YScale.Min - YY2 + YY1;
        YScale.Max:= YScale.Max - YY2 + YY1;;
      end;
    end;
end;

procedure TAxesForm.ScGraph1MouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
  Label1.Caption := 'X= ' + FloatToStrF(ScGraph1.GetMouseX(X), ffGeneral, 3, 5);
  Label2.Caption := 'Y= ' + FloatToStrF(ScGraph1.GetMouseY(Y), ffGeneral, 3, 5);
end;

procedure TAxesForm.Autometrics1Click(Sender: TObject);
begin
  ScGraph1.Autometrics := ScGraph1.Autometrics xor true;
  Autometrics1.Checked := ScGraph1.Autometrics;
end;

procedure TAxesForm.Help1Click(Sender: TObject);
begin
  HelpForm.HelpMemo.Lines.Assign(AxesText);
  HelpForm.ShowModal;
end;

end.
