(* E. Sorokin  1998 *)

(* Examples for sscanf and DeFormat *)

var
     Ext : extended; si : single;
     Cp : comp;
     Cu, Cu1 : currency;
     CF, NCF : byte;
     S,FS : AnsiString;
     ss : string[30];
     I : integer;
     b : byte;
     sh : shortint;
     TS : TMemoryStream;

begin

 {Some correct examples}
    // Scan a float. Size specifier not omitted, default used.
    DeFormat('1.23e456','%f',[@Ext]);

    // Scan a 64-bit hex integer in C notation.
    // Conversion base by default, using 0x prefix.
    DeFormat('-0xEeddef0b4e93e34f', '%Li', [@Cp]);
    S:=Int64ToStr(Cp);

    // Scan a 64-bit oct integer in C notation.
    // Conversion base by default, using 0 prefix.
    sscanf('-01777777777777777777777', '%Li', [@Cp]);
    S:=Int64ToHex(Cp);
    S:=Int64ToOct(Cp);

    // Scan till ":" and get a string and a byte divided by a comma
    // String result is of the ShortString type (size modifier h), and limited by 30.
   // Asterisk before pattern instructs sscanf to drop the part before ':'.
    sscanf(' Your name and age :  Kevin , 7', '%*[^:]: %30hs , %Hu', [@SS, @b]);

    // Same with a multi-word name and indirect maximum width.
    // With DeFormat, we put NIL as an argument to drop the first part.
    DeFormat(' Name and age: Ibrahim ibn Hottab , 2300', ' %[^:]: %*h[^,] , %u', [nil, SizeOf(SS)-1, @SS, @i]);

    // Retrieve a Pascal-style comment to S, excluding braces
    DeFormat(' Uses scanf;  {this is a comment} ', '%[^{]{ %l[^}] ', [nil, @S]);

    // remove a Unix-style comment from a string
    S:=' Parameter = Value  # Everything after # is ignored';
    sscanf(PChar(S), ' %l[^#]', [@S]);

    // if the whole project is in the $Q+ mode,
    // this raises an overflow exception in Currency type
    try
      S:='$123456789123456789';
      DeFormat(S,'$%m',[@cu]);
    except
      on EOverflow do Beep;
    end;

    // Try all currency formats
    for CF:=0 to 3 do begin // loop over CurrencyFormat
      CurrencyFormat:=CF;
      for NCF:=0 to 15 do begin
        NegCurrFormat:=NCF;
        Cu1:=987654321.01;
        Cu:=0;
        S:=Format(' %m ',[Cu1]);
        i:=DeFormat(S, '%M', [@Cu]);
        if (i <> 1) or (Cu <> Cu1) then
          Break;
        Cu1:=-987654321.01;
        Cu:=0;
        S:=Format('%m',[Cu1]);
        i:=DeFormat(S, '%M', [@Cu]);
        if (i <> 1) or (Cu <> Cu1) then
          Break;
      end;
    end;

    // in $R+ mode this should generate overrange error in the shortInt type
    S:='128';
    sscanf(PChar(S),'%Hd',[@sh]);

    // Try StrToCurrF
    Cu:=-123456789.0987;
    S:=Format('%m',[Cu]);
    Cu:=StrToCurrF(S);

    // Do the same using %M format
    S:=Format('%m',[Cu]);
    Cu:=0;
    DeFormat(S, '%M', [@Cu]);

    // fscanf demonstration
    TS:=TMemoryStream.Create;
    FS:='Total price for %d pieces of %s is '#13#10#9#9'%f';
    S:=Format(FS, [5,'gold',12345.67]);
    TS.Write(PChar(S)^,Length(S)); TS.Position:=0;
    Cu:=0; b:=0; SS:=''; 
    i:=fscanf(TS, PChar(FS), [@b, @SS[1],@si]);
    TS.Free;

  {Typical errors}

    // Sscanf uses Single as default, type conflict.
    sscanf('45e6','%e',[@Ext]);

    i:=10;
    // PChar type used with too few characters allocated.
    sscanf('Variable_i_will_be_overwritten!', '%s', [@SS[1]]);

    //Size specifier forgotten, default is integer.
    DeFormat(' -2', '%d', [@sh]);

    i:=0;
    //Submitted a value, not a pointer. 
    DeFormat(' 12345 ', '%d', [i]);


