unit new_canv;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  ComCtrls, ExtCtrls, StdCtrls;


type

  TMyCanvas = class( TPanel )
  private
      X_TOP,
      Y_TOP: integer;
      MAX_X,
      MAX_Y: integer;
  public
      Constructor Create( AOwner: TComponent );
      Destructor Destroy; override;
      procedure Paint; override;

      Procedure Clear_Canvas;
      Procedure Set_color( R, G, B: integer );
      Procedure DrawLine( x1, y1, x2, y2: integer );
      Procedure DrawPixel( x1, y1: integer );
      Procedure DrawEllipse( x1, y1, R1, R2: integer );
      Procedure TextOut( x1, y1: integer; s: ShortString );
  end;

implementation

Constructor TMyCanvas.Create( AOwner: TComponent );
begin
     inherited Create( AOwner );
     Color := 0;
     Align := alClient;
     BevelInner := bvNone;
     BevelOuter := bvNone;
end;

Destructor TMyCanvas.Destroy;
begin
     inherited Destroy;
end;

procedure TMyCanvas.Paint;
begin
     inherited Paint;
end;
//-------------------------------------------------------

Procedure TMyCanvas.Clear_Canvas;
var i: integer;
begin
     X_TOP := 0;
     Y_TOP := 0;
     MAX_X := Width;
     MAX_Y := Width;

     Canvas.Pen.Color := 0 ;
     Canvas.Brush.Color := 0 ;
     Canvas.Brush.Style := bsSolid;
     Canvas.Rectangle( X_TOP, Y_TOP, X_TOP + MAX_X, Y_TOP + MAX_Y );
end;

Procedure TMyCanvas.Set_color( R, G, B: integer );
begin
     Canvas.Pen.Color := R + (G shl 8) + (B shl 16) ;
end;

Procedure TMyCanvas.DrawLine( x1, y1, x2, y2: integer );
begin
     X_TOP := 0;
     Y_TOP := 0;
     MAX_X := Width;
     MAX_Y := Width;
     Canvas.MoveTo( X_TOP + x1-1, Y_TOP + y1-1 );
     Canvas.LineTo( X_TOP + x2-1, Y_TOP + Y2-1 );
end;

Procedure TMyCanvas.DrawPixel( x1, y1: integer );
begin
     X_TOP := 0;
     Y_TOP := 0;
     MAX_X := Width;
     MAX_Y := Width;
     Canvas.Pixels[ X_TOP + x1, Y_TOP + y1 ] := Canvas.Pen.Color;
end;

Procedure TMyCanvas.DrawEllipse( x1, y1, R1, R2: integer );
begin
     Canvas.Brush.Style := bsClear;
     Canvas.Ellipse(x1-R1, y1-R2, x1+R1, y1+R2);
end;

Procedure TMyCanvas.TextOut( x1, y1: integer; s: ShortString );
begin
     Canvas.Font.Color := Canvas.Pen.Color;
     Canvas.TextOut( x1, y1, s );
end;

end.
