// SB3D class library
// ver 1.0

//-------------------------------------------------------------
// TColor
//-------------------------------------------------------------

class TColor
   integer R, G, B
   function Set( new_r, new_g, new_b ) as TColor
      R = new_r
      G = new_g
      B = new_b
      Set = self
   end function
end class

//-------------------------------------------------------------
// TPoint
//-------------------------------------------------------------

class TPoint
   integer x, y, z
   function Set( new_x, new_y, new_z ) as TPoint
      x = new_x
      y = new_y
      z = new_z
      Set = self
   end function
end class

//-------------------------------------------------------------
// TElem
//-------------------------------------------------------------

class TElem
   TPoint p1
   TPoint p2
   function Set_rec( x1, y1, z1, x2, y2, z2 ) as TElem
      p1.x = x1
      p1.y = y1
      p1.z = z1
      p2.x = x2
      p2.y = y2
      p2.z = z2
      Set_rec = Self
   end function
end class

//-------------------------------------------------------------
// TObject
//-------------------------------------------------------------

class TObject

   TColor  Color
   integer x
   integer y
   integer z
   integer N

   double  A_xz
   double  A_xy
   double  A_yz

   TElem   E[100]

   function Init( new_x, new_y, new_z ) as TObject
      N = 0
      z = new_z     
      x = new_x   
      y = new_y 
      A_xy = 0
      A_xz = 0
      A_yz = 0
      Color.Set( 255, 255, 255 )
      Init = Self
   end function

   function Read_data as TObject
      N = Load_data()
      for i=0 to N-1
         Get_data( i, e[i].p1, e[i].p2 )
      next i
   end function

   function Set( new_x, new_y, new_z ) as TObject
      x = new_x
      y = new_y
      z = new_z
      Set = Self
   end function

   function Set_color( new_r, new_g, new_b ) as TColor
      Color.Set( new_r, new_g, new_b )
   end function

   function Move( delta_x, delta_y, delta_z ) as TObject
      x = x + delta_x
      y = y + delta_y
      z = z + delta_z
      if z < 0 then
         z = 0
      end if
      Move = Self
   end function

   function Rotate_xz( delta_xz ) as TObject
      for i=0 to N-1
         Rotate_point( e[i].p1.x, e[i].p1.z, delta_xz )
         Rotate_point( e[i].p2.x, e[i].p2.z, delta_xz )
      next i
   end function

   function Rotate_xy( delta_xy ) as TObject
      for i=0 to N-1
         Rotate_point( e[i].p1.x, e[i].p1.y, delta_xy )
         Rotate_point( e[i].p2.x, e[i].p2.y, delta_xy )
      next i
   end function

   function Rotate_yz( delta_yz ) as TObject
      for i=0 to N-1
         Rotate_point( e[i].p1.y, e[i].p1.z, delta_yz )
         Rotate_point( e[i].p2.y, e[i].p2.z, delta_yz )
      next i
   end function

   function add_rec( x1, y1, z1, x2, y2, z2 ) as integer
      if N < 99 then
         E[N].p1.x = x1
         E[N].p1.y = y1
         E[N].p1.z = z1
         E[N].p2.x = x2
         E[N].p2.y = y2
         E[N].p2.z = z2
         inc N
      end if
      add_rec = N
   end function

end class

//-------------------------------------------------------------
// TScreen
//-------------------------------------------------------------

class TCanvas

   integer x0   // Canvas center, x - coordinate
   integer y0   // Canvas center, y - coordinate
   integer z0   // Logical distance to screen

   function Init( new_x, new_y, new_z ) as integer
      x0 = new_x
      y0 = new_y
      z0 = new_z
//      if z0 < 200 then
//         z0 = 200
//      end if
   end function

   function Draw( F as TObject ) as integer
      Draw_object( x0, y0, z0, F )
   end function

end class

//-------------------------------------------------------------
//-------------------------------------------------------------

