unit browser;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Grids, DBGrids, DB, DBTables, DBCtrls, RXMisc,
  Buttons, SBasic, SBClass, ComCtrls, Tabs, new_canv, Math;

type

  RPoint = record
      x, y, z: integer;
  end;

  PElement = ^RElement;
  RElement = record
      P1, P2: RPoint;
  end;

  TBrowsForm = class(TForm)
    SBasic1: TSBasic;
    SBasic2: TSBasic;

    Panel1: TPanel;
    Panel2: TPanel;
    BrowsPanel: TPanel;

    Table1: TTable;
    DataSource1: TDataSource;
    DBNavigator1: TDBNavigator;
    DBGrid1: TDBGrid;

    ExitButton: TButton;
    RunButton: TButton;
    ClearButton: TSpeedButton;
    ResetButton: TSpeedButton;
    AboutButton: TButton;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Panel4: TPanel;
    SourceMemo: TDBMemo;
    Panel5: TPanel;
    ClassesMemo: TMemo;
    Splitter: TPanel;
    TabSheet3: TTabSheet;
    WatchCodePanel: TPanel;
    Splitter1: TPanel;
    Panel3: TPanel;
    WatchTabSet: TTabSet;
    CodeListBox: TListBox;
    WatchNotebook: TNotebook;
    VarListBox: TListBox;
    ConstListBox: TListBox;
    FuncListBox: TListBox;
    ResListBox: TListBox;
    TabSheet4: TTabSheet;
    CanvasPanel: TPanel;
    Panel6: TPanel;
    FuncComboBox: TComboBox;
    Panel7: TPanel;
    A_xzTrackBar: TTrackBar;
    Label1: TLabel;
    Label2: TLabel;
    A_xyTrackBar: TTrackBar;
    Label3: TLabel;
    A_yzTrackBar: TTrackBar;
    X_TrackBar: TTrackBar;
    Label4: TLabel;
    Label5: TLabel;
    Y_TrackBar: TTrackBar;
    Label6: TLabel;
    Z_TrackBar: TTrackBar;
    TabSheet5: TTabSheet;
    Panel8: TPanel;
    DataMemo: TDBMemo;
    Table1Key: TAutoIncField;
    Table1Title: TStringField;
    Table1Source: TBlobField;
    Table1Data: TBlobField;
    ErrorLabel: TLabel;
    LineLabel: TLabel;
    OptionCheckBox: TCheckBox;

    procedure RunButtonClick(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ClearButtonClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure AboutButtonClick(Sender: TObject);
    procedure SplitterMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SplitterMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure SplitterMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure BrowsPanelResize(Sender: TObject);
    procedure Splitter1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure WatchTabSetClick(Sender: TObject);
    procedure ResetButtonClick(Sender: TObject);
    procedure FuncComboBoxClick(Sender: TObject);
    procedure A_xzTrackBarChange(Sender: TObject);
    procedure ClassesMemoChange(Sender: TObject);
    procedure SourceMemoEnter(Sender: TObject);
    procedure SourceMemoExit(Sender: TObject);
    procedure SourceMemoKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ClassesMemoEnter(Sender: TObject);
    procedure ClassesMemoKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    SplitControl : TSplitControl;
    Point_xz     : integer;
    Point_xy     : integer;
    Point_yz     : integer;
    Point_xi     : integer;
    Point_yi     : integer;
    Point_zi     : integer;
    DataList     : TList;
    IsDirty      : boolean;
    Want_save    : boolean;
    procedure fill_combo;
    procedure Set_values;
    procedure Show_line1;
    procedure Show_line2;
  public
    MyCanvas     : TMyCanvas;
  end;

function FUNC_SET_COLOR( Data: TObject ): Real;
function FUNC_LINE( Data: TObject ): Real;
function FUNC_PIXEL( Data: TObject ): Real;
function FUNC_ELLIPSE( Data: TObject ): Real;
function FUNC_TEXTOUT( Data: TObject ): Real;
function FUNC_CLEAR( Data: TObject ): RSBResult;
function FUNC_LOAD_DATA( Data: TObject ): RSBResult;
function FUNC_GET_DATA( Data: TObject ): RSBResult;
function FUNC_ROTATE_POINT( Data: TObject ): RSBResult;
function FUNC_DRAW_OBJECT( Data: TObject ): RSBResult;

var
  BrowsForm: TBrowsForm;

//---------------------------------------------------------------
                      implementation
//---------------------------------------------------------------
uses about;

{$R *.DFM}


function GetExeDir: string;
var  i, N: integer;
begin
     Result := Application.ExeName;
     N := Length( Result );
     for i:=1 to Length( Result ) do
         if Result[i] = '\' then N := i;
     SetLength( Result, N );
end;

//-------------------------------------------------------------------
//   TBrowsForm
//-------------------------------------------------------------------

procedure TBrowsForm.FormCreate(Sender: TObject);
var  H1, H2 : Integer;
     A1, A2 : Integer;
     D1, D2 : TDateTime;
begin
     ChDir( GetExeDir );
     Table1.DataBaseName := GetExeDir;
     Table1.Active := true;
     SplitControl := TSplitControl.Create( Self );
     DataList := TList.Create;
     MyCanvas  := TMyCanvas.Create( Self );
     CanvasPanel.InsertControl( MyCanvas );

     Want_save := false;
     IsDirty   := true;
     if FileExists( 'classes.bin' ) then
     begin
          A1 := FileAge( 'classes.bas' );
          A2 := FileAge( 'classes.bin' );
          if A1 < A2 then IsDirty  := false;
     end;
     ClassesMemo.Lines.LoadFromFile( GetExeDir + 'classes.bas' );
     WatchNotebook.PageIndex := 0;
     WatchTabSet.TabIndex := 0;
     PageControl1.ActivePage := TabSheet1;
     Point_xz := 0;
     Point_xy := 0;
     Point_yz := 0;

     SBasic1.SetClasses( SBasic2 );
     SBasic1.Add_function( 'SET_COLOR', FUNC_SET_COLOR, 3 );
     SBasic1.Add_function( 'LINE', FUNC_LINE, 4 );
     SBasic1.Add_function( 'PIXEL', FUNC_PIXEL, 2 );
     SBasic1.Add_function( 'ELLIPSE', FUNC_ELLIPSE, 4 );
     SBasic1.Add_function( 'TEXTOUT', FUNC_TEXTOUT, 3 );
     SBasic1.Add_functionEx( 'ROTATE_POINT', FUNC_ROTATE_POINT, 3, _INTEGER );
     SBasic1.Add_functionEx( 'CLEAR', FUNC_CLEAR, 0, _INTEGER );

     SBasic1.Add_functionEx( 'LOAD_DATA', FUNC_LOAD_DATA, 0, _INTEGER );
     SBasic1.Add_functionEx( 'GET_DATA', FUNC_GET_DATA, 3, _INTEGER );
     SBasic1.Add_functionEx( 'DRAW_OBJECT', FUNC_DRAW_OBJECT, 4, _INTEGER );
end;

procedure TBrowsForm.FormDestroy(Sender: TObject);
begin
     CanvasPanel.RemoveControl( MyCanvas );
     MyCanvas.Free;
     DataList.Free;
     Table1.Active := false;
     SplitControl.Free;
     if Want_save then
        ClassesMemo.Lines.SaveToFile( GetExeDir + 'classes.bas' );
end;

procedure TBrowsForm.ExitButtonClick(Sender: TObject);
begin
     Close;
end;

procedure TBrowsForm.FormShow(Sender: TObject);
begin
     DBGrid1.SetFocus;
end;

procedure TBrowsForm.Set_values;
var   A_xz: double;
      A_xy: double;
      A_yz: double;
      v1: integer;
begin
      Point_xz := A_xzTrackBar.Position;
      Point_xy := A_xyTrackBar.Position;
      Point_yz := A_yzTrackBar.Position;
      Point_xi := X_TrackBar.Position;
      Point_yi := Y_TrackBar.Position;
      Point_zi := Z_TrackBar.Position;
      A_xz := ( Point_xz - 7 ) * 70 / 7.0;
      A_xy := ( Point_xy - 7 ) * 70 / 7.0;
      A_yz := ( Point_yz - 7 ) * 70 / 7.0;
      SBasic1.Set_double( 'A_XZ', 0, A_xz );
      SBasic1.Set_double( 'A_XY', 0, A_xy );
      SBasic1.Set_double( 'A_YZ', 0, A_yz );
      SBasic1.Set_integer( 'Xi', 0, ( Point_xi - 7 ) * 100 );
      SBasic1.Set_integer( 'Yi', 0, ( Point_yi - 7 ) * 100 );
      SBasic1.Set_integer( 'Zi', 0, 100 + Point_zi * 100 );
      SBasic1.Set_integer( 'MAX_X', 0, MyCanvas.Width );
      SBasic1.Set_integer( 'MAX_Y', 0, MyCanvas.Height );
      SBasic1.Set_boolean( 'SHOW_ATTR', 0, OptionCheckBox.Checked );
end;

procedure TBrowsForm.RunButtonClick(Sender: TObject);
var  code: integer;
begin
     code := 0;
     if IsDirty then
     begin
          SBasic2.Clear_Data;
          code := SBasic2.Translate;
          IsDirty := false;
     end;
     SBasic1.Clear_Data;
     if code = 0 then
     if SBasic1.Translate = 0 then
     begin
          PageControl1.ActivePage := TabSheet4;
          Set_values;
          SBasic1.Execute;
          SBasic1.Fill_Watches;
          fill_combo;
     end
end;

procedure TBrowsForm.A_xzTrackBarChange(Sender: TObject);
begin
     if SBasic1.Code_Count > 0 then
     if ( Point_xz <> A_xzTrackBar.Position ) or
        ( Point_xy <> A_xyTrackBar.Position ) or
        ( Point_yz <> A_yzTrackBar.Position ) or
        ( Point_xi <> X_TrackBar.Position ) or
        ( Point_yi <> Y_TrackBar.Position ) or
        ( Point_zi <> Z_TrackBar.Position ) then
     begin
          Set_values;
          SBasic1.Execute;
     end;
end;

procedure TBrowsForm.ResetButtonClick(Sender: TObject);
begin
     SBasic1.Clear_Data;
     SBasic1.Reset_all;
     SBasic1.Fill_Watches;
     SBasic2.Clear_Data;
     SBasic2.Reset_all;
end;

procedure TBrowsForm.ClearButtonClick(Sender: TObject);
begin
     MyCanvas.Clear_Canvas;
end;

procedure TBrowsForm.AboutButtonClick(Sender: TObject);
begin
     AboutBox.ShowModal;
end;

procedure TBrowsForm.WatchTabSetClick(Sender: TObject);
begin
     WatchNotebook.PageIndex := WatchTabSet.TabIndex;
end;


procedure TBrowsForm.FuncComboBoxClick(Sender: TObject);
var  FName : ShortString;
     sb    : ShortString;
     Ip    : integer;
begin
     FName := Trim( FuncComboBox.Text );
     Ip := pos('.', FName );
     if Ip = 0 then sb := FName
               else sb := copy( FName, Ip+1, Length( FName ) - Ip );

     CodeListBox.Clear;
     FuncListBox.Clear;
     ConstListBox.Clear;
     VarListBox.Clear;
     ResListBox.Clear;

     SBasic1.Fill_code( FName, CodeListBox );
     SBasic1.Fill_list( sb, _VAR, VarListBox );
     SBasic1.Fill_list( sb, _CONST, ConstListBox );
     SBasic1.Fill_list( sb, _RES, ResListBox );
     SBasic1.Fill_list( sb, _FUNC, FuncListBox );
end;

procedure TBrowsForm.fill_combo;
var  i  : integer;
     F1 : TSBFunc;
     T1 : TSBType;
     sb : ShortString;
begin
     FuncComboBox.Clear;
     FuncComboBox.Items.Add( 'Main' );
     for i:=0 to SBasic1.Functions.Count-1 do
     begin
          F1 := TSBFunc( SBasic1.Functions.Items[i] );
          if F1.Code <> nil then
          begin
               if F1.ID_class = -1 then sb := F1.F_name
               else begin
                    T1 := TSBType( SBasic1.Types.Items[ F1.ID_class ] );
                    sb := T1.T_name + '.' + F1.F_name;
               end;
               FuncComboBox.Items.Add( sb );
          end;
     end;
     FuncComboBox.ItemIndex := 0;
end;

procedure TBrowsForm.ClassesMemoChange(Sender: TObject);
begin
     IsDirty := true;
     Want_save := true;
end;

//-------------------------------------------------------------------
//   Show line numbers
//-------------------------------------------------------------------

procedure TBrowsForm.Show_line1;
var i, s, Ip: integer;
begin
     s := 0;
     i := 0;
     Ip := SourceMemo.SelStart;
     while ( i < SourceMemo.Lines.Count ) and ( s <= Ip ) do
     begin
          s := s + length( SourceMemo.Lines[i] ) + 2;
          inc(i);
     end;
     LineLabel.Caption := 'Line: ' + FormatFloat( '##0', i );
end;

procedure TBrowsForm.Show_line2;
var i, s, Ip: integer;
begin
     s := 0;
     i := 0;
     Ip := ClassesMemo.SelStart;
     while ( i < ClassesMemo.Lines.Count ) and ( s <= Ip ) do
     begin
          s := s + length( ClassesMemo.Lines[i] ) + 2;
          inc(i);
     end;
     LineLabel.Caption := 'Line: ' + FormatFloat( '##0', i );
end;

procedure TBrowsForm.SourceMemoEnter(Sender: TObject);
begin
     Show_line1;
end;

procedure TBrowsForm.SourceMemoExit(Sender: TObject);
begin
     LineLabel.Caption := 'Line: ';
end;

procedure TBrowsForm.SourceMemoKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
     Show_line1;
end;

procedure TBrowsForm.ClassesMemoEnter(Sender: TObject);
begin
     Show_line2;
end;

procedure TBrowsForm.ClassesMemoKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
     Show_line2;
end;

//-------------------------------------------------------------------
//   Splitter functions
//-------------------------------------------------------------------

procedure TBrowsForm.SplitterMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     if (Button = mbLeft) and (Shift = [ssLeft]) then
         SplitControl.BeginSizing( Splitter, BrowsPanel );
end;

procedure TBrowsForm.SplitterMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
     with SplitControl do
         if Sizing then ChangeSizing( X, Y );
end;

procedure TBrowsForm.SplitterMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
     with SplitControl do
         if Sizing then EndSizing;
end;

procedure TBrowsForm.Splitter1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     if (Button = mbLeft) and (Shift = [ssLeft]) then
         SplitControl.BeginSizing( Splitter1, WatchCodePanel );
end;

procedure TBrowsForm.BrowsPanelResize(Sender: TObject);
begin
     DBGrid1.Fields[0].DisplayWidth := DBGrid1.Width - 4;
end;

//-------------------------------------------------------------------
//   SBasic functions
//-------------------------------------------------------------------

function FUNC_SET_COLOR( Data: TObject ): Real;
var  P1, P2, P3: ^real;
     R, G, B: integer;
begin
      P1 := Get_param_pointer( Data, 0, 0 );
      P2 := Get_param_pointer( Data, 1, 0 );
      P3 := Get_param_pointer( Data, 2, 0 );
      if (P1 <> nil) and (P2 <> nil) and (P3 <> nil) then
      begin
           R  := Get_integer( Data, 0, 0 );
           G  := Get_integer( Data, 1, 0 );
           B  := Get_integer( Data, 2, 0 );
           BrowsForm.MyCanvas.Set_color( R, G, B );
      end;
      Result := 0;
end;

function FUNC_LINE( Data: TObject ): Real;
var  P1, P2, P3, P4: ^real;
     x1, x2, y1, y2: integer;
begin
      P1 := Get_param_pointer( Data, 0, 0 );
      P2 := Get_param_pointer( Data, 1, 0 );
      P3 := Get_param_pointer( Data, 2, 0 );
      P4 := Get_param_pointer( Data, 3, 0 );
      if (P1 <> nil) and (P2 <> nil) and (P3 <> nil) and (P4 <> nil) then
      begin
           x1 := Get_integer( Data, 0, 0 );
           y1 := Get_integer( Data, 1, 0 );
           x2 := Get_integer( Data, 2, 0 );
           y2 := Get_integer( Data, 3, 0 );
           BrowsForm.MyCanvas.DrawLine( x1, y1, x2, y2 );
      end;
      Result := 0;
end;

function FUNC_PIXEL( Data: TObject ): Real;
var  P1, P2: ^real;
     x1, y1: integer;
begin
      P1 := Get_param_pointer( Data, 0, 0 );
      P2 := Get_param_pointer( Data, 1, 0 );
      if (P1 <> nil) and (P2 <> nil) then
      begin
           x1 := Get_integer( Data, 0, 0 );
           y1 := Get_integer( Data, 1, 0 );
           BrowsForm.MyCanvas.DrawPixel( x1, y1 );
      end;
      Result := 0;
end;

function FUNC_ELLIPSE( Data: TObject ): Real;
var  P1, P2, P3, P4: ^real;
     x1, y1, R1, R2: integer;
begin
      P1 := Get_param_pointer( Data, 0, 0 );
      P2 := Get_param_pointer( Data, 1, 0 );
      P3 := Get_param_pointer( Data, 2, 0 );
      P4 := Get_param_pointer( Data, 3, 0 );
      if (P1 <> nil) and (P2 <> nil) and (P3 <> nil) and (P4 <> nil) then
      begin
           x1 := Get_integer( Data, 0, 0 );
           y1 := Get_integer( Data, 1, 0 );
           R1 := Get_integer( Data, 2, 0 );
           R2 := Get_integer( Data, 3, 0 );
           BrowsForm.MyCanvas.DrawEllipse( x1, y1, R1, R2 );
      end;
      Result := 0;
end;

function FUNC_TEXTOUT( Data: TObject ): Real;
var  P1, P2: ^real;
     x1, y1: integer;
     s1: ShortString;
begin
      P1 := Get_param_pointer( Data, 0, 0 );
      P2 := Get_param_pointer( Data, 1, 0 );
      if (P1 <> nil) and (P2 <> nil) then
      begin
           x1 := Get_integer( Data, 0, 0 );
           y1 := Get_integer( Data, 1, 0 );
           s1 := Get_string( Data, 2, 0 );
           BrowsForm.MyCanvas.TextOut( x1, y1, s1 );
      end;
      Result := 0;
end;

function FUNC_CLEAR( Data: TObject ): RSBResult;
begin
     BrowsForm.MyCanvas.Clear_Canvas;
     Result := Return_integer( 0 );
end;

function FUNC_LOAD_DATA( Data: TObject ): RSBResult;
var  i, j, n, v, code: integer;
     sb, st: ShortString;
     PR: PElement;
     dim : array[1..6] of integer;
procedure new_val;
begin
     if ( n < 6 ) and ( st <> '' ) then
     begin
          inc( n );
          val( st, v, code );
          dim[n] := v;
          st := '';
     end;
end;
begin
     with BrowsForm do
     begin
          DataList.Clear;
          for i:=0 to DataMemo.Lines.Count-1 do
          begin
               sb := Trim( DataMemo.Lines[i] );
               if sb <> '' then
               if not ( copy( sb, 1, 2 ) = '//' ) then
               begin
                    new( PR );
                    for j:=1 to 6 do dim[j] := 0;
                    st := '';
                    n  := 0;
                    for j:=1 to length( sb ) do
                    begin
                         case sb[j] of
                         '+', '-', '0'..'9': st := st + sb[j];
                         ',', ';', '/'     : new_val;
                         end;
                    end;
                    new_val;
                    PR^.p1.x := dim[1];
                    PR^.p1.y := dim[2];
                    PR^.p1.z := dim[3];
                    PR^.p2.x := dim[4];
                    PR^.p2.y := dim[5];
                    PR^.p2.z := dim[6];
                    DataList.Add( PR );
               end;
          end;
          Result := Return_integer( DataList.Count );
     end;
end;

function FUNC_GET_DATA( Data: TObject ): RSBResult;
var Ip, R: integer;
    P1, P2: ^RPoint;
    PR: PElement;
begin
     Ip := Get_integer( Data, 0, 0 );
     P1 := Get_param_pointer( Data, 1, 0 );
     P2 := Get_param_pointer( Data, 2, 0 );
     R  := 0;
     if (P1 <> nil) and (P2 <> nil) and (Ip < BrowsForm.DataList.Count) then
     begin
          PR := BrowsForm.DataList.Items[Ip];
          P1^.x := PR^.P1.x;
          P1^.y := PR^.P1.y;
          P1^.z := PR^.P1.z;
          P2^.x := PR^.P2.x;
          P2^.y := PR^.P2.y;
          P2^.z := PR^.P2.z;
          R := 1;
     end;
     Result := Return_integer( R );
end;

function FUNC_ROTATE_POINT( Data: TObject ): RSBResult;
var  Px, Py: ^integer;
     T1, T2, xi, yi: integer;
     A_xy: double;
     ri, a1, ai: double;
begin
     Px := Get_param_pointer( Data, 0, 0 );
     Py := Get_param_pointer( Data, 1, 0 );
     T1 := Get_param_type( Data, 0 );
     T2 := Get_param_type( Data, 1 );
     if (Px <> nil) and (Py <> nil) then
     if (T1 = SB_INTEGER) and (T2 = SB_INTEGER) then
     begin
          A_xy := Get_double( Data, 2, 0 );
          xi := Px^;
          yi := Py^;
          ri := sqrt( xi * xi + yi * yi );
          if ri <> 0 then
               ai := arcsin( abs(yi / ri) )
          else ai := 0;
          if (xi >= 0) and (yi >= 0) then
               a1 := ai + A_xy * pi / 180
          else if (xi < 0) and (yi >= 0) then
               a1 := pi - ai + A_xy * pi / 180
          else if (xi < 0) and (yi < 0) then
               a1 := pi + ai + A_xy * pi / 180
          else a1 := 0 - ai + A_xy * pi / 180;
          Px^ := Round( ri * cos( a1 ) );
          Py^ := Round( ri * sin( a1 ) );
     end;
     Result := Return_integer( 0 );
end;

function FUNC_DRAW_OBJECT( Data: TObject ): RSBResult;
type
    RColor = record
        R, G, B: integer;
    end;
    PSBObject = ^RSBObject;
    RSBObject = record
       Color: RColor;
       x, y,
       z, N: integer;
       A_xz,
       A_xy,
       A_yz: double;
       E: array[0..99] of RElement;
    end;
var
     P: PSBObject;
     i, zh: integer;
     x0, y0, z0: integer;
     x1, y1, z1: integer;
     x2, y2, z2: integer;
begin
     x0 := Get_integer( Data, 0, 0 );
     y0 := Get_integer( Data, 1, 0 );
     z0 := Get_integer( Data, 2, 0 );
     P  := Get_param_pointer( Data, 3, 0 );
     if (P <> nil) then
     begin
          BrowsForm.MyCanvas.set_color( P^.color.r, P^.color.g, P^.color.b );
          for i:=0 to P^.N-1 do
          begin
               zh := P^.z;
//               if P^.z < z0 then zh := z0
//                            else zh := P^.z;
               z1 := zh + P^.e[i].p1.z;
               x1 := x0 + Round( ( P^.x + P^.e[i].p1.x ) * z0 / z1 );
               y1 := y0 - Round( ( P^.y + P^.e[i].p1.y ) * z0 / z1 );
               z2 := zh + P^.e[i].p2.z;
               x2 := x0 + Round( ( P^.x + P^.e[i].p2.x ) * z0 / z2 );
               y2 := y0 - Round( ( P^.y + P^.e[i].p2.y ) * z0 / z2 );
               BrowsForm.MyCanvas.DrawLine( x1, y1, x2, y2 );
          end;
     end;
     Result := Return_integer( 0 );
end;

end.
