unit Ruler;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, ComCtrls;

type
  TRuler = class(TCustomPanel)
  private
    { Private declarations }
    FOwner: TComponent;
    FDragging: boolean;
    FRichEdit: TRichEdit;
    FUpdating: Boolean;
    FDragOfs: Integer;
    RulerLine: TBevel;
    FirstIndent: TLabel;
    LeftIndent: TLabel;
    RightIndent: TLabel;
    procedure SetupRuler;
    procedure RulerResize(Sender: TObject);
    procedure RulerItemMouseMove(Sender: TObject; Shift: TShiftState;
      X, Y: Integer);
    procedure RulerItemMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FirstIndentMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure LeftIndentMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure RightIndentMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  protected
    { Protected declarations }
    procedure Init;
  public
    { Public declarations }
    constructor Create(AOwner:TComponent); override;
    procedure Update;
  published
    { Published declarations }
    property RichEdit:TRichEdit read FRichEdit write FRichEdit;
    property Align;
  end;

procedure Register;

implementation

const
  RulerAdj = 4/3;
  GutterWid = 6;

procedure TRuler.RulerResize(Sender: TObject);
begin
  RulerLine.Width := Width - (RulerLine.Left*2);
end;


procedure TRuler.RulerItemMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
  if FDragging then
    TLabel(Sender).Left :=  TLabel(Sender).Left+X-FDragOfs;
end;



procedure TRuler.RulerItemMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  FDragOfs := (TLabel(Sender).Width div 2);
  TLabel(Sender).Left := TLabel(Sender).Left+X-FDragOfs;
  FDragging := True;
end;

procedure TRuler.LeftIndentMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  FDragging := False;
  If RichEdit <> nil then
    RichEdit.Paragraph.LeftIndent :=
      Trunc((LeftIndent.Left+FDragOfs-GutterWid) / RulerAdj)-
      RichEdit.Paragraph.FirstIndent;
  { SelectionChange(Sender); }
end;

procedure TRuler.FirstIndentMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  FDragging := False;
  If RichEdit <> nil then
    RichEdit.Paragraph.FirstIndent :=
      Trunc((FirstIndent.Left+FDragOfs-GutterWid) / RulerAdj);
  LeftIndentMouseUp(Sender, Button, Shift, X, Y);
end;

procedure TRuler.RightIndentMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  FDragging := False;
  If RichEdit <> nil then
    RichEdit.Paragraph.RightIndent :=
      Trunc((ClientWidth-RightIndent.Left+FDragOfs-2) / RulerAdj)
      -2*GutterWid;
  { SelectionChange(Sender); }
end;

procedure TRuler.Update;
begin
  If RichEdit <> nil then
  begin
    RightIndent.Left := Trunc(-RulerAdj*(RichEdit.Paragraph.RightIndent+
      2*GutterWid)+ClientWidth+FDragOfs-2);
    LeftIndent.Left := Trunc(RulerAdj*(RichEdit.Paragraph.LeftIndent+
      RichEdit.Paragraph.FirstIndent) - FDragOfs + GutterWid);
    FirstIndent.Left := Trunc(RulerAdj*RichEdit.Paragraph.FirstIndent-
      FDragOfs+GutterWid);
  end;
end; { end Update }


procedure TRuler.SetupRuler;
var
  I: Integer;
  S: String;
begin
  Font.Name := 'Arial';
  SetLength(S, 201);
  I := 1;
  while I < 200 do
  begin
    S[I] := #9;
    S[I+1] := '|';
    Inc(I, 2);
  end;
  Caption := S;
end;

procedure TRuler.Init;
begin
  OnResize := RulerResize;

  { Create RulerLine }
  RulerLine := TBevel.Create(self);
  RulerLine.Parent := self;
  RulerLine.Height := 2;
  RulerLine.Left := 4;
  RulerLine.Top := 12;
  RulerLine.Width := Width - 4;

  { Create FirstIndent }
  FirstIndent := TLabel.Create(self);
  FirstIndent.Parent := self;
  FirstIndent.Caption := '';
  FirstIndent.Font.Name := 'Wingdings';
  FirstIndent.Left := 2;
  FirstIndent.Top := 2;
  FirstIndent.Width := 10;
  FirstIndent.Height := 9;
  FirstIndent.Transparent := True;
  FirstIndent.OnMouseMove := RulerItemMouseMove;
  FirstIndent.OnMouseDown := RulerItemMouseDown;
  FirstIndent.OnMouseUp := FirstIndentMouseUp;

  { Create LeftIndent }
  LeftIndent := TLabel.Create(self);
  LeftIndent.Parent := self;
  LeftIndent.Caption := '';
  LeftIndent.Font.Name := 'Wingdings';
  LeftIndent.Left := 2;
  LeftIndent.Top := 12;
  LeftIndent.Width := 10;
  LeftIndent.Height := 11;
  LeftIndent.Transparent := True;
  LeftIndent.OnMouseMove := RulerItemMouseMove;
  LeftIndent.OnMouseDown := RulerItemMouseDown;
  LeftIndent.OnMouseUp := LeftIndentMouseUp;

  { Create RightIndent }
  RightIndent := TLabel.Create(self);
  RightIndent.Parent := self;
  RightIndent.Caption := '';
  RightIndent.Font.Name := 'Wingdings';
  RightIndent.Left := 250;
  RightIndent.Top := 14;
  RightIndent.Width := 10;
  RightIndent.Height := 9;
  RightIndent.Transparent := True;
  RightIndent.OnMouseMove := RulerItemMouseMove;
  RightIndent.OnMouseDown := RulerItemMouseDown;
  RightIndent.OnMouseUp := RightIndentMouseUp;
end;

constructor TRuler.Create(AOwner:TComponent);
begin
  inherited Create(AOwner);

  BevelInner := bvLowered;
  BevelOuter := bvNone;
  BevelWidth := 1;
  BorderStyle := bsNone;
  BorderWidth := 1;
  Height := 26;

  Init;

  SetupRuler;

  FOwner := AOwner;
end;

procedure Register;
begin
  RegisterComponents('Font', [TRuler]);
end;

end.
