unit textmacr;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TTextMacros = class(TComponent)
  private
    {Edit Control}
    FEditControl : TCustomEdit;
    {Macros}
    FStrings : TStrings;
    {instance for EditWndProc}
    ObjectInstance : Pointer;
    {the addres of the EditControl wndproc }
    FEditWndProcAdd : Pointer;

    procedure SetEditControl(Value : TCustomEdit);
    procedure SetStrings(Value : TStrings);
    function GetMacroIndex(ch : Integer) : Integer;
  protected
    {our wndproc}
    procedure EditWndProc(var Message: TMessage);
  public
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
  published
    property EditControl : TCustomEdit read FEditControl write SetEditControl;
    property Strings : TStrings read FStrings write SetStrings;
  end;

procedure Register;

implementation

constructor TTextMacros.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  {Create object instance for EditWndProc}
  ObjectInstance := MakeObjectInstance(EditWndProc);
  {Create Strings for text macros}
  FStrings := TStringList.Create;
end;

destructor TTextMacros.Destroy;
begin
  {Free Strings}
  FStrings.Free;
  {Free object instance}
  if (ObjectInstance <> Nil) then
    FreeObjectInstance(ObjectInstance);
  inherited Destroy;
end;

function TTextMacros.GetMacroIndex(ch : Integer) : Integer;
Var
  i : Integer;
begin
  Result := -1;
  for i := 0 to FStrings.Count - 1 do
    if(Length(FStrings[i]) > 0) And (ch = Integer(FStrings[i][1])) then begin
      Result := i;
      break;
    end;
end;

procedure TTextMacros.EditWndProc(var Message: TMessage);
Var
  i, j : Integer;
begin
  with TMessage(Message) do begin
    if(msg =  WM_SYSKEYDOWN) then begin
      {Is it a macros key}
      i := GetMacroIndex(wparam);
      if(i > -1) then begin
        {It is a macros key ! Lets type the macros text}
        for j := 3 to Length(FStrings[i]) do
          FEditControl.Perform(WM_CHAR, Integer(FStrings[i][j]), 0);
      end;
    end;
    {call the correct wndproc}
    Result := CallWindowProc(FEditWndProcAdd, FEditControl.Handle, Msg, WParam, LParam);
  end;
end;

procedure TTextMacros.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited;
  {Is the removed component EditControl ?}
  if(AComponent = FEditControl) And (Operation = opRemove) then
    FEditControl := Nil;
  {Is the removed component self component ?}
  if(AComponent = self) And (Operation = opRemove) then
    {call SetEditControl procedure}
    EditControl := Nil;
end;

procedure TTextMacros.SetEditControl(Value : TCustomEdit);
begin
  if(FEditControl = Value) then exit;
  {Restore the correct wndproc of the old EditControl}
  if(FEditControl <> Nil) And (FEditWndProcAdd <> Nil) then begin
    SetWindowLong(FEditControl.Handle, GWL_WNDPROC, LongInt(FEditWndProcAdd));
    FEditWndProcAdd := Nil;
  end;
  FEditControl := Value;
  {Save the wndproc of the new EditControl and replace it by our own procedure }
  if(FEditControl <> Nil) And  Not (csDesigning in FEditControl.ComponentState) then begin
    FEditWndProcAdd := Pointer(GetWindowLong(FEditControl.Handle, GWL_WNDPROC));
    SetWindowLong(FEditControl.Handle, GWL_WNDPROC, LongInt(ObjectInstance));
  end;
end;

procedure TTextMacros.SetStrings(Value : TStrings);
begin
  FStrings.Assign(Value);
end;

procedure Register;
begin
  RegisterComponents('RSDTIPS', [TTextMacros]);
end;

end.
