unit sortdbgr;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, DBGrids, DB;

type  
THeaderDBGridClickEvent = procedure (Sender: TObject; Field : TField;
    Var Sorted : Boolean) of object;


  TSortDBGrid = class(TDBGrid)
  private
    FHeaderClick : THeaderDBGridClickEvent;
    FlagBuzy : Boolean;
  protected
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
  published
    property OnHeaderClick : THeaderDBGridClickEvent read FHeaderClick write FHeaderClick; 
  end;

procedure Register;

implementation

procedure TSortDBGrid.MouseUp(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer);
Var
  Point : TGridCoord;
  Sorted : Boolean;
begin
  {Get mouse cordinates}
  Point := MouseCoord(X, Y);
  {call old MouseUp method}
  inherited;
  {Get true column index}
  if(dgIndicator in Options) then Dec(Point.X);
  {If the left mouse button was pressed  on the caption DBGrid then}
  if (Button = mbLeft) And (Point.Y = 0) And (Not FlagBuzy)then begin
    FlagBuzy := True;
    if Not (csDesigning in ComponentState) then begin
      Sorted := False;
      {If assign HeaderClick event and DataSet is Active}
      if Assigned(FHeaderClick) And (DataLink.Active) then
        FHeaderClick(self, Columns[Point.X].Field, Sorted);
    end;
  end;
  FlagBuzy := False;
end;


procedure Register;
begin
  RegisterComponents('RSDTIPS', [TSortDBGrid]);
end;

end.
