unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DB, DBTables, Buttons, StdCtrls, ExtCtrls, Grids, DBGrids, sortdbgr;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    SortDBGrid1: TSortDBGrid;
    RadioGroup1: TRadioGroup;
    Button1: TButton;
    BitBtn1: TBitBtn;
    Table: TTable;
    Query: TQuery;
    DS: TDataSource;
    procedure SortDBGrid1HeaderClick(Sender: TObject; Field: TField;
      var Sorted: Boolean);
    procedure RadioGroup1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses About;

{$R *.DFM}

procedure TForm1.SortDBGrid1HeaderClick(Sender: TObject; Field: TField;
  var Sorted: Boolean);
Var
  St : String;
begin
  St := Field.FieldName;
  if(DS.DataSet = Table) then begin
    if(Field = Table.FindField('partno')) Or
    (Field = Table.FindField('vendorno')) Or
    (Field = Table.FindField('description')) then begin
      Sorted := True;
      Table.IndexFieldNames := St;
      Table.Close;
      Table.Open;
    end;
  end else begin
      Sorted := True;
      Query.Close;
      if(Query.SQL.Count < 2) then   Query.SQL.Add('');
      Query.SQL[1] := 'Order by ' + St;
      Query.Open;
  end;
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
  if(RadioGroup1.ItemIndex = 0) then
    DS.DataSet := Table
  else DS.DataSet := Query;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  fmAboutBox.ShowModal;
end;

end.
