unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DB, DBTables, Grids, DBGrids, ExtCtrls, Buttons, StdCtrls, DBCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    DBGrid1: TDBGrid;
    Table1: TTable;
    DS: TDataSource;
    DBNavigator1: TDBNavigator;
    BitBtn1: TBitBtn;
    Button1: TButton;
    Label1: TLabel;
    Label2: TLabel;
    procedure Table1BeforePost(DataSet: TDataSet);
    procedure Table1BeforeEdit(DataSet: TDataSet);
    procedure Table1BeforeInsert(DataSet: TDataSet);
    procedure Button1Click(Sender: TObject);
    procedure Table1PostError(DataSet: TDataSet; E: EDatabaseError;
      var Action: TDataAction);
  private
    KeyValue : LongInt;
    procedure GetKeyValue(IsInsert : Boolean);
  end;

var
  Form1: TForm1;

implementation
uses BDE, About;

{$R *.DFM}

procedure TForm1.GetKeyValue(IsInsert : Boolean);
Var
  bm : TBookMark;
begin
  with Table1 do
    if(IsInsert) then begin
      DisableControls;
      bm := GetBookMark;
      SetKey;
      FieldByName('empno').AsInteger := KeyValue;
      GotoNearest;
      KeyValue := FieldByName('empno').AsInteger + 1;
      GotoBookMark(bm);
      FreeBookMark(bm);
      EnableControls;
    end else KeyValue := FieldByName('empno').AsInteger;
end;


Var
  FlagBeforePost : Boolean;

procedure TForm1.Table1BeforePost(DataSet: TDataSet);
begin
(*  if(FlagBeforePost) then exit;
  FlagBeforePost := True;

  try
    {Try to post}
    Table1.Post;
    {if Ok then set DataSet in the dsEdit state for usered post}
    Table1.Edit;
  except
     on E: EDBEngineError do begin
       if(E.ErrorCount > 0) And
        {DBIERR_KEYVIOL = (ERRBASE_INTEGRITY + ERRCODE_KEYVIOL); - Key violation error}
        (E.Errors[0].ErrorCode = DBIERR_KEYVIOL) then begin
           Table1.FieldByName('empno').AsInteger := KeyValue;
           ShowMessage('You''ve inserted the duplicate record');
         end;
    end;
  end;
  FlagBeforePost := False;*)
end;

procedure TForm1.Table1BeforeEdit(DataSet: TDataSet);
begin
  GetKeyValue(False);
end;

procedure TForm1.Table1BeforeInsert(DataSet: TDataSet);
begin
  GetKeyValue(True);
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  fmAboutBox.ShowModal;
end;

procedure TForm1.Table1PostError(DataSet: TDataSet; E: EDatabaseError;
  var Action: TDataAction);
Var
 verr : EDBEngineError;
begin
  if(E is EDBEngineError) then
    verr := EDBEngineError(E);
  with verr do begin
    if(ErrorCount > 0) And
    {DBIERR_KEYVIOL = (ERRBASE_INTEGRITY + ERRCODE_KEYVIOL); - Key violation error}
    (Errors[0].ErrorCode = DBIERR_KEYVIOL) then begin
      Table1.FieldByName('empno').AsInteger := KeyValue;
      ShowMessage('You''ve inserted the duplicate record. We have to correct you');
      Action := daRetry;
    end;
  end;

end;

end.
