unit RLEExpt;

interface

procedure Register;

implementation

uses
  Windows, Forms, ExptIntf, ToolIntf, Bmp2Rle;

type
  TRLEExpert = class(TIExpert)
  private
    MenuItem: TIMenuItemIntf;
  protected
    procedure OnClick(Sender: TIMenuItemIntf); virtual;
    procedure RLEClose (Sender : TObject; var Action: TCloseAction);
  public
    constructor Create; virtual;
    destructor Destroy; override;
    function GetStyle: TExpertStyle; override;
    function GetIDString: string; override;
    function GetName: string; override;
  end;

constructor TRLEExpert.Create;
var
  MainMenu : TIMainMenuIntf;
  ToolMenu : TIMenuItemIntf;
begin
  inherited Create;
  MenuItem := nil;

// This installs a new menu item and an OnClick handler under Install component
// on the Component menu.
  if Assigned (ToolServices) then
  begin
    MainMenu := ToolServices.GetMainMenu;
    try
      ToolMenu  := MainMenu.FindMenuItem ('ToolsMenu');
      try
        MenuItem := ToolMenu.InsertItem (-1, 'RLE Compressor',
               'RLECompressItem', '', 0, 0, 0, [mfEnabled, mfVisible], OnClick)
      finally
        ToolMenu.DestroyMenuItem
      end
    finally
      MainMenu.Free
    end
  end
end;

destructor TRLEExpert.Destroy;
begin
  if Assigned (MenuItem) then
    MenuItem.DestroyMenuItem;

  inherited Destroy
end;

function TRLEExpert.GetStyle: TExpertStyle;
begin
  Result := esAddIn
end;

function TRLEExpert.GetName: string;
begin
  Result := 'RLE COmpressor Expert'
end;

function TRLEExpert.GetIDString: string;
begin
  Result := 'Grahame.RLEExpert'
end;

procedure TRLEExpert.OnClick (Sender: TIMenuItemIntf);
begin
  if not Assigned (BitmapCompForm) then
    BitmapCompForm := TBitmapCompForm.Create (Application);

  with BitmapCompForm do
  begin
    Update;
    Show;
    OnClose := RLEClose
  end
end;

procedure TRLEExpert.RLEClose (Sender : TObject; var Action: TCloseAction);
begin
  Action := caFree;
  BitmapCompForm := nil
end;

procedure Register;
begin
  RegisterLibraryExpert (TRLEExpert.Create)
end;


end.
