unit RichPreview;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Richprint,Buttons, StdCtrls, arrowbtn,ComCtrls, Printers, Mask,ZLib,Registry;

const
  BufferSize = 4096;
type
  TCompress = class
   InFile: TStream;
   OutFile: TStream;
   ZStream: TCustomZLibStream;
   Buffer: array[0..BufferSize-1] of Byte;
  end;

type
  TRichPreviewForm = class(TForm)
    Panel1: TPanel;
    ArrowButton2: TArrowButton;
    Label1: TLabel;
    Bevel1: TBevel;
    Label2: TLabel;
    Bevel2: TBevel;
    SpeedButton1: TSpeedButton;
    BitBtn1: TBitBtn;
    Bevel3: TBevel;
    Bevel5: TBevel;
    Label4: TLabel;
    ArrowButton1: TArrowButton;
    PrintDialog1: TPrintDialog;
    ScrollBox1: TScrollBox;
    Image1: TImage;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    MaskEdit1: TMaskEdit;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label3: TLabel;
    Label9: TLabel;
    Bevel4: TBevel;
    Label10: TLabel;
    Edit1: TEdit;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure ArrowButton2Click(Sender: TObject);
    procedure ArrowButton1Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure MaskEdit1Change(Sender: TObject);
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure Label7DblClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Edit1KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
   ViewBitmap: TBitmap;
   LoadingMetafiles,LoadAgain,CompressPreview,FirstLoad,RichPreview2Exist: Boolean;
   Zoomfactor,ZoomStep: Double;
   Persistent: TMetafile;
  public
    { Public declarations }
   StartPage, EndPage,PreviewPaperHeight,PreviewPaperWidth: Integer;
   ImageIndex,PreviewImageHeight,PreviewImageWidth,MetafileCount: Integer;
   procedure FillImagelist;
  end;

var
  RichPreviewForm: TRichPreviewForm;

implementation

{$R *.DFM}

uses RichPreview2;

procedure TRichPreviewForm.FormClose(Sender: TObject; var Action: TCloseAction);
var I: Integer;
    FileTyp: file of TMetafile;
    FileNameMetafile,FileNameMetafileExt: string;
    Stoppen: Boolean;
begin
 ViewBitmap.free;
 Persistent.free;
{ RichPreviewForm.Free;}
 I:=0;
 Stoppen:=false;
 Repeat
  str(I,FileNameMetafileExt);
  FileNameMetafile:='PreviewMetafile'+FileNameMetafileExt;
  if CompressPreview then AssignFile(FileTyp,FileNameMetafile+'.CPR') else AssignFile(FileTyp,FileNameMetafile);
  {$I-}
  RESET(FileTyp);
 {$I+}
  IF IOResult=0 then
  begin
   CloseFile(FileTyp);
   Erase(FileTyp);
  end else Stoppen:=true;
  I:=I+1;
 until Stoppen or (I>10000);
 Action:=caFree;
 if RichPreview2Exist then Preview2.Close;
end;


procedure TRichPreviewForm.FillImagelist;
var FileNameMetafile,FileNameMetafileExt: string;
    FileTyp: file of TMetafile;
    FileCompress: TCompress;

begin
 MetaFileCanvasRichPrint.free;
 str(ImageIndex,FileNameMetafileExt);
 FileNameMetafile:='PreviewMetafile'+FileNameMetafileExt;
 AssignFile(FileTyp,FileNameMetafile);
 {$I-}
 REWRITE(FileTyp);
 {$I+}
 IF IOResult=0 then
 begin
  CloseFile(FileTyp);
  MetafileRichPrint.SaveToFile(FileNameMetafile);
 end
else MessageDlg('Can not save the page information (MetaFiles)',mtError,[mbOK],0);

 if CompressPreview then
 begin
 {compression}
  FileCompress := TCompress.Create;
  FileCompress.InFile := TFileStream.Create(FileNameMetafile, fmOpenRead);
  FileCompress.OutFile := TFileStream.Create(FileNameMetafile+'.CPR', fmCreate);
  FileCompress.ZStream := TCompressionStream.Create(clFastest, FileCompress.OutFile);
  FileCompress.ZStream.CopyFrom(FileCompress.InFile, 0);
  FileCompress.ZStream.Free;
  FileCompress.OutFile.Free;
  FileCompress.InFile.Free;
  FileCompress.Free;
  {erasing metafile}
  AssignFile(FileTyp,FileNameMetafile);
  {$I-}
  RESET(FileTyp);
 { $I+}
  IF IOResult=0 then
  begin
   CloseFile(FileTyp);
   Erase(FileTyp);
  end;
 end;
 MetafileRichPrint.free;
 MetafileCount:=ImageIndex;
 ImageIndex:=ImageIndex+1;
end;

procedure TRichPreviewForm.FormCreate(Sender: TObject);
var ZoomText: String;
    TRegIniFile1: TRegIniFile;
    Default: Boolean;
begin
 FirstLoad:=true;
 RichPreview2Exist:=false;
 Label10.Visible:=false;
 TRegIniFile1:=TRegIniFile.Create('RichPrint.Settings');
 Default:=true;
 with TRegIniFile1 do
 begin
  if OpenKey('Compress',false) then CompressPreview:=ReadBool('','CompressPreview',Default) else CompressPreview:=true;
 end;
 TRegIniFile1.Free;
 PreviewImageHeight:=round(0.95*Screen.Height);
 Height:=PreviewImageHeight;
 ClientHeight:=Height-27;
 if RatioPage <> 0 then PreviewImageWidth:=round((0.98*ClientHeight-71)/RatioPage) else
                        PreviewImageWidth:=round(0.707*(0.98*ClientHeight-71));   {A4 format}
 if round(1.0204*PreviewImageWidth) > Screen.Width then
 begin
  PreviewImageHeight:=round(Screen.Width/1.0204*PreviewImageWidth*PreviewImageHeight);
  PreviewImageWidth:=round(0.98*Screen.Width);
 end;
 Height:=PreviewImageHeight;
 ClientHeight:=Height-27;

 ImageIndex:=0;
 Width:=round(1.0204*PreviewImageWidth);
 ClientWidth:=Width-8;

 if ClientWidth < 395+round(0.02*ClientWidth) Then {in order to function with a screen resolution of 800*600 or even lower}
 begin                                             {preferable the resolution should be 1024*768}
  if ClientWidth < 288+round(0.02*ClientWidth) then
  begin
   Width:=round(1.0204*(288+0.02*ClientWidth));
   ClientWidth:=Width-8;
  end;
  Label8.Visible:=false;
  Label7.Visible:=false;
  Label6.Visible:=false;
  MaskEdit1.Visible:=false;
 end
else
 begin
  Label8.Visible:=true;
  Label7.Visible:=true;
  Label6.Visible:=true;
  MaskEdit1.Visible:=true;
 end;

 Image1.Top:=round(0.01*ClientHeight);
 Image1.Left:=round(0.01*ClientWidth);
 Image1.Height:=round(0.98*ClientHeight)-71;
 Image1.Width:=round(0.98*ClientWidth);
 ScrollBox1.Top:=Image1.Top;
 ScrollBox1.Left:=Image1.Left;
 ScrollBox1.Height:=Image1.Height;
 ScrollBox1.Width:=Image1.Width;
 Panel1.Top:=Image1.Top+Image1.Height;
 Panel1.Left:=Image1.Left;
 Panel1.Width:=Image1.Width;

 ViewBitmap:=TBitmap.Create;
 ViewBitmap.Height:=Image1.Height;
 ViewBitmap.Width:=Image1.Width;
 Image1.Picture.Graphic:=ViewBitmap;
 LoadingMetafiles:=true;
 Zoomfactor:=1;
 ZoomStep:=0.1;
 str(ZoomStep:5:3,ZoomText);
 MaskEdit1.Text:=ZoomText;
 str(ZoomFactor:5:3,ZoomText);
 Label7.Caption:=ZoomText;
 LoadAgain:=true;
 Persistent.free;
 Persistent:=TMetafile.Create;
 Edit1.Top:=Panel1.Top+4;
 Edit1.Left:=Panel1.Left+79;
end;

procedure TRichPreviewForm.FormPaint(Sender: TObject);
var PageText,TotalNumber: string;
    ShowMetafile: TMetafile;
    FileNameMetafile,FileNameMetafileExt: string;
    DrawRect: TRect;
    FileTyp: file of TMetafile;
    FileCompress: TCompress;
    Count,FilePresent: Integer;
    ClearBitmap: TBitmap;

procedure Scrolling;
begin
 if Zoomfactor > 1.00001 then
 begin
  with Scrollbox1 do
  begin
   HorzScrollBar.Range:=Round(Zoomfactor*ScrollBox1.Width);
   VertScrollBar.Range:=Round(Zoomfactor*ScrollBox1.Height);
   Image1.Width:=HorzScrollBar.Range;
   Image1.Height:=VertScrollBar.Range;
  end;
  if RichPreview2Exist then
  begin
   Preview2.Scrollbox1.HorzScrollBar.Range:=Round(Zoomfactor*ScrollBox1.Width);
   Preview2.Scrollbox1.VertScrollBar.Range:=Round(Zoomfactor*ScrollBox1.Height);
   Preview2.Image1.Width:=HorzScrollBar.Range;
   Preview2.Image1.Height:=VertScrollBar.Range;
  end;
 end
else
 begin
  with Scrollbox1 do
  begin
   HorzScrollBar.Range:=0;
   VertScrollBar.Range:=0;
   Image1.Width:=ScrollBox1.Width;
   Image1.Height:=ScrollBox1.Height;
  end;
  if RichPreview2Exist then
  begin
   Preview2.Scrollbox1.HorzScrollBar.Range:=0;
   Preview2.Scrollbox1.VertScrollBar.Range:=0;
   Preview2.Image1.Width:=ScrollBox1.Width;
   Preview2.Image1.Height:=ScrollBox1.Height;
  end;
 end;
 Image1.Picture.Bitmap.Width:=Image1.Width;
 Image1.Picture.Bitmap.Height:=Image1.Height;
 if RichPreview2Exist then
 begin
  Preview2.Image1.Picture.Bitmap.Width:=Image1.Width;
  Preview2.Image1.Picture.Bitmap.Height:=Image1.Height;
 end;
end;

begin
 if LoadingMetafiles then str(ImageIndex-1,FileNameMetafileExt) else str(ImageIndex,FileNameMetafileExt);
 FileNameMetafile:='PreviewMetafile'+FileNameMetafileExt;
{showmessage('ImageIndex='+FileNameMetafileExt);}
 if CompressPreview then AssignFile(FileTyp,FileNameMetafile+'.CPR') else AssignFile(FileTyp,FileNameMetafile);
 {$I-}
 RESET(FileTyp);
 {$I+}
 FilePresent:=IOResult;
 if FilePresent=0 then CloseFile(FileTyp);
 IF (FilePresent=0) and CompressPreview then
 begin
  FileCompress:=TCompress.Create;
  FileCompress.InFile := TFileStream.Create(FileNameMetafile+'.CPR', fmOpenRead);
  FileCompress.OutFile := TFileStream.Create(FileNameMetafile, fmCreate);
  FileCompress.ZStream := TDecompressionStream.Create(FileCompress.InFile);
  while True do
  begin
   Count := FileCompress.ZStream.Read(FileCompress.Buffer, BufferSize);
   if Count <> 0 then FileCompress.OutFile.WriteBuffer(FileCompress.Buffer, Count) else Break;
  end;
  FileCompress.ZStream.Free;
  FileCompress.OutFile.Free;
  FileCompress.InFile.Free;
  FileCompress.Free;
 end;
 IF FilePresent=0 then
 begin
  ShowMetafile:=TMetafile.Create;
  if LoadAgain then
  begin
   {CloseFile(FileTyp);}
   ShowMetafile.LoadFromfile(FileNameMetafile);
   Persistent.Assign(ShowMetafile);
  end else ShowMetafile.Assign(Persistent);
  if (not odd(ImageIndex)) or (not RichPreview2Exist) then
  begin
   {first window}
   Scrolling;
   DrawRect.Top:=0;
   DrawRect.Left:=0;
   DrawRect.Right:=Image1.Width;
   DrawRect.Bottom:=Image1.Height;
   ClearBitmap:=TBitmap.Create;
   ClearBitmap.Width:=Image1.Width;
   ClearBitmap.Height:=Image1.Height;
   Image1.Picture.Bitmap.Canvas.Draw(0,0,ClearBitmap);
   Image1.Picture.Bitmap.Canvas.StretchDraw(DrawRect,ShowMetafile);
   ClearBitmap.free;
   if LoadingMetafiles then STR(ImageIndex:4,PageText) else STR(ImageIndex+1:4,PageText);
   Edit1.Text:=PageText;
   str(MetafileCount+1,TotalNumber);
   Label10.Caption:='('+TotalNumber+')';
   Image1.Refresh;
   ShowMetafile.free;
  end
 else
  begin
   {second window}
   Scrolling;
   DrawRect.Top:=0;
   DrawRect.Left:=0;
   DrawRect.Right:=Image1.Width;
   DrawRect.Bottom:=Image1.Height;
   ClearBitmap:=TBitmap.Create;
   ClearBitmap.Width:=Image1.Width;
   ClearBitmap.Height:=Image1.Height;
   Preview2.Image1.Picture.Bitmap.Canvas.Draw(0,0,ClearBitmap);
   Preview2.Image1.Picture.Bitmap.Canvas.StretchDraw(DrawRect,ShowMetafile);
   ClearBitmap.free;
   if LoadingMetafiles then STR(ImageIndex:4,PageText) else STR(ImageIndex+1:4,PageText);
   Preview2.Label5.Caption:=PageText;
   str(MetafileCount+1,TotalNumber);
   Label10.Caption:='('+TotalNumber+')';
   Image1.Refresh;
   ShowMetafile.free;
  end;
   if CompressPreview then
   begin
  {erasing metafile}
   AssignFile(FileTyp,FileNameMetafile);
   {$I-}
   RESET(FileTyp);
  {$I+}
   IF IOResult=0 then
   begin
    CloseFile(FileTyp);
    Erase(FileTyp);
   end;
  end;
 end;
 FirstLoad:=false;
end;

procedure TRichPreviewForm.BitBtn1Click(Sender: TObject);
begin
 Close;
end;

procedure TRichPreviewForm.ArrowButton2Click(Sender: TObject);
var
 ClearBitmap: TBitmap;

begin
 LoadingMetafiles:=false;
 LoadAgain:=true;
 if RichPreview2Exist then
 begin
  Preview2.Label4.Visible:=true;
  Preview2.Label5.Visible:=true;
  ImageIndex:=ImageIndex+2;
 end else ImageIndex:=ImageIndex+1;
 if ImageIndex > MetafileCount Then ImageIndex:=MetafileCount;
 if (ImageIndex=MetafileCount) or (RichPreview2Exist and (ImageIndex+1=MetafileCount)) then
 begin
  ArrowButton1.Enabled:=true;
  Label2.Enabled:=true;
  Label9.Enabled:=true;
  ArrowButton2.Enabled:=false;
  Label1.Enabled:=false;
  Label3.Enabled:=false;
 end
else
 begin
  ArrowButton1.Enabled:=true;
  Label2.Enabled:=true;
  Label9.Enabled:=true;
  ArrowButton2.Enabled:=true;
  Label1.Enabled:=true;
  Label3.Enabled:=true;
 end;
 if RichPreview2Exist then
 begin
  Preview2.Label4.Visible:=true;
  Preview2.Label5.Visible:=true;
  FormPaint(Sender);
  ImageIndex:=ImageIndex+1;
  if ImageIndex <= MetafileCount then FormPaint(Sender) else
  begin
   ClearBitmap:=TBitmap.Create;
   ClearBitmap.Width:=Preview2.Image1.Width;
   ClearBitmap.Height:=Preview2.Image1.Height;
   Preview2.Image1.Picture.Bitmap.Canvas.Draw(0,0,ClearBitmap);
   Preview2.Label4.Visible:=false;
   Preview2.Label5.Visible:=false;
  end;
  ImageIndex:=ImageIndex-1;
 end
else
 begin
  FormPaint(Sender);
 end;
end;

procedure TRichPreviewForm.ArrowButton1Click(Sender: TObject);
begin
 if ImageIndex > MetafileCount Then ImageIndex:=MetafileCount;
 LoadingMetafiles:=false;
 LoadAgain:=true;
 if RichPreview2Exist then ImageIndex:=ImageIndex-2 else ImageIndex:=ImageIndex-1;
 if ImageIndex < 0 Then ImageIndex:=0;
 if ImageIndex=0 then
 begin
  ArrowButton1.Enabled:=false;
  Label2.Enabled:=false;
  Label9.Enabled:=false;
  ArrowButton2.Enabled:=true;
  Label1.Enabled:=true;
  Label3.Enabled:=true;
 end
else
 begin
  ArrowButton1.Enabled:=true;
  Label2.Enabled:=true;
  Label9.Enabled:=true;
  ArrowButton2.Enabled:=true;
  Label1.Enabled:=true;
  Label3.Enabled:=true;
 end;
 if RichPreview2Exist then
 begin
  Preview2.Label4.Visible:=true;
  Preview2.Label5.Visible:=true;
  FormPaint(Sender);
  ImageIndex:=ImageIndex+1;
  if ImageIndex <= MetafileCount then FormPaint(Sender);
  ImageIndex:=ImageIndex-1;
 end
else
 begin
  FormPaint(Sender);
 end;
end;

procedure TRichPreviewForm.SpeedButton1Click(Sender: TObject);
var Index,Count: Integer;
    Rectangle: TRect;
    FileNameMetafile,FileNameMetafileExt: string;
    PrintMetafile: TMetafile;
    FileTyp: file of TMetafile;
    FileCompress: TCompress;
begin
 LoadingMetafiles:=false;
 LoadAgain:=true;
 Screen.Cursor:=crHourGlass;
 PrintDialog1.FromPage:=1;
 PrintDialog1.ToPage:=MetafileCount+1;
 PrintDialog1.MinPage:=1;
 PrintDialog1.MaxPage:=MetafileCount+1;
 if PrintDialog1.Execute then
 begin
  if PrintDialog1.PrintRange=prAllPages then
  begin
   StartPage:=1;
   EndPage:=PrintDialog1.MaxPage;
  end;
  if PrintDialog1.PrintRange=prPageNums then
  begin
   StartPage:=PrintDialog1.FromPage;
   EndPage:=PrintDialog1.ToPage;
  end;
  PrintMetafile:=TMetafile.Create;
  Rectangle.Top:=0;
  Rectangle.Left:=0;
  Rectangle.Right:=PreviewPaperWidth;
  Rectangle.Bottom:=PreviewPaperHeight;
  for Index:=StartPage-1 to EndPage-1 do
  begin
   ImageIndex:=Index;
   FormPaint(Sender);
   str(Index,FileNameMetafileExt);
   FileNameMetafile:='PreviewMetafile'+FileNameMetafileExt;
   if CompressPreview then AssignFile(FileTyp,FileNameMetafile+'.CPR') else AssignFile(FileTyp,FileNameMetafile);
   {$I-}
   RESET(FileTyp);
    {$I+}
   IF IOResult=0 then
   begin
    CloseFile(FileTyp);
    {compression}
    IF CompressPreview then
    begin
     FileCompress:=TCompress.Create;
     FileCompress.InFile := TFileStream.Create(FileNameMetafile+'.CPR', fmOpenRead);
     FileCompress.OutFile := TFileStream.Create(FileNameMetafile, fmCreate);
     FileCompress.ZStream := TDecompressionStream.Create(FileCompress.InFile);
     while True do
     begin
      Count := FileCompress.ZStream.Read(FileCompress.Buffer, BufferSize);
      if Count <> 0 then FileCompress.OutFile.WriteBuffer(FileCompress.Buffer, Count) else Break;
     end;
     FileCompress.ZStream.Free;
     FileCompress.OutFile.Free;
     FileCompress.InFile.Free;
     FileCompress.Free;
    end;
    PrintMetafile.LoadFromfile(FileNameMetafile);
    Printer.BeginDoc;
    Printer.Canvas.StretchDraw(Rectangle,PrintMetafile);
    Printer.EndDoc;
    if CompressPreview then
    begin
     {erasing metafile}
     AssignFile(FileTyp,FileNameMetafile);
     {$I-}
     RESET(FileTyp);
    {$I+}
     IF IOResult=0 then
     begin
      CloseFile(FileTyp);
      Erase(FileTyp);
     end;
    end; 
   end;
  end;
  PrintMetafile.free;
 end;
 Screen.Cursor:=crDefault;
end;


procedure TRichPreviewForm.SpeedButton2Click(Sender: TObject);
var ZoomText: string;
    ClearBitmap: TBitmap;

begin
 LoadingMetafiles:=false;
 LoadAgain:=false;
 if ImageIndex > MetafileCount Then ImageIndex:=MetafileCount;
 Zoomfactor:=Zoomfactor+Zoomstep;
 str(Zoomfactor:5:3,ZoomText);
 Label7.Caption:=ZoomText;
 if Zoomfactor > 1 then SpeedButton3.Enabled:=true;
 if RichPreview2Exist then
 begin
  LoadAgain:=true;
  FormPaint(Sender);
  ImageIndex:=ImageIndex+1;
  if ImageIndex <= MetafileCount then FormPaint(Sender) else
  begin
   ClearBitmap:=TBitmap.Create;
   ClearBitmap.Width:=Preview2.Image1.Width;
   ClearBitmap.Height:=Preview2.Image1.Height;
   Preview2.Image1.Picture.Bitmap.Canvas.Draw(0,0,ClearBitmap);
  end;
  ImageIndex:=ImageIndex-1;
 end
else
 begin
  FormPaint(Sender);
 end;
end;

procedure TRichPreviewForm.SpeedButton3Click(Sender: TObject);
var ZoomText: string;
    ClearBitmap: TBitmap;
begin
 LoadingMetafiles:=false;
 LoadAgain:=false;
 if ImageIndex > MetafileCount Then ImageIndex:=MetafileCount;
 Zoomfactor:=Zoomfactor-Zoomstep;
 if Zoomfactor < 1 then Zoomfactor:=1;
 if Zoomfactor=1 then SpeedButton3.Enabled:=false else SpeedButton3.Enabled:=true;
 str(Zoomfactor:5:3,ZoomText);
 Label7.Caption:=ZoomText;
 if RichPreview2Exist then
 begin
  LoadAgain:=true;
  FormPaint(Sender);
  ImageIndex:=ImageIndex+1;
  if ImageIndex <= MetafileCount then FormPaint(Sender) else
  begin
   ClearBitmap:=TBitmap.Create;
   ClearBitmap.Width:=Preview2.Image1.Width;
   ClearBitmap.Height:=Preview2.Image1.Height;
   Preview2.Image1.Picture.Bitmap.Canvas.Draw(0,0,ClearBitmap);
  end;
  ImageIndex:=ImageIndex-1;
 end
else
 begin
  FormPaint(Sender);
 end;
end;

procedure TRichPreviewForm.MaskEdit1Change(Sender: TObject);
var Code: Integer;
begin
 val(MaskEdit1.Text,Zoomstep,Code);
 if Code <> 0 then ZoomStep:=0.1;
end;

procedure TRichPreviewForm.Image1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var ZoomText: string;
    ClearBitmap: TBitmap;
begin
 If Button=mbRight then
 begin
  Zoomfactor:=1;
  str(Zoomfactor:5:3,ZoomText);
  Label7.Caption:=ZoomText;
  SpeedButton3.Enabled:=false;
  if RichPreview2Exist then
  begin
   LoadAgain:=true;
   FormPaint(Sender);
   ImageIndex:=ImageIndex+1;
   if ImageIndex <= MetafileCount then FormPaint(Sender) else
   begin
    ClearBitmap:=TBitmap.Create;
    ClearBitmap.Width:=Preview2.Image1.Width;
    ClearBitmap.Height:=Preview2.Image1.Height;
    Preview2.Image1.Picture.Bitmap.Canvas.Draw(0,0,ClearBitmap);
   end;
   ImageIndex:=ImageIndex-1;
  end
 else
  begin
   FormPaint(Sender);
  end;
 end;
end;

procedure TRichPreviewForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var ClearBitmap: TBitmap;
begin
 LoadingMetafiles:=false;
 case Key of
  33: ArrowButton2Click(Sender);
  34: ArrowButton1Click(Sender);
  35: begin
       ImageIndex:=MetafileCount;
       Label1.Enabled:=false;
       Label3.Enabled:=false;
       Label2.Enabled:=true;
       Label9.Enabled:=true;
       if RichPreview2Exist then
       begin
        if (not odd(ImageIndex)) then {first window}
        begin
         FormPaint(Sender);
         ClearBitmap:=TBitmap.Create;
         ClearBitmap.Width:=Preview2.Image1.Width;
         ClearBitmap.Height:=Preview2.Image1.Height;
         Preview2.Image1.Picture.Bitmap.Canvas.Draw(0,0,ClearBitmap);
         Preview2.Label4.Visible:=false;
         Preview2.Label5.Visible:=false;
        end
       else
        begin {second window}
         FormPaint(Sender);
         ImageIndex:=ImageIndex-1;
         FormPaint(Sender);
         ImageIndex:=ImageIndex+1;
         Preview2.Label4.Visible:=true;
         Preview2.Label5.Visible:=true;
        end;
       end
      else
       begin
        FormPaint(Sender);
       end;
      end;
  36: begin
       ImageIndex:=0;
       Label1.Enabled:=true;
       Label3.Enabled:=true;
       Label2.Enabled:=false;
       Label9.Enabled:=false;
       if RichPreview2Exist then
       begin
        Preview2.Label4.Visible:=true;
        Preview2.Label5.Visible:=true;
        FormPaint(Sender);
        ImageIndex:=ImageIndex+1;
        if ImageIndex <= MetafileCount then FormPaint(Sender) else
        begin
         ClearBitmap:=TBitmap.Create;
         ClearBitmap.Width:=Preview2.Image1.Width;
         ClearBitmap.Height:=Preview2.Image1.Height;
         Preview2.Image1.Picture.Bitmap.Canvas.Draw(0,0,ClearBitmap);
        end;
        ImageIndex:=ImageIndex-1;
       end
      else
       begin
        FormPaint(Sender);
       end;
      end;
  38: with Scrollbox1 do VertScrollBar.Position:=VertScrollBar.Position-VertScrollBar.Increment;
  40: with Scrollbox1 do VertScrollBar.Position:=VertScrollBar.Position+VertScrollBar.Increment;
  37: with Scrollbox1 do HorzScrollBar.Position:=HorzScrollBar.Position-HorzScrollBar.Increment;
  39: with Scrollbox1 do HorzScrollBar.Position:=HorzScrollBar.Position+HorzScrollBar.Increment;
 end;
end;

procedure TRichPreviewForm.FormKeyPress(Sender: TObject; var Key: Char);
begin
 LoadingMetafiles:=false;
 case Key of
  'l','L': SpeedButton2Click(Sender);
  's','S': SpeedButton3Click(Sender);
  'p','P': SpeedButton1Click(Sender);
 end;
end;

procedure TRichPreviewForm.Label7DblClick(Sender: TObject);
var ZoomText: string;
    ClearBitmap: TBitmap;
begin
 Zoomfactor:=1;
 str(Zoomfactor:5:3,ZoomText);
 Label7.Caption:=ZoomText;
 SpeedButton3.Enabled:=false;
 if RichPreview2Exist then
 begin
  LoadAgain:=true;
  FormPaint(Sender);
  ImageIndex:=ImageIndex+1;
  FormPaint(Sender);
  ImageIndex:=ImageIndex-1;
  if ImageIndex <= MetafileCount then FormPaint(Sender) else
  begin
   ClearBitmap:=TBitmap.Create;
   ClearBitmap.Width:=Preview2.Image1.Width;
   ClearBitmap.Height:=Preview2.Image1.Height;
   Preview2.Image1.Picture.Bitmap.Canvas.Draw(0,0,ClearBitmap);
  end;
 end
else
 begin
  FormPaint(Sender);
 end;
end;

procedure TRichPreviewForm.FormActivate(Sender: TObject);
begin
 setfocus;
 if not FirstLoad then
 begin
  Label10.Visible:=true;
  ImageIndex:=0;
  LoadingMetafiles:=false;
  LoadAgain:=true;
  Label2.Enabled:=false;
  Label9.Enabled:=false;
  ArrowButton2.Enabled:=true;
  Label1.Enabled:=true;
  Label3.Enabled:=true;
  FormPaint(Sender);
  if (not RichPreview2Exist) and (MetafileCount > 0) then
  begin
{   Left:=round(0.05*Screen.Width);}
   Left:=round(0.5*(Screen.Width-2*Width));
   if Left < 0 Then Left:=0;
   if Left+2*Width <= Screen.Width then
   begin
    Preview2:=TPreview2.Create(Application);
    RichPreview2Exist:=true;
    SetFocus;
   end else Left:=round(0.5*(Screen.Width-Width));
  end;
  FormPaint(Sender);
  if RichPreview2Exist then
  begin
   ImageIndex:=ImageIndex+1;
   FormPaint(Sender);
   ImageIndex:=ImageIndex-1;
  end;
  RichPreviewForm.Caption:='Print Preview';
 end;
 if MetaFileCount > 0 then Edit1.Readonly:=false else Edit1.Readonly:=true;
end;


procedure TRichPreviewForm.Edit1KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
Var PageNumberInput,Code,DefPage: Integer;
    ClearBitmap: TBitmap;
begin
 if Edit1.Modified then
 begin
  val(Edit1.Text,PageNumberInput,code);
  if (PageNumberInput > 0) and (PageNumberInput <= MetafileCount+1) then
  begin
   if (not odd(PageNumberInput-1)) or (not RichPreview2Exist) then
   begin
    {first window}
    ImageIndex:=PageNumberInput-1;
    DefPage:=ImageIndex;
    FormPaint(Sender);
    ImageIndex:=PageNumberInput;
    if IMageIndex > MetaFileCount then
    begin
     ClearBitmap:=TBitmap.Create;
     ClearBitmap.Width:=Preview2.Image1.Width;
     ClearBitmap.Height:=Preview2.Image1.Height;
     Preview2.Image1.Picture.Bitmap.Canvas.Draw(0,0,ClearBitmap);
     Preview2.Label4.Visible:=false;
     Preview2.Label5.Visible:=false;
    end
   else
    begin
     Preview2.Label4.Visible:=true;
     Preview2.Label5.Visible:=true;
     FormPaint(Sender);
    end;
   end
  else
   begin
    {second window}
    ImageIndex:=PageNumberInput-2;
    DefPage:=ImageIndex;
    FormPaint(Sender);
    ImageIndex:=ImageIndex+1;
    FormPaint(Sender);
   end;
  end;
  ImageIndex:=DefPage;
  if ImageIndex > 0 then
  begin
   ArrowButton1.Enabled:=true;
   Label2.Enabled:=true;
   Label9.Enabled:=true;
  end
 else
  begin
   ArrowButton1.Enabled:=false;
   Label2.Enabled:=false;
   Label9.Enabled:=false;
  end;
  if ImageIndex >= MetafileCount then
  begin
   ArrowButton2.Enabled:=false;
   Label1.Enabled:=false;
   Label3.Enabled:=false;
  end
 else
  begin
   ArrowButton2.Enabled:=true;
   Label1.Enabled:=true;
   Label3.Enabled:=true;
  end;
 end;
end;

end.
