unit About;

interface

uses
  Windows, Forms, ExtCtrls, Controls, StdCtrls, mdURLLabel, Classes;

type
  TAboutBox = class(TForm)
    OKButton: TButton;
    Panel1: TPanel;
    ProgramIcon: TImage;
    ProgramName: TLabel;
    Copyright: TLabel;
    MoreBtn: TButton;
    Label1: TLabel;
    Label2: TLabel;
    mdURLLabel1: TmdURLLabel;
    Label3: TLabel;
    mdURLLabel2: TmdURLLabel;
    mdURLLabel3: TmdURLLabel;
    Label4: TLabel;
    mdURLLabel4: TmdURLLabel;
    procedure FormCreate(Sender: TObject);
    procedure MoreBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AboutBox: TAboutBox;

procedure ShowAboutBox;

implementation

uses
  SysUtils;
  
{$R *.DFM}

procedure ShowAboutBox;
begin
  with TAboutBox.Create(Application) do
  try
    Height := 173;
    MoreBtn.Visible := True;
    ShowModal;
  finally
    Free;
  end;
end;

procedure TAboutBox.FormCreate(Sender: TObject);
begin
  Caption := Format('About %s', [Application.Title]);
  ProgramIcon.Picture.Assign(Application.Icon);
  ProgramName.Caption := Application.Title;
end;

procedure TAboutBox.MoreBtnClick(Sender: TObject);
begin
  MoreBtn.Visible := False;
  Height := 230;
end;

end.

