(*
	*SMALL* System Registry Routines by Mikael Mre (C) Copyright 1999.
	I now trash these sources to the Pulic Domain.

	This is a library for easily accessing the system registry without
	using the Registry unit (that uses the SysUtils, Classes and Consts
	units).

	This code was made in about one hour in the need of *small* EXEs.
	Because Delphi (and Borland overall) rules, but the standard function
	units (Classes and SysUtils) takes 50KB (unacceptable sometimes, other
	times not), I had to make this unit. You can do much without the two
	extra units, but, as I said, Size does matter.. :-)

	Misuse of this unit IS allowed, but I want to be contacted first.
	Misuse is putting this code in "bad" software like virues and backdoors
	and selling it.

	Hope you like this unit.. Happy crismas, Mikael Mre <pcmicke@2.sbbs.se>,
	-> May 1999 <-.
*)

Unit RegFuncs;
Interface
Uses Windows;
Function GetRegString(MainKey:HKey; SubKey,ValName:PChar):String;
Function GetRegDWord(MainKey:HKey; SubKey,ValName:PChar):DWord;
Procedure GetRegBuf(MainKey:HKey; SubKey,ValName:PChar; Var Buf; BufSize:DWord);
Procedure CreateRegKey(MainKey:HKey; SubKey:PChar);
Procedure WriteRegString(MainKey:HKey; SubKey,ValName:PChar; Data:String);
Procedure WriteRegDWord(MainKey:HKey; SubKey,ValName:PChar; Data:DWord);
Procedure WriteRegBuf(MainKey:HKey; SubKey,ValName:PChar; Var Buf; BufSize:DWord);
Procedure DeleteRegValue(MainKey:HKey; SubKey,ValName:PChar);
Procedure DeleteRegKey(MainKey:HKey; SubKey:PChar); // WARNING!! May not work under NT!!
										  // See the RegDeleteKey functoin in the help.
Function RegKeyExists(MainKey:HKey; SubKey:PChar):Boolean;
Function RegValueExists(MainKey:HKey; SubKey,ValName:PChar):Boolean;
Implementation
Function GetRegString(MainKey:HKey; SubKey,ValName:PChar):String;
	Var
		Key	:HKey;
		C	:Array[0..1023] of Char;
		D,D2	:DWord;
	Begin
		RegOpenKeyEx(MainKey,SubKey,0,KEY_ALL_ACCESS,Key);
		D2 := SizeOf(C);
		RegQueryValueEx(Key,ValName,Nil,@D,@C,@D2);
		RegCloseKey(Key);
		Result := C;
	End;
Function GetRegDWord(MainKey:HKey; SubKey,ValName:PChar):DWord;
	Var
		Key	:HKey;
		D,D2	:DWord;
	Begin
		RegOpenKeyEx(MainKey,SubKey,0,KEY_ALL_ACCESS,Key);
		D2 := SizeOf(Result);
		RegQueryValueEx(Key,ValName,Nil,@D,@Result,@D2);
		RegCloseKey(Key);
	End;
Procedure GetRegBuf(MainKey:HKey; SubKey,ValName:PChar; Var Buf; BufSize:DWord);
	Var
		Key	:HKey;
		D,D2	:DWord;
	Begin
		RegOpenKeyEx(MainKey,SubKey,0,KEY_ALL_ACCESS,Key);
		RegQueryValueEx(Key,ValName,Nil,@D,@Buf,@BufSize);
		RegCloseKey(Key);
	End;
Procedure CreateRegKey(MainKey:HKey; SubKey:PChar);
	Var D:DWord;
	Begin
		RegCreateKeyEx(MainKey,SubKey,0,Nil,REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,Nil,D,Nil);
	End;
Procedure WriteRegString(MainKey:HKey; SubKey,ValName:PChar; Data:String);
	Var Key:HKey;
	Begin
		RegOpenKeyEx(MainKey,SubKey,0,KEY_ALL_ACCESS,Key);
		RegSetValueEx(Key,ValName,0,REG_SZ,PChar(Data),Length(Data));
		RegCloseKey(Key);
	End;
Procedure WriteRegDWord(MainKey:HKey; SubKey,ValName:PChar; Data:DWord);
	Var Key:HKey;
	Begin
		RegOpenKeyEx(MainKey,SubKey,0,KEY_ALL_ACCESS,Key);
		RegSetValueEx(Key,ValName,0,REG_DWord,@Data,4);
		RegCloseKey(Key);
	End;
Procedure WriteRegBuf(MainKey:HKey; SubKey,ValName:PChar; Var Buf; BufSize:DWord);
	Var Key:HKey;
	Begin
		RegOpenKeyEx(MainKey,SubKey,0,KEY_ALL_ACCESS,Key);
		RegSetValueEx(Key,ValName,0,REG_None,@Buf,BufSize);
		RegCloseKey(Key);
	End;
Procedure DeleteRegValue(MainKey:HKey; SubKey,ValName:PChar);
	Var Key:HKey;
	Begin
		RegOpenKeyEx(MainKey,SubKey,0,KEY_ALL_ACCESS,Key);
		RegDeleteValue(Key,ValName);
		RegCloseKey(Key);
	End;
Procedure DeleteRegKey(MainKey:HKey; SubKey:PChar);
	Begin
		RegDeleteKey(MainKey,SubKey);
	End;
Function RegKeyExists(MainKey:HKey; SubKey:PChar):Boolean;
	Var Key:HKey;
	Begin
		RegOpenKeyEx(MainKey,SubKey,0,KEY_ALL_ACCESS,Key);
		Result := Key <> 0;
		If Result then
			RegCloseKey(Key);
	End;
Function RegValueExists(MainKey:HKey; SubKey,ValName:PChar):Boolean;
	Var
		Key	:HKey;
		D,D2	:DWord;
	Begin
		RegOpenKeyEx(MainKey,SubKey,0,KEY_ALL_ACCESS,Key);
		D2 := 0;
		Result := RegQueryValueEx(Key,ValName,Nil,@D,Nil,@D2) = ERROR_SUCCESS;
		RegCloseKey(Key);
	End;
End.

// I know that if we're reading a string using GetRegDWord or similiar, we won't get
// a result of 0.
//
// ..I know..
