unit Unit2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, FileCtrl, ExtCtrls, Buttons,shellapi, Grids;

type
  Tdlggetic = class(TForm)
    Panel1: TPanel;
    Bevel1: TBevel;
    FileListBox1: TFileListBox;
    FilterComboBox1: TFilterComboBox;
    DriveComboBox1: TDriveComboBox;
    DirectoryListBox1: TDirectoryListBox;
    Panel2: TPanel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    StringGrid1: TStringGrid;
    procedure BitBtn1Click(Sender: TObject);
    procedure FileListBox1Click(Sender: TObject);
    procedure StringGrid1SelectCell(Sender: TObject; Col, Row: Longint;
      var CanSelect: Boolean);
    procedure StringGrid1DrawCell(Sender: TObject; Col, Row: Longint;
      Rect: TRect; State: TGridDrawState);
    procedure BitBtn2Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  dlggetic: Tdlggetic;
  iconfile : string = 'c:\windows\explorer.exe';
  iconnum  : integer = 7;
implementation

{$R *.DFM}

procedure Tdlggetic.BitBtn1Click(Sender: TObject);
begin
     close;
end;

procedure Tdlggetic.FileListBox1Click(Sender: TObject);
var ct : integer;
begin
     with stringgrid1 do begin
          colcount := 1;
          cells[0,0]:='no';
          with filelistbox1 do begin
               if fileexists(filename) then begin
                  ct := extracticon(hinstance,pchar(filename),-1);
                  if ct > 0 then begin
                     colcount := ct;
                     for ct := 0 to ct-1 do cells[ct,0]:=('11');
                  end;
               end;
          end;
     end;
end;

procedure Tdlggetic.StringGrid1SelectCell(Sender: TObject; Col,
  Row: Longint; var CanSelect: Boolean);
begin
     canselect := stringgrid1.cells[col,row] = '11';
end;

procedure Tdlggetic.StringGrid1DrawCell(Sender: TObject; Col, Row: Longint;
  Rect: TRect; State: TGridDrawState);
var icon : ticon;
begin
        stringgrid1.canvas.fillrect(rect);
     if fileexists(filelistbox1.filename) then try
        icon := ticon.create;
        icon.handle := extracticon(hinstance,pchar(filelistbox1.filename),col);
        stringgrid1.canvas.draw(rect.left+4,rect.top+4,icon);
     finally
            icon.free;
            bitbtn2.enabled := stringgrid1.cells[0,0]='11';
     end  else bitbtn2.enabled := false;
end;

procedure Tdlggetic.BitBtn2Click(Sender: TObject);
begin
     iconfile := filelistbox1.filename;
     iconnum := stringgrid1.col;
end;

procedure Tdlggetic.FormShow(Sender: TObject);
begin
     try
        drivecombobox1.drive := iconfile[1];
        directorylistbox1.directory := extractfilepath(iconfile);
        filelistbox1.filename := extractfilename(iconfile);
        filelistbox1click(nil);
        application.processmessages;
        stringgrid1.update;
        stringgrid1.col := iconnum;
     finally
     end;
end;

end.
