unit Unit2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, mkregex;

type
  TForm2 = class(TForm)
    mkreExpr1: TmkreExpr;
    Label3: TLabel;
    Label4: TLabel;
    Button2: TButton;
    Edit3: TEdit;
    Edit4: TEdit;
    mkreExpr2: TmkreExpr;
    Memo1: TMemo;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    btnSearch: TButton;
    Label5: TLabel;
    Edit1: TEdit;
    Label6: TLabel;
    ComboBox3: TComboBox;
    btnLoadBuffer: TButton;
    OpenDialog1: TOpenDialog;
    btnMatches: TButton;
    procedure Button1Click(Sender: TObject);
    procedure mkreExpr1Match(Sender: TObject; str: String; pos: Integer;
      var ret: Integer; re_registers: Tmkre_registers);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnLoadBufferClick(Sender: TObject);
    procedure btnSearchClick(Sender: TObject);
    procedure btnMatchesClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation

{$R *.DFM}

{
(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))

(([^:/?#]+))?
(//([^/?#]*))?
([^?#]*)
(\?([^#]*))?
(#(.*))
}
procedure TForm2.Button1Click(Sender: TObject);
begin
  mkreExpr1.Pattern := ComboBox1.Text;
  mkreExpr1.Str := ComboBox2.Text;
  mkreExpr1.DoMatch;
end;

procedure TForm2.mkreExpr1Match(Sender: TObject; str: String; pos: Integer;
  var ret: Integer; re_registers: Tmkre_registers);
var
  i: integer;
  sLine: string;
begin
  i := 0;
  while (re_registers._start[i] <> -1)
        and (re_registers._end[i] <> -1) do begin
    sLine := sLine + #13
             + copy(mkreExpr1.Str,
                    re_registers._start[i],
                    re_registers._end[i] - re_registers._start[i]);
    inc(i);
  end;
  ShowMessage(sLine + #13 + str);
end;

procedure TForm2.Button2Click(Sender: TObject);
begin
  mkreExpr2.Pattern := Edit3.Text;
  mkreExpr2.Str := Edit4.Text;
  mkreExpr2.Split(memo1.Lines, 0);
end;

procedure TForm2.FormCreate(Sender: TObject);
begin
  Edit1.Text := ExtractFilePath(ParamStr(0)) + 'Select a file';
end;

procedure TForm2.btnLoadBufferClick(Sender: TObject);
begin
  OpenDialog1.FileName := Edit1.Text;
  if OpenDialog1.Execute then
    Edit1.Text := OpenDialog1.FileName;
end;

procedure TForm2.btnSearchClick(Sender: TObject);
var
  buf: string;
  stream: TFileStream;

  posPtr: pointer;
begin
  if FileExists(Edit1.Text) then begin
    stream := TFileStream.Create(Edit1.Text, fmOpenRead);
    try
      SetLength(buf, stream.Size);
      Stream.ReadBuffer(pointer(buf)^, stream.size);
      mkreExpr1.Pattern := ComboBox3.Text;
      posPtr := mkreExpr1.DoBufferSearch(PChar(buf), Length(buf));
      if Assigned(posPtr) then
        ShowMessage(PChar(posPtr))
      else
        ShowMessage('Not found!');
    finally
      stream.Free;
    end;
  end else
    ShowMessage('File does not exist, select other file!');
end;

procedure TForm2.btnMatchesClick(Sender: TObject);
var
  buf: string;
  stream: TFileStream;
  i: integer;
  list: TStringList;
begin
  if FileExists(Edit1.Text) then begin
    stream := TFileStream.Create(Edit1.Text, fmOpenRead);
    list := TStringList.Create;
    try
      SetLength(buf, stream.Size);
      Stream.ReadBuffer(pointer(buf)^, stream.size);
      mkreExpr1.Pattern := ComboBox3.Text;
      mkreExpr1.DoBufferGetMatches(list, PChar(buf), Length(buf));
      Memo1.Lines.Clear;
      Memo1.Lines.BeginUpdate;
      try
        for i := 0 to list.Count -1 do begin
          Memo1.Lines.Add(list[i] + ':('+ IntToStr(integer(list.Objects[i]))+')');
        end;
      finally
        Memo1.Lines.EndUpdate;
      end;
    finally
      list.Free;
      stream.Free;
    end;
  end else
    ShowMessage('File does not exist, select other file!');
end;

end.
