program Project2;
{$APPTYPE CONSOLE}
uses
  SysUtils,
  Classes,
  mkregex;

procedure TestPattern(aPattern, aString: string);
var
  res: integer;
begin
  mkreSetPattern(aPattern);
  mkreSetString(aString);
  writeln('Pattern :' + aPattern);
  writeln('String  :' + aString);
  res := mkreDoSearch(1);
  if res > 0 then
    writeln('Found at ' + IntToStr(res))
  else
    Writeln('Not found!');
end;

procedure TestBuffer(aPattern, aFileName: string);
var
  stream: TFileStream;
  buf: pointer;
  res: pointer;
begin
  if FileExists(aFileName) then begin
    stream := TFileStream.Create(aFileName, fmOpenRead);
    try
      GetMem(buf, stream.Size);
      try
        stream.ReadBuffer(buf^, stream.Size);
        mkreSetPattern(aPattern);
        res := mkreDoBufferSearch(buf, stream.Size);
        writeln('Pattern :' + aPattern);
        writeln('FileName:' + aFileName);
        if Assigned(res) then
          writeln('Found at ' + IntToStr((integer(res) - integer(buf)) + 1))
        else
          Writeln('Not found!');
      finally
        FreeMem(buf);
      end;
    finally
      stream.Free;
    end;
  end;
end;

begin
  writeln('Test application.');
  mkreSetUseFastmap(true);
  TestPattern('^This', 'This is a test.');
  TestPattern('test', 'This is a test.');
  TestBuffer('P..t', ExtractFilePath(ParamStr(0)) + 'unit2.pas');
  writeln('Press Enter');
  readln;
end.