unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Mask;

type
  TForm1 = class(TForm)
    Button1: TButton;
    GroupBox1: TGroupBox;
    UserEdit: TEdit;
    Label1: TLabel;
    GroupBox2: TGroupBox;
    Label4: TLabel;
    SerialEdit: TEdit;
    Label3: TLabel;
    DecryptLabel: TLabel;
    BaseKeyEdit: TEdit;
    Label5: TLabel;
    Label6: TLabel;
    DecryptEdit: TEdit;
    procedure Button1Click(Sender: TObject);
    procedure DecryptEditExit(Sender: TObject);
  private
    { Private declarations }
    function Encryption(Src:string; Key: string; DecryptKey: integer; Encrypt: Boolean):string;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

function TForm1.Encryption(Src:string; Key: string; DecryptKey: integer; Encrypt: Boolean):string;
var
   idx         :integer;
   KeyLen      :Integer;
   KeyPos      :Integer;
   offset      :Integer;
   dest        :string;
   SrcPos      :Integer;
   SrcAsc      :Integer;
   TmpSrcAsc   :Integer;

begin
     if KeyLen = 0 then Key:='umbra';
     KeyLen:=Length(Key);
     KeyPos:=0;
     SrcPos:=0;
     SrcAsc:=0;
     if Encrypt then begin
          offset:=DecryptKey;
          dest:=format('%1.2x',[offset]);
          for SrcPos := 1 to Length(Src) do
          begin
               SrcAsc:=(Ord(Src[SrcPos]) + offset) MOD 255;
               if KeyPos < KeyLen then KeyPos:= KeyPos + 1 else KeyPos:=1;
               SrcAsc:= SrcAsc xor Ord(Key[KeyPos]);
               dest:=dest + format('%1.2x',[SrcAsc]);
               offset:=SrcAsc;
          end;
     end
     else
     begin
          offset:=StrToInt('$'+ copy(src,1,2));
          SrcPos:=3;
          repeat
                SrcAsc:=StrToInt('$'+ copy(src,SrcPos,2));
                if KeyPos < KeyLen Then KeyPos := KeyPos + 1 else KeyPos := 1;
                TmpSrcAsc := SrcAsc xor Ord(Key[KeyPos]);
                if TmpSrcAsc <= offset then
                     TmpSrcAsc := 255 + TmpSrcAsc - offset
                else
                     TmpSrcAsc := TmpSrcAsc - offset;
                dest := dest + chr(TmpSrcAsc);
                offset:=srcAsc;
                SrcPos:=SrcPos + 2;
          until SrcPos >= Length(Src);
     end;
     Result:=Dest;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  if DecryptEdit.Text='' then DecryptEdit.Text:='0';
  if UserEdit.Text='' then ShowMessage('Username invalid')
  else begin
    SerialEdit.Text:=Encryption(UserEdit.Text, BaseKeyEdit.Text, StrToInt(DecryptEdit.text), True);
    DecryptLabel.Caption:=Encryption(SerialEdit.Text, BaseKeyEdit.Text, StrToInt(DecryptEdit.text), False);
    end;
end;

procedure TForm1.DecryptEditExit(Sender: TObject);
begin
 try
  if StrToInt(DecryptEdit.Text)>255 then DecryptEdit.Text:='255';
  if StrToInt(DecryptEdit.Text)<0 then DecryptEdit.Text:='0';
 except
  DecryptEdit.Text:='126';
  end;
end;

end.
