unit RegisterApp;

{ This used for programs that are installed with InstallShield     }
{ InstallShield leaves Username, Companyname and Serial at         }
{ HKEY_LOCAL_MACHINE\SOFTWARE\                                     }
{                        (company)\                                }
{                             (AppName)\                           }
{                                   (Version)\                     }
{ the variables are Name, Company, Serial                          }
{                                                                  }
{ Programmed by Jack Bakker jaybee01@geocities.com                 }

interface

uses
  Windows, Messages, SysUtils, Controls, Classes, Dialogs, RegisterForm;

type
  TAppInfo = record
    User: shortstring;
    Company: shortstring;
    Serial: shortstring;
    end;

  TRegisterApp = class(TComponent)
  private
    FName: shortstring;     //Application name, provided in IS setup
    FCompany: shortstring;  //Company name, provided in IS setup
    FVersion: shortstring;  //Application version, provided in IS setup
    FDecryptKey: integer;      //0..255
    FBaseKey: shortstring;
    FLicense: shortstring;
    FUser: shortstring;
  protected
    function Encryption(Src:String; Encrypt: Boolean):string;
    procedure SetDecryptKey(value: integer);
  public
    procedure RegisterApp;  //Registers an application
    function IsRegistered: boolean; //performs a check
    function ReadAppInfo: TAppInfo; //public so you can read info for aboutboxes
    property License: shortstring read FLicense; //Companyname for the license
    property User: shortstring read FUser; //Username registration
  published
    property DecryptKey: integer read FDecryptKey write SetDecryptKey;
    property BaseKey: shortstring read FBaseKey write FBaseKey;
    property AppName: shortstring read FName write FName;
    property AppCompany: shortstring read FCompany write FCompany;
    property AppVersion: shortstring read FVersion write FVersion;
  end;

procedure Register;

implementation

uses Registry;

procedure TRegisterApp.RegisterApp;
var r: TRegistry;
begin
XRegisterEntryForm:=TXRegisterEntryForm.Create(Application); //creates the registration entry-form
 with XRegisterEntryForm do begin
 if ShowModal=mrOK then
  if (Encryption(Edit3.Text, False)=Edit1.Text) then begin
    r:=TRegistry.Create;
    r.RootKey:=HKEY_LOCAL_MACHINE;
    try
      r.OpenKey('Software', True);
      r.Openkey(FCompany, True);
      r.OpenKey(FName, True);
      r.OpenKey(FVersion, True);
      r.WriteString('Name', Edit1.Text);
      r.WriteString('Company', Edit2.Text);
      r.WriteString('Serial', Edit3.Text);
      ShowMessage(AppName+' was registered correctly. Restart the application to continue');
    except on ERegistryException do
      ShowMessage('Registration could not be completed due to registry error');
      end;
    end else ShowMessage('Serialnumber could not be confirmed');
  end;
XRegisterEntryForm.Free;  //frees the registration entry-form
end;

function TRegisterApp.ReadAppInfo: TAppInfo;
var
  r: TRegistry;
  a: TAppInfo;
begin
  r:=TRegistry.Create;
  r.RootKey:=HKEY_LOCAL_MACHINE;
  r.OpenKey('Software', False);
  r.Openkey(FCompany, False);
  r.OpenKey(FName, False);
  r.OpenKey(FVersion, False);
    try
      a.User:=r.ReadString('Name');
      a.Company:=r.ReadString('Company');
      a.Serial:=r.ReadString('Serial');
    except
      a.User:='';
      a.Company:='';
      a.Serial:='';
      end;
  Result:=a;
  r.CloseKey;
  r.Free;
end;

procedure TRegisterApp.SetDecryptKey(value: integer);
begin
  if value> 255 then FDecryptKey:=255;
  if value<0 then FDecryptKey:=0 else FDecryptKey:=value;
end;

function TRegisterApp.Encryption(Src:String; Encrypt: Boolean):string;
var
   idx         :integer;
   KeyLen      :Integer;
   KeyPos      :Integer;
   offset      :Integer;
   dest        :string;
   SrcPos      :Integer;
   SrcAsc      :Integer;
   TmpSrcAsc   :Integer;

begin
     if KeyLen = 0 then FBaseKey:='umbra';
     KeyLen:=Length(FBaseKey);
     KeyPos:=0;
     SrcPos:=0;
     SrcAsc:=0;
     if Encrypt then begin
          offset:=FDecryptKey;
          dest:=format('%1.2x',[offset]);
          for SrcPos := 1 to Length(Src) do
          begin
               SrcAsc:=(Ord(Src[SrcPos]) + offset) MOD 255;
               if KeyPos < KeyLen then KeyPos:= KeyPos + 1 else KeyPos:=1;
               SrcAsc:= SrcAsc xor Ord(FBaseKey[KeyPos]);
               dest:=dest + format('%1.2x',[SrcAsc]);
               offset:=SrcAsc;
          end;
     end
     else
     begin
          offset:=StrToInt('$'+ copy(src,1,2));
          SrcPos:=3;
          repeat
                SrcAsc:=StrToInt('$'+ copy(src,SrcPos,2));
                if KeyPos < KeyLen Then KeyPos := KeyPos + 1 else KeyPos := 1;
                TmpSrcAsc := SrcAsc xor Ord(FBaseKey[KeyPos]);
                if TmpSrcAsc <= offset then
                     TmpSrcAsc := 255 + TmpSrcAsc - offset
                else
                     TmpSrcAsc := TmpSrcAsc - offset;
                dest := dest + chr(TmpSrcAsc);
                offset:=srcAsc;
                SrcPos:=SrcPos + 2;
          until SrcPos >= Length(Src);
     end;
     Result:=Dest;
end;

function TRegisterApp.IsRegistered: boolean;
var
  a: TAppInfo;
begin
  a:=ReadAppInfo;
  if a.Company<>'' then FLicense:=a.Company else FLicense:='Test Company';
  if a.User<>'' then FUser:=a.User else FUser:='Test User';
  if Encryption(a.Serial, False)=a.User then Result:=True else Result:=False;
end;

procedure Register;
begin
  RegisterComponents('Samples', [TRegisterApp]);
end;

end.
