unit frmrtest;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,StdCtrls,
  ExtCtrls, rc6;

type
  TfrmTestRC6 = class(TForm)
    grpText: TGroupBox;
    btnDecrypt: TButton;
    btnEncrypt: TButton;
    edtTestText: TEdit;
    lblTestText: TLabel;
    grpFile: TGroupBox;
    btnFileEncrypt: TButton;
    odlFileEnc: TOpenDialog;
    sdlFileEnc: TSaveDialog;
    btnFileDecrypt: TButton;
    odlFileDec: TOpenDialog;
    sdlFileDec: TSaveDialog;
    rgrMode: TRadioGroup;
    grpKeySize: TGroupBox;
    rdb128: TRadioButton;
    rdb192: TRadioButton;
    rdb256: TRadioButton;
    edtVersion: TEdit;
    lblVersion: TLabel;
    Bevel1: TBevel;
    RC61: TRC6;
    grpCBCMAC: TGroupBox;
    btmMakeMAC: TButton;
    edtCBCMAC: TEdit;
    rdbECB: TRadioButton;
    rdbCBC: TRadioButton;
    rdbCFB: TRadioButton;
    rdbOFB: TRadioButton;
    lblCBCMAC: TLabel;
    procedure btnFileEncryptClick(Sender: TObject);
    procedure btnEncryptClick(Sender: TObject);
    procedure btnDecryptClick(Sender: TObject);
    procedure btnFileDecryptClick(Sender: TObject);
    procedure rdbECBClick(Sender: TObject);
    procedure rdbCBCClick(Sender: TObject);
    procedure rdbCFBClick(Sender: TObject);
    procedure rdbOFBClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure rdb128Click(Sender: TObject);
    procedure rdb192Click(Sender: TObject);
    procedure rdb256Click(Sender: TObject);
    procedure btmMakeMACClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmTestRC6: TfrmTestRC6;

implementation

{$R *.DFM}

procedure TfrmTestRC6.btnFileEncryptClick(Sender: TObject);
begin
     RC61.LoadIVString('Init Vector');
     RC61.InitialiseString('Pass Phrase');
     if odlFileEnc.Execute then
     begin
          if sdlFileEnc.Execute then
          begin
               RC61.EncryptFile(odlFileEnc.FileName, sdlFileEnc.FileName);
          end;
     end;
end;

procedure TfrmTestRC6.btnEncryptClick(Sender: TObject);
var
     Tempstr: string;
begin
     RC61.LoadIVString('Init Vector');
     RC61.InitialiseString('Pass Phrase');
     RC61.EncryptString(edtTestText.Text,Tempstr);
     edtTestText.Text := TempStr;
end;

procedure TfrmTestRC6.btnDecryptClick(Sender: TObject);
var
     Tempstr: string;
begin
     RC61.InitialiseString('Pass Phrase');
     RC61.LoadIVString('Init Vector');
     RC61.DecryptString(edtTestText.Text,Tempstr);
     edtTestText.Text := TempStr;
end;

procedure TfrmTestRC6.btnFileDecryptClick(Sender: TObject);
begin
     RC61.LoadIVString('Init Vector');
     RC61.InitialiseString('Pass Phrase');
     if odlFileDec.Execute then
     begin
          if sdlFileDec.Execute then
          begin
               RC61.DecryptFile(odlFileDec.FileName, sdlFileDec.FileName);
          end;
     end;
end;

procedure TfrmTestRC6.rdbECBClick(Sender: TObject);
begin
     RC61.CipherMode := ECB;
end;

procedure TfrmTestRC6.rdbCBCClick(Sender: TObject);
begin
     RC61.CipherMode := CBC;
end;

procedure TfrmTestRC6.rdbCFBClick(Sender: TObject);
begin
     RC61.CipherMode := CFB;
end;

procedure TfrmTestRC6.rdbOFBClick(Sender: TObject);
begin
     RC61.CipherMode := OFB;
end;

procedure TfrmTestRC6.FormCreate(Sender: TObject);
begin
     // set the standard values
     RC61.CipherMode := ECB;
     RC61.KeySize := Small128;

     // get the version of the component and display it
     edtVersion.Text := RC61.GetVersion;
end;

procedure TfrmTestRC6.rdb128Click(Sender: TObject);
begin
     RC61.KeySize := Small128;
end;

procedure TfrmTestRC6.rdb192Click(Sender: TObject);
begin
     RC61.KeySize := Med192;
end;

procedure TfrmTestRC6.rdb256Click(Sender: TObject);
begin
     RC61.KeySize := Large256;
end;

procedure TfrmTestRC6.btmMakeMACClick(Sender: TObject);
var
     TempString: String;
     ErrorCode: integer;
begin
     // set the key and IV up
     RC61.InitialiseString('CBC-MAC secret key');
     RC61.LoadIVString('CBC-MAC secret Init Vector');

     // load the data into the internal RC6 registers
     // the result of the encryption can be thrown away
     // or better, the mac can be produced during the encryption
     // and simply read out at the end
     RC61.EncryptString(edtTestText.Text, TempString);

     // see if we are in CBC mode (needed for CBC-MAC)
     ErrorCode := RC61.CBCMACString(TempString);
     if ErrorCode = MODE_NOT_CBC then
     begin
          // if we are in the wrong mode, show an error
          ShowMessage('You must set the mode to CBC to produce a CBC-MAC!');
          Exit;
     end;

     // check to see if there were other errors
     if ErrorCode = OK then
     begin
          // if not, show the CBC-MAC
          edtCBCMAC.Text := TempString;
     end;
end;

end.
