// Borland C++ Builder
// Copyright (c) 1995, 1998 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'rc6.pas' rev: 3.00

#ifndef rc6HPP
#define rc6HPP
#include <Classes.hpp>
#include <SysInit.hpp>
#include <System.hpp>

//-- user supplied -----------------------------------------------------------

namespace Rc6
{
//-- type declarations -------------------------------------------------------
#pragma pack(push, 1)
struct TQuadWord
{
	
	union
	{
		Byte b[16];
		int w[4];
		
	};
} ;
#pragma pack(pop)

typedef TQuadWord *PQuadWord;

typedef Byte TBlock[16];

#pragma pack(push, 1)
struct TRC6_ctx
{
	bool Initialised;
	bool IVInitialised;
	Byte IV[16];
	Byte ct[16];
	int S[44];
	union
	{
		int LongBuffer[4];
		Byte ByteBuffer[16];
		
	};
} ;
#pragma pack(pop)

typedef TBlock *PBlock;

enum TCipherMode { ECB, CBC, CFB, OFB };

enum TStringMode { smEncode, smNormal };

enum TKeySize { Small128, Med192, Large256 };

class DELPHICLASS TRC6;
class PASCALIMPLEMENTATION TRC6 : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	TRC6_ctx ctx;
	TCipherMode FCipherMode;
	TKeySize FKeySize;
	Byte FBuffer[4113];
	TBlock *PtrBuffer;
	TStringMode FStringMode;
	void __fastcall rotl(int &x, const int y);
	void __fastcall rotr(int &x, const int y);
	void __fastcall rc6_key_setup(const Byte * K, const int K_Size, const int KeyLength);
	void __fastcall rc6_block_decrypt(const TQuadWord &ct, TQuadWord &pt);
	void __fastcall rc6_block_encrypt(const TQuadWord &pt, TQuadWord &ct);
	int __fastcall EncryptBuffer(int &Len);
	int __fastcall DecryptBuffer(int &Len);
	void __fastcall EncryptBlockMode(void);
	void __fastcall DecryptBlockMode(void);
	void __fastcall EncBlock(void);
	void __fastcall DecBlock(void);
	void __fastcall NagRegister(void);
	System::AnsiString __fastcall EncodeString(System::AnsiString InputString);
	System::AnsiString __fastcall DecodeString(System::AnsiString InputString);
	
public:
	int __fastcall InitialiseString(const System::AnsiString Key);
	int __fastcall InitialiseByte(const Byte * Key, const int Key_Size, int keylength);
	void __fastcall LoadIVString(const System::AnsiString IVString);
	void __fastcall LoadIVByte(const Byte * IVByte, const int IVByte_Size, int IVLength);
	int __fastcall EncryptString(const System::AnsiString Input, System::AnsiString &Output);
	int __fastcall DecryptString(const System::AnsiString Input, System::AnsiString &Output);
	int __fastcall EncryptBlock(const Byte * Input, Byte * Output);
	int __fastcall DecryptBlock(const Byte * Input, Byte * Output);
	int __fastcall EncryptFile(const System::AnsiString InputFileName, System::AnsiString OutputFileName
		);
	int __fastcall DecryptFile(const System::AnsiString InputFileName, System::AnsiString OutputFileName
		);
	void __fastcall Burn(void);
	System::AnsiString __fastcall GetVersion();
	
__published:
	__property TCipherMode CipherMode = {read=FCipherMode, write=FCipherMode, nodefault};
	__property TKeySize KeySize = {read=FKeySize, write=FKeySize, nodefault};
	__property TStringMode StringMode = {read=FStringMode, write=FStringMode, nodefault};
public:
	/* TComponent.Create */ __fastcall virtual TRC6(Classes::TComponent* AOwner) : Classes::TComponent(
		AOwner) { }
	/* TComponent.Destroy */ __fastcall virtual ~TRC6(void) { }
	
};

//-- var, const, procedure ---------------------------------------------------
#define OK (Byte)(0)
#define KEY_NOT_SET (Shortint)(-1)
#define ZERO_KEY_LENGTH (Shortint)(-2)
#define MSG_TOO_SHORT (Shortint)(-3)
#define IV_NOT_SET (Shortint)(-4)
#define FILE_ERROR (Shortint)(-5)
#define BLOCKSIZE (Byte)(16)
#define BUFFERLENGTH (Word)(4096)
#define r (Byte)(20)
#define R24 (Byte)(44)
extern PACKAGE void __fastcall Register(void);

}	/* namespace Rc6 */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Rc6;
#endif
//-- end unit ----------------------------------------------------------------
#endif	// rc6
