unit FWSInfo;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	StdCtrls, ExtCtrls;

type
	TQIPWSInfo = class(TForm)
		Panel1: TPanel;
		Label2: TLabel;
		Label3: TLabel;
		Ver: TLabel;
		Status: TLabel;
		MaxSock: TLabel;
		btConfig: TButton;
    Bevel1: TBevel;
    Config: TLabel;
    IP: TLabel;
		procedure FormCreate(Sender: TObject);
		procedure FormClose(Sender: TObject; var Action: TCloseAction);
		procedure btConfigClick(Sender: TObject);
	private
		{ Private declarations }
	public
		{ Public declarations }
	end;

var
	QIPWSInfo: TQIPWSInfo;

implementation

uses FMain,FConfig;

{$R *.DFM}

procedure TQIPWSInfo.FormCreate(Sender: TObject);
begin
	if (fmQuickIP.stub = 0) then
	begin
		Ver.Caption := StrPas(WSData.szDescription);
		Status.Caption := StrPas(WSData.szSystemStatus);
		MaxSock.Caption := IntToStr(WSData.iMaxSockets);
		if isLan then
			Config.Caption := 'Configured as:  LAN connection'
		else
			Config.Caption := 'Configured as:  Dialup connection';
		IP.Caption := 'IP Address:   '+fmQuickIP.Icona.Hint;
	end else
	begin
		Ver.Caption := 'N/A';
		Status.Caption := 'No TCP/IP Stack available';
		MaxSock.Caption := 'N/A';
		Config.Caption := 'N/A';
		IP.Caption := 'N/A';
	end;
end;

procedure TQIPWSInfo.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	Action := caFree;
end;

procedure TQIPWSInfo.btConfigClick(Sender: TObject);
begin
	fmQuickIP.QIPTimer.Enabled := false;
	while fmQuickIP.Running do ;
	Application.CreateForm(TfmConfig,fmConfig);
	try
		fmConfig.ShowModal;
	finally
		fmConfig.Free;
		fmQuickIP.QIPTimer.Enabled := true;
	end;
end;

end.
