unit FMain;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	TrayIcon, ExtCtrls, Menus, Winsock, StdCtrls, Registry;

const
	VERSIONE = '2.0';

type
	TfmQuickIP = class(TForm)
		Icona: TTrayIcon;
		QIPTimer: TTimer;
		PopupMenu: TPopupMenu;
		Esci1: TMenuItem;
		Open1: TMenuItem;
		About1: TMenuItem;
		N1: TMenuItem;
    ImageList1: TImageList;
		QIPAniTimer: TTimer;
		procedure FormCreate(Sender: TObject);
		procedure QIPTimerTimer(Sender: TObject);
		procedure Esci1Click(Sender: TObject);
		procedure FormClose(Sender: TObject; var Action: TCloseAction);
		procedure IconaDblClick(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure Open1Click(Sender: TObject);
		procedure About1Click(Sender: TObject);
		procedure QIPAniTimerTimer(Sender: TObject);
	private
		{ Private declarations }
	public
		{ Public declarations }
		AniRunning,
		Running: boolean;
		Animated: boolean;
		stub: integer;
		Cur: Integer;
	end;

var
	fmQuickIP: TfmQuickIP;

	Version: Word = $0101;

	IsLan: boolean;
	Lang: byte;

	WSData: TWSAdata;

implementation

uses RAS, FWSInfo, FAbout, FHint;

{$R *.DFM}

function my_hostname:string;
const
	bufsize=255;
var
	buf: pointer;
	RemoteHost : PHostEnt;
begin
	buf := NIL;
	my_hostname:='';
	try
		getmem(buf,bufsize);
		Winsock.gethostname(buf,bufsize);
		if (char(buf^) <> #0) then
		begin
			RemoteHost := Winsock.GetHostByName(buf);
			my_hostname := '   '+pchar(RemoteHost^.h_name)+' ('+
										 IntToStr(ord(RemoteHost^.h_addr_list^[0]))+'.'+
										 IntToStr(ord(RemoteHost^.h_addr_list^[1]))+'.'+
										 IntToStr(ord(RemoteHost^.h_addr_list^[2]))+'.'+
										 IntToStr(ord(RemoteHost^.h_addr_list^[3]))+')   ';
		end	else
			my_hostname := '   127.0.0.1   ';
	finally
		if (buf <> NIL) then
			freemem(buf,bufsize);
	end;
end;

function RAS_my_hostname:string;
var
	bufsize: Longint;
	numEntries: Longint;
	x: Integer;
	entries: Array[1..100] of TRasConn;
	stat: TRasConnStatus;
	PPPIpInfo: TRasPppIp;
begin
	entries[1].dwSize := SizeOf(TRasConn);
	bufsize := SizeOf(TRasConn) * 100;
	FillChar(stat, Sizeof(TRasConnStatus), 0);
	stat.dwSize := Sizeof(TRasConnStatus);
	if (RasEnumConnections(@entries[1], bufsize, numEntries) = 0) then
	begin
		if numEntries > 0 then
		begin
			PPPIpInfo.dwSize := SizeOf(TRasPppIp);
			bufsize := SizeOf(TRasPppIp);
			if (RasGetProjectionInfo(entries[1].hrasconn,RASP_PppIp,@PPPIpInfo,bufsize) = 0) then
				Result := '   '+PPPIpInfo.szIpAddress+'   '
			else
				Result := '   Network is down   ';
		end else
			Result := '   Network is down   ';
	end else
		Result := '   Network is down   ';
end;

procedure TfmQuickIP.FormCreate(Sender: TObject);
var Reg: TRegistry;
begin
	Left := -Width;
	Top := (Screen.Height - Height) div 2;
	Running := false;
	AniRunning := false;
	Reg := TRegistry.Create;
	try
		with Reg do
		begin
			RootKey := HKEY_LOCAL_MACHINE;
			if OpenKey('\SOFTWARE\Caldani',true) then
			begin
				WriteString('','The GreatGulp');
				CloseKey;
			end;
			if OpenKey('\SOFTWARE\Caldani\QuickIP',true) then
			begin
				WriteString('Version',VERSIONE);
				WriteString('Language','English');
				CloseKey;
			end;
			RootKey := HKEY_CURRENT_USER;
			if OpenKey('\Software\Caldani\QuickIP',false) then
			begin
				try
					IsLan := ReadBool('Conn');
				except
					IsLan := true;
				end;
				try
					Animated := ReadBool('Anim');
				except
					Animated := true;
				end;
				CloseKey;
			end else
			begin
				IsLan := true;
				Animated := true;
			end;
		end;
	finally
		Reg.Free;
	end;
	stub := WSAStartup(Version, WSData);
	if (stub <> 0) then
		icona.Hint := '   No TCP/IP Stack available  '
	else
		icona.Hint := '   Looking for IP Address...   ';
	icona.show;
end;

procedure TfmQuickIP.QIPTimerTimer(Sender: TObject);
var a,b,c,d: byte;
		buffer:string;
		h: hWnd;
begin
	if not Running then
	begin
		Running := true;
		if (QIPTimer.Tag = 0) then
		begin
			ShowWindow(fmQuickIP.handle,SW_HIDE);
			QIPTimer.Enabled := false;
			QIPTimer.Tag := 1;
			QIPTimer.Interval := 5000;
			QIPTimer.Enabled := true;
		end else
		begin
			if (stub = 0) then
			begin
				if IsLan then
					Icona.Hint := my_hostname
				else
					Icona.Hint := RAS_my_hostname;

				if (Icona.Hint = '   Network is down   ') or
					 (not Animated) then
				begin
					QIPAniTimer.Enabled := false;
					Icona.Picture := Application.Icon;
				end else
				begin
					Cur := 0;
					QIPAniTimer.Enabled := true;
				end;

				Icona.Show;
				h := findWindow('TQIPWSInfo',nil);
				if (h <> 0) then
					QIPWSInfo.IP.Caption := 'IP Address:   '+Icona.Hint;
			end;
		end;
		Running := false;
	end;
end;

procedure TfmQuickIP.Esci1Click(Sender: TObject);
begin
	Close;
end;

procedure TfmQuickIP.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	Action := caFree;
end;

procedure TfmQuickIP.FormCloseQuery(Sender: TObject;
	var CanClose: Boolean);
begin
	QIPTimer.Enabled := false;
	QIPAniTimer.Enabled := false;
	while Running do ;
	while AniRunning do ;
	if (stub = 0) then
		WSACleanUp;
	icona.destroy;
	CanClose := true;
end;

procedure TfmQuickIP.IconaDblClick(Sender: TObject);
var h: hWnd;
begin
	h := findWindow('TQIPWSInfo',nil);
	if (h = 0) then
	begin
		Open1.Enabled := false;
		Application.CreateForm(TQIPWSInfo,QIPWSInfo);
		try
			QIPWSInfo.ShowModal;
		finally
			QIPWSInfo.Free;
			Open1.Enabled := true;
		end;
	end;
end;

procedure TfmQuickIP.FormShow(Sender: TObject);
begin
	QIPTimer.Interval := 250;				// 1/4 di secondo
	QIPTimer.Enabled := true;
end;

procedure TfmQuickIP.Open1Click(Sender: TObject);
begin
	IconaDblClick(Sender);
end;

procedure TfmQuickIP.About1Click(Sender: TObject);
begin
	Application.CreateForm(TfmAbout,fmAbout);
	try
		fmAbout.ShowModal;
	finally
		fmAbout.Free;
	end;
end;

procedure TfmQuickIP.QIPAniTimerTimer(Sender: TObject);
begin
	if not AniRunning then
	begin
		AniRunning := true;
		ImageList1.GetIcon(Cur,Icona.Picture);
		Inc(Cur);
		if Cur > 15 then Cur := 0;
		Icona.Show;
		AniRunning := false;
	end;
end;

end.
