unit FConfig;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	ComCtrls, StdCtrls, ExtCtrls, Registry;

type
	TfmConfig = class(TForm)
    Page: TPageControl;
    Connection: TTabSheet;
    About: TTabSheet;
    Panel1: TPanel;
    cxDialup: TCheckBox;
    cxLAN: TCheckBox;
    Memo1: TMemo;
    Memo2: TMemo;
    Image3: TImage;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Memo: TMemo;
    Bevel2: TBevel;
    cxAnim: TCheckBox;
		procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure cxDialupClick(Sender: TObject);
    procedure cxLANClick(Sender: TObject);
    procedure AboutMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure MemoMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Image3MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Label11MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Label12MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Label13MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure cxAnimClick(Sender: TObject);
  private
		{ Private declarations }
	public
    { Public declarations }
  end;

var
	fmConfig: TfmConfig;

implementation

uses FMain, FHint, FWSInfo;

{$R *.DFM}

procedure TfmConfig.FormClose(Sender: TObject; var Action: TCloseAction);
var Reg: TRegistry;
begin
	Reg := TRegistry.Create;
	try
		with Reg do
		begin
			RootKey := HKEY_CURRENT_USER;
			if OpenKey('\Software\Caldani\QuickIP',true) then
			begin
				try
					if (cxDialup.Checked) then
					begin
						IsLan := false;
						QIPWSInfo.Config.Caption := 'Configured as:  Dialup connection';
					end;
					if (cxLAN.Checked) then
					begin
						IsLan := true;
						QIPWSInfo.Config.Caption := 'Configured as:  LAN connection';
					end;
					WriteBool('Conn',IsLan);
					WriteBool('Anim',fmQuickIP.Animated);
				except
					;
				end;
				CloseKey;
			end;
		end;
	finally
		Reg.Free;
	end;
	fmHintIP.Free;
	Action := caFree;
end;

procedure TfmConfig.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	CanClose := true;
end;

procedure TfmConfig.FormCreate(Sender: TObject);
begin
	if IsLan then
	begin
		cxDialup.Checked := false;
		cxLAN.Checked := true;
	end else
	begin
		cxDialup.Checked := true;
		cxLAN.Checked := false;
	end;
	if fmQuickIP.Animated then
		cxAnim.Checked := true
	else
		cxAnim.Checked := false;
	Application.CreateForm(TfmHintIP,fmHintIP);
	Label12.Caption := 'Version '+VERSIONE;
end;

procedure TfmConfig.cxDialupClick(Sender: TObject);
begin
	if cxDialup.Checked then
		cxLAN.Checked := false;
end;

procedure TfmConfig.cxLANClick(Sender: TObject);
begin
	if cxLAN.Checked then
		cxDialup.Checked := false;
end;

procedure TfmConfig.AboutMouseMove(Sender: TObject; Shift: TShiftState; X,
	Y: Integer);
begin
	if (fmHintIP.Visible) then
		fmHintIP.Hide;
end;

procedure TfmConfig.MemoMouseMove(Sender: TObject; Shift: TShiftState; X,
	Y: Integer);
begin
	AboutMouseMove(Sender,Shift,X,Y);
end;

procedure TfmConfig.Image3MouseMove(Sender: TObject; Shift: TShiftState; X,
	Y: Integer);
begin
	AboutMouseMove(Sender,Shift,X,Y);
end;

procedure TfmConfig.Label11MouseMove(Sender: TObject; Shift: TShiftState;
	X, Y: Integer);
begin
	AboutMouseMove(Sender,Shift,X,Y);
end;

procedure TfmConfig.Label12MouseMove(Sender: TObject; Shift: TShiftState;
	X, Y: Integer);
begin
	AboutMouseMove(Sender,Shift,X,Y);
end;

procedure TfmConfig.Label13MouseMove(Sender: TObject; Shift: TShiftState;
	X, Y: Integer);
var T,P: TPoint;
begin
	T.X := X;
	T.Y := Y;
	P := ClientToScreen(T);
	fmHintIP.Top := P.Y-40;
	fmHintIP.Left := P.X+20;
	fmHintIP.Show;
end;

procedure TfmConfig.cxAnimClick(Sender: TObject);
begin
	if cxAnim.Checked then
		fmQuickIP.Animated := true
	else
		fmQuickIP.Animated := false;
end;

end.
