unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, StdCtrls, Spin, Mask, TabNotBk, 
  ComCtrls, DWSock32;

type
  TMainForm = class(TForm)
    Notebook: TTabbedNotebook;
    GroupBox1: TGroupBox;
    SrvName: TEdit;
    Label1: TLabel;
    TimeOut: TSpinEdit;
    Label2: TLabel;
    UserEdit: TEdit;
    Label3: TLabel;
    PswEdit: TEdit;
    Label4: TLabel;
    NewPswEdit: TEdit;
    Memo1: TMemo;
    ConnectBtn: TSpeedButton;
    Cln: TClientSocket;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    ServicePort: TEdit;
    procedure UserEditChange(Sender: TObject);
    procedure ConnectBtnClick(Sender: TObject);
    procedure ClnConnect(Sender: TObject; Socket: TSocketBase);
    procedure ClnInfo(Sender: TObject; icode: TSockInfo; Socket: TSocketBase);
    procedure ClnDisconnect(Sender: TObject; Socket: TSocketBase);
    procedure ClnRead(Sender: TObject; Socket: TSocketBase);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ClnWrite(Sender: TObject; Socket: TSocketBase);
    procedure ClnTimeOut(Sender: TObject; Socket: TSocketBase);
    procedure NotebookClick(Sender: TObject);
    procedure UserEditKeyPress(Sender: TObject; var Key: Char);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    SendLine,
    RecLine: string;
    Answers: TStringList;
    AnswCnt: integer;
  public
    procedure reset(Socket: TSocketBase; const msg: string);
    procedure ReadIni;
    procedure WriteIni;
  end;

var
  MainForm: TMainForm;

implementation
uses PSUtils, WSAPI, Registry;

{$R *.DFM}

procedure TMainForm.UserEditChange(Sender: TObject);
var OK: boolean;
begin
   OK := (length(UserEdit.Text) > 0) and (length(PswEdit.Text) > 0) and
      (length(NewPswEdit.Text) > 0) and
      (length(Srvname.Text) > 0) and (length(ServicePort.Text) > 0);
   if ConnectBtn.Enabled <> OK then
     ConnectBtn.Enabled := OK;
end;

procedure TMainForm.ConnectBtnClick(Sender: TObject);
begin
   if not ConnectBtn.Down then begin {disconnect}
       Reset(Cln.Conn, 'Interrupted by user.');
       exit
   end;
   Cursor := crHourGlass;
   Answers.Clear;
   with Answers do begin
      Add('user '+ UserEdit.Text +^M^J);
      Add('pass '+ PswEdit.Text +^M^J);
      Add('newpass '+NewPswEdit.Text +^M^J);
      Add('quit'^M^J);
   end;
   AnswCnt := 0;
   Cln.Address := SrvName.Text;
   Cln.Port := ServicePort.Text;
   Cln.TimeOut := TimeOut.Value;
   try
     Cln.Open(TStreamSocket);
   except
     on E:ESockError do begin
       ConnectBtn.Down := false;
       Cursor := crDefault;
       Memo1.Lines.Add( E.Message);
       MessageBeep( MB_ICONHAND);
       exit
     end
   end;
   Memo1.Lines.Clear
end;

procedure TMainForm.ClnConnect(Sender: TObject; Socket: TSocketBase);
begin
   Cursor := crDefault;
   try
     Memo1.Lines.Add('Connected to ' + Socket.RemoteAddress);
   except
    on E:ESockError do
    begin
      Reset(Socket, 'Connection closed by host. '+E.Message);
    end;
  end

end;

procedure TMainForm.ClnInfo(Sender: TObject; icode: TSockInfo; Socket: TSocketBase);
begin
  case icode of
    siLookup : Memo1.Lines.Add('Looking up host ' + cln.Address);
    siConnect : Memo1.Lines.Add('Connecting ' + cln.Address);
  end;
end;

procedure TMainForm.ClnDisconnect(Sender: TObject; Socket: TSocketBase);
begin
  reset(Socket, '');
end;

procedure TMainForm.ClnRead(Sender: TObject; Socket: TSocketBase);
var s: string;
begin
  try
   s := TStreamSocket(Socket).Text;
   if CheckCRLF(s) then begin                 {check if line complete}
     RecLine := RecLine +s;
     Memo1.Lines.Add( RecLine);               {show received line}
     if RecLine[1] = '2' then begin           {if success}
        if AnswCnt >= Answers.Count then begin    {end of conversation}
           reset( socket, 'Connection closed.');
           ConnectBtn.Down := false;
           MessageDlg( 'OK. Password changed.', mtInformation, [mbOK], 0);
        end
        else begin
           SendLine := Answers[AnswCnt];      {reply next}
           TStreamSocket(Socket).Text := SendLine;
           Memo1.Lines.Add( copy2( SendLine, 1, Socket.BytesSent)); {show sent part of reply}
           delete( SendLine, 1, Socket.BytesSent);  {keep the unsent part}
           inc(AnswCnt);
        end
     end;
     RecLine := '';
   end
   else RecLine := RecLine +s;
  except
   on E:ESockError do begin
      ConnectBtn.Down := false;
      Cursor := crDefault;
      Memo1.Lines.Add( E.Message);
      MessageBeep( MB_ICONHAND);
   end
  end
end;

procedure TMainForm.ClnWrite(Sender: TObject; Socket: TSocketBase);
begin
   if length(SendLine) > 0 then begin   {reply still waiting to be sent}
     TStreamSocket(Socket).Text := SendLine;
     with Memo1.Lines do if Count > 0 then    {add to display sent characters}
       Strings[pred(Count)] := Strings[pred(Count)] +
                               copy2( SendLine, 1, Socket.BytesSent);
     delete( SendLine, 1, Socket.BytesSent);   {clear sent characters}
   end
end;

procedure TMainForm.ClnTimeOut(Sender: TObject; Socket: TSocketBase);
begin
   reset( socket, 'Connect time out.');
end;

procedure TMainForm.reset(Socket: TSocketBase; const msg: string);
begin
  Cursor := crDefault;
  Socket.Close;
  Memo1.Lines.Add( msg);
  Memo1.Lines.Add('Disconnected');
  ConnectBtn.Down := false;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
   Answers := TStringList.Create;
   RecLine := '';
   SendLine := '';
   ReadIni;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
   Answers.Free
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   WriteIni
end;

procedure TMainForm.NotebookClick(Sender: TObject);
begin
   case Notebook.PageIndex of
        0 :  begin
               if length(UserEdit.Text) = 0 then ActiveControl := UserEdit
               else if length(PswEdit.Text) = 0 then ActiveControl := PswEdit
                    else ActiveControl := NewPswEdit;
             end;
        1 :  ActiveControl := SrvName
   end
end;

procedure TMainForm.UserEditKeyPress(Sender: TObject; var Key: Char);
begin
   if (Key = ^M) and ConnectBtn.Enabled then begin
      ConnectBtn.Down := true;
      ConnectBtnClick(self)
   end;
end;

procedure TMainForm.ReadIni;
var Ini: TRegIniFile;
begin
   Ini := TRegIniFile.Create( 'Software\Datalog\Eudora/NUPOP Password change');
   with Ini do begin
      SrvName.Text := ReadString('Default', 'ServerName', '');
      ServicePort.Text := ReadString('Default', 'ServiceName', 'epass');
      UserEdit.Text := ReadString('Default','UserName', '');
   end;
   Ini.Free
end;

procedure TMainForm.WriteIni;
var Ini: TRegIniFile;
begin
   Ini := TRegIniFile.Create( 'Software\Datalog\Eudora/NUPOP Password change');
   with Ini do begin
     try
      WriteString('Default', 'ServerName', SrvName.Text);
      WriteString('Default', 'ServiceName', ServicePort.Text);
      WriteString('Default', 'UserName', UserEdit.Text);
     except {dummy} end
   end;
   Ini.Free
end;

end.
