unit psiStatusBar;

{================================================================}
{ TpsiStatusBar - Version 1.1                                    }
{================================================================}
{                                                                }
{ 1.1 Changes                                                    }
{ ------------------------------------------------               }
{ *** AM/PM not displayed properly:                              }
{     Typo!!!, TimeStr declared as string[10],                   }
{       should've been string[11].                               }
{     Time display appears to be correct now.                    }
{ *** Created procedure ShowDateTime:                            }
{     Called when Date/Time display is updated                   }
{ *** Adjusted panel widths:                                     }
{     To better accomodate months 10, 11, & 12                   }
{ *** Changed "Hint" handling:                                   }
{     Changed ShowHint to True.                                  }
{     Autofill Hint with panels.items[0].text (in timer event).  }
{     If form has been resized and "text" is not visible,        }
{       Hint allows user to see the "text".                      }
{                                                                }
{================================================================}
{                                                                }
{ DELPHI 2.0 COMPONENT                                           }
{ FREEWARE                                                       }
{                                                                }
{ TpsiStatusBar creates a "Win95" status bar                     }
{    at the bottom of your form that automatically processes     }
{    Date/Time (clock) updating.                                 }
{                                                                }
{ !!Make sure to read the CONTROL "NAME" section that follows.!! }
{                                                                }
{ TpsiStatusBar consists of 2 panels:                            }
{    Panels.Items[0] - we use this panel for field "captions"    }
{       The following command would display "Status Text"        }
{            StatusBar.panels.items[0].text :='Status Text';     }
{    Panels.Items[1] - is for date & time (automatically filled) }
{                                                                }
{ There's no need to add a timer to fill the Date/Time,          }
{    Timer processing is handled within the component.           }
{                                                                }
{ The timer "interval" is hardcoded to 1 second                  }
{    (1000 ms in procedure UpdateTimer)                          }
{ If there's another function you need to perform every second,  }
{    it can be added to this control's "OnTimer" event.          }
{                                                                }
{----------------------------------------------------------------}
{                                                                }
{ If it's helpful in some way, GREAT.                            }
{ As you'd expect, USE TpsiStatusBar AT YOUR OWN RISK.           }
{ If you use it, please send any comments.                       }
{ If you improve it, please let me know.                         }
{                                                                }
{ Enjoy it,                                                      }
{ Jim Albert                                                     }
{   PIN Systems, Inc.                                            }
{     Compuserve -- 102426,2527                                  }
{     Internet   -- PINSystems@mailhost.net                      }
{                                                                }
{================================================================}

{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
{ CONTROL "NAME"                                                 }
{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
{                                                                }
{ For compliance with other psi controls;                        }
{    we set the name to "StatusBar", in the Resize event.        }
{                                                                }
{ If you don't want the component automatically named            }
{    "StatusBar", search for, and comment out the following      }
{    line.                                                       }
{        if Name <>'StatusBar' then Name :='StatusBar';          }
{                                                                }
{!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, psiMain;

{var}

type
  TTimerID  =integer;

type
  TpsiStatusBar = class(TStatusBar)
  private
    FOnResize: TNotifyEvent;
    FOnTimer: TNotifyEvent;
    FTimerID: integer;
    FWindowHandle: HWND;
    procedure WMSize(var Message: TWMSize); message WM_SIZE;
    procedure SetOnTimer(Value: TNotifyEvent);
    procedure ShowDateTime;
    procedure UpdateTimer;
    procedure WndProc(var Msg: TMessage);
    property  TimerID: TTimerID read FTimerID write FTimerID;

  protected
    procedure Timer; dynamic;

  public
    constructor Create(AOwner: TComponent); override;
     destructor Destroy; override;

  published
    property Align;
    property Cursor;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font;
    property Height;
    property HelpContext;
    property Hint;
    property Left;
    property Name;
    property Panels;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property SimplePanel;
    property SimpleText;
    property SizeGrip;
    property Tag;
    property Top;
    property Visible;
    property Width;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnDrawPanel;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnResize: TNotifyEvent read FOnResize write FOnResize;
    property OnStartDrag;
    property OnTimer: TNotifyEvent read FOnTimer write SetOnTimer;
  end;

procedure Register;

implementation

constructor TpsiStatusBar.Create(AOwner: TComponent);
var
  TimeStr: string[11];
begin
  inherited Create(AOwner);
  Align :=alBottom;
  Cursor :=crDefault;
  DragCursor :=crDrag;
  DragMode :=dmManual;
  Enabled :=True;
  Font.Name := 'MS Sans Serif';
  Font.Color := clBlack;
  Font.Height := -11;
  Font.Size := 8;
  Font.Style := [];
  FWindowHandle := AllocateHWnd(WndProc);
  Height :=19;
  HelpContext :=0;
  Hint :='';
  panels.add;
  panels.items[0].text :='';
  panels.items[0].width :=width-126;
  panels.items[0].style :=psText;
  panels.items[0].bevel :=pbLowered;
  panels.items[0].alignment :=taLeftJustify;
  panels.add;
  panels.items[1].text :='';
  panels.items[1].width :=width-panels.items[0].width;
  panels.items[1].style :=psText;
  panels.items[1].bevel :=pbLowered;
  panels.items[1].alignment :=taLeftJustify;
  ParentFont :=False;
  ParentShowHint :=True;
  ShowHint :=True;
  SimplePanel :=False;
  SimpleText :='';
  SizeGrip :=True;
  Tag :=0;
  Visible :=True;
  UpdateTimer;
    { Don't wait 1 second to display the time }
  ShowDateTime;
end;


destructor TpsiStatusBar.Destroy;
begin
  if TimerID >0 then KillTimer(FWindowHandle, 1);
  DeallocateHWnd(FWindowHandle);
  inherited Destroy;
end;


procedure Register;
begin
  RegisterComponents('psi', [TpsiStatusBar]);
end;


{ Resize event }
procedure TpsiStatusBar.WMSize(var Message: TWMSize);
begin
  if Assigned(FOnResize) then FOnResize(Self);
  if GetParentForm(self).width >125 then
    panels.items[0].width :=GetParentForm(self).width-126
  else
    panels.items[0].width :=0;
    {====================================================}
    { A resize is called after the object is created.    }
    { If desired, the name can be set here.              }
    {                                                    }
    { For compliance with other psi components,          }
    {    we set the name to "StatusBar".                 }
    {                                                    }
    {----------------------------------------------------}
    {                                                    }
    { If you don't want it automatically named           }
    { "StatusBar", comment out the following line        }
    {                                                    }
    {====================================================}
  if Name <>'StatusBar' then Name :='StatusBar';
end;


{ Timer}
procedure TpsiStatusBar.UpdateTimer;
begin
  if TimerID >0 then KillTimer(FWindowHandle, 1);
  TimerID :=SetTimer(FWindowHandle, 1, 1000, nil)
end;


procedure TpsiStatusBar.WndProc(var Msg: TMessage);
begin
  with Msg do
    if Msg = WM_TIMER then
      try
        Timer;
      except
        Application.HandleException(Self);
      end
    else
      Result := DefWindowProc(FWindowHandle, Msg, wParam, lParam);
end;


procedure TpsiStatusBar.SetOnTimer(Value: TNotifyEvent);
begin
  FOnTimer := Value;
  UpdateTimer;
end;


procedure TpsiStatusBar.Timer;
begin
  ShowDateTime;
  Hint :=panels.items[0].text;
  if Assigned(FOnTimer) then FOnTimer(Self);
end;


procedure TpsiStatusBar.ShowDateTime;
var
  TimeStr: string[11];
begin
  TimeStr :=TrimStr(TimeToStr(Time));
  panels.items[1].text :=DateToStr(Date)+'  '+Copy(TimeStr,1,StrAt(TimeStr,':',2)-1)+' '+Lowercase(StrRight(TimeStr,2));
end;

end.
