UNIT WinTasks;

INTERFACE

USES   Classes, Toolhelp, WinTypes;

TYPE   TTaskInfo= CLASS(TObject)
       PRIVATE
         TaskEntry : TTaskEntry;
         FUNCTION GetName: STRING;
         FUNCTION GetInstance: THandle;
         FUNCTION GetExePath: STRING;
         FUNCTION GetIsOwn: BOOLEAN;
       PUBLIC
         CONSTRUCTOR Create(CONST Entry: TTaskEntry);
         PROPERTY Name: STRING READ GetName;
         PROPERTY Instance: THandle READ GetInstance;
         PROPERTY ExePath: STRING READ GetExePath;
         PROPERTY IsOwn: BOOLEAN READ GetIsOwn;
         { wahr, wenn Eintrag eigene Task ist }
       END;

TYPE   TTasks= CLASS(TObject)
       PRIVATE
         TaskList: TStringList;
         PROCEDURE TaskListFill;
         FUNCTION GetTask(Index: INTEGER): TTaskInfo;
         FUNCTION GetCount: INTEGER;
       PUBLIC
         CONSTRUCTOR Create;
         DESTRUCTOR Destroy; OVERRIDE;
         PROPERTY Task[INDEX: INTEGER]: TTaskInfo READ GetTask; DEFAULT;
         PROPERTY Count: INTEGER READ GetCount;
       END;

IMPLEMENTATION

USES SysUtils;


{------------------------------------------------------------------------------}
CONSTRUCTOR TTaskInfo.Create(CONST Entry: TTaskEntry);
BEGIN
       INHERITED Create;
       TaskEntry := Entry;
END{ Create };

{------------------------------------------------------------------------------}
FUNCTION TTaskInfo.GetName: STRING;
BEGIN
       GetName := StrPas(TaskEntry.szModule);
END{ GetName };

{------------------------------------------------------------------------------}
FUNCTION TTaskInfo.GetInstance: THandle;
BEGIN
       GetInstance:= TaskEntry.hInst;
END{ GetInstance };

{------------------------------------------------------------------------------}
FUNCTION TTaskInfo.GetExePath: STRING;
VAR    Module : TModuleEntry;
       WinStat: THandle;
BEGIN
       Module.dwSize := SIZEOF(Module);
       WinStat := ModuleFindHandle(ADDR(Module),TaskEntry.hModule);
       IF (WinStat<>0) THEN BEGIN
         GetExePath := StrPas(Module.szExePath);
       END ELSE BEGIN
         GetExePath := 'error';
       END;
END{ GetExePath };

{------------------------------------------------------------------------------}
FUNCTION TTaskInfo.GetIsOwn: BOOLEAN;
BEGIN
       GetIsOwn := (TaskEntry.hInst=SYSTEM.hInstance);
END{ GetIsOwn };

{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
CONSTRUCTOR TTasks.Create;
BEGIN
       INHERITED Create;
       TaskList := TStringList.Create;
       TaskListFill;
END{ Create };

{------------------------------------------------------------------------------}
DESTRUCTOR TTasks.Destroy;
BEGIN
       TaskList.Free;
       INHERITED Destroy;
END{ Destroy };

{------------------------------------------------------------------------------}
PROCEDURE TTasks.TaskListFill;
VAR    TaskEntry: TTaskEntry;
       WinStat  : Bool;
BEGIN
       TaskEntry.dwSize := SIZEOF(TaskEntry);
       WinStat := TaskFirst(ADDR(TaskEntry));
       WHILE (WinStat) DO BEGIN
         TaskList.AddObject(StrPas(TaskEntry.szModule),
                            TTaskInfo.Create(TaskEntry));
         WinStat := TaskNext(ADDR(TaskEntry));
       END{while};
END{ TaskListFill };

{------------------------------------------------------------------------------}
FUNCTION TTasks.GetTask(Index: INTEGER): TTaskInfo;
BEGIN
       GetTask := TTaskInfo(TaskList.Objects[Index]);
END{ GetTask };

{------------------------------------------------------------------------------}
FUNCTION TTasks.GetCount: INTEGER;
BEGIN
       GetCount := TaskList.Count;
END{ GetCount };

{------------------------------------------------------------------------------}

END{ WinTasks }.
