UNIT WinTasks;
{
  Classes for Process and Modulists
  uses psapi.pas and psapi.dll

  Created: 17. May 1999 by Thomas Gloeckler
}
INTERFACE

USES Classes, Windows, PSAPI;

TYPE   TProcessInfo = CLASS(TObject)
       PRIVATE
         fID      : DWORD;
         fName    : String;
         fFullPath: String;
       PUBLIC
         CONSTRUCTOR Create(ProcessID : DWORD);
         PROPERTY ID: DWORD READ FID;
         PROPERTY Name: STRING READ FName;
         PROPERTY FullPath: STRING READ FFullPath;
       END;

TYPE   TProcesses = CLASS(TObject)
       PRIVATE
         FProcessList: TList;
         PROCEDURE ListFill;
         FUNCTION GetProcess(Index: INTEGER): TProcessInfo;
         FUNCTION GetCount: INTEGER;
       PUBLIC
         CONSTRUCTOR Create;
         DESTRUCTOR Destroy; OVERRIDE;
         PROPERTY Process[INDEX: INTEGER]: TProcessInfo READ GetProcess; DEFAULT;
         PROPERTY Count: INTEGER READ GetCount;
       END;

TYPE   TModuleInfo = CLASS(TObject)
       PRIVATE
         fName     : String;
         fFullPath : String;
         fModInfo  : PSAPI.TMODULEINFO;
         FUNCTION GetSizeOfImage: DWORD;
       PUBLIC
         CONSTRUCTOR Create(hProcess,hModule: THandle);
         PROPERTY Name: STRING READ FName;
         PROPERTY FullPath: STRING READ FFullPath;
         PROPERTY SizeOfImage: DWORD READ GetSizeOfImage;

       END;

TYPE   TModules = CLASS(TObject)
       PRIVATE
         fProcessID: DWORD;                                         { owner ID }
         fModuleList: TList;
         PROCEDURE ListFill;
         FUNCTION GetModule(Index: INTEGER): TModuleInfo;
         FUNCTION GetCount: INTEGER;
       PUBLIC
         CONSTRUCTOR Create(ProcessID: DWORD);
         DESTRUCTOR Destroy; OVERRIDE;
         PROPERTY Module[INDEX: INTEGER]: TModuleInfo READ GetModule; DEFAULT;
         PROPERTY Count: INTEGER READ GetCount;
       END;


IMPLEMENTATION

USES SysUtils;


{------------------------------------------------------------------------------}
{PPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP}
{------------------------------------------------------------------------------}
CONSTRUCTOR TProcessInfo.Create(ProcessID: DWORD);
VAR hProcess: THandle;
    hMod    : hModule;
    cbNeeded: DWORD;
    szProcessName: ARRAY[0..1024] OF CHAR;
BEGIN
  INHERITED Create;
  FID := ProcessID;

  hProcess := OpenProcess(PROCESS_QUERY_INFORMATION OR PROCESS_VM_READ,
                          FALSE, processID );

  { Get the process name. }

  szProcessName := 'unknown';
  IF (hProcess<>0) THEN BEGIN
    IF(EnumProcessModules(hProcess,hMod,sizeof(hMod),cbNeeded)) THEN BEGIN
       GetModuleBaseName(hProcess,hMod,szProcessName,sizeof(szProcessName));
       fName := StrPas(szProcessName);
       GetModuleFileNameEx(hProcess,hMod,szProcessName,sizeof(szProcessName));
       fFullPath := StrPas(szProcessName);
    END;
  END;
  CloseHandle(hProcess);

END{ Create };

{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
CONSTRUCTOR TProcesses.Create;
BEGIN
  INHERITED Create;
  FProcessList := TList.Create;
  ListFill;
END{ Create };

{------------------------------------------------------------------------------}
DESTRUCTOR TProcesses.Destroy;
VAR i: LongInt;
BEGIN
  FOR i:=0 TO FProcessList.Count-1 DO BEGIN
    TProcessInfo(FProcessList[i]).Free;
  END{for};
  FProcessList.Free;
  INHERITED Destroy;
END{ Destroy };

{------------------------------------------------------------------------------}
PROCEDURE TProcesses.ListFill;
CONST MaxProcesses = 1024;
VAR IDBuffer: ARRAY[0..MaxProcesses] OF DWORD;
    Res     : BOOL;
    cbNeeded: DWORD;
    i       : INTEGER;
BEGIN
  Res := EnumProcesses(IDBuffer,SizeOf(IDBuffer),cbNeeded);
  IF (Res) THEN BEGIN
    FOR i:=0 TO (cbNeeded DIV SizeOf(DWORD))-1 DO BEGIN
      FProcessList.Add(TProcessInfo.Create(IDBuffer[i]));
    END;
  END ELSE BEGIN
    { GetLastError - error handling }
  END;
END{ ProcessListFill };

{------------------------------------------------------------------------------}
FUNCTION TProcesses.GetProcess(Index: INTEGER): TProcessInfo;
BEGIN
  Result := TProcessInfo(FProcessList[Index]);
END{ GetProcess };

{------------------------------------------------------------------------------}
FUNCTION TProcesses.GetCount: INTEGER;
BEGIN
  Result := FProcessList.Count;
END{ GetCount };

{------------------------------------------------------------------------------}
{MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM}
{------------------------------------------------------------------------------}
CONSTRUCTOR TModuleInfo.Create(hProcess,hModule: THandle);
VAR szModName: ARRAY[0..1024] OF CHAR;
    MInfo    : PSAPI.TMODULEINFO;
BEGIN
  INHERITED Create;
  GetModuleBaseName(hProcess,hModule,szModName,SizeOf(szModName));
  fName := StrPas(szModName);
  GetModuleFileNameEx(hProcess,hModule,szModName,SizeOf(szModName));
  fFullPath := StrPas(szModName);
  GetModuleInformation(hProcess,hModule,MInfo,SizeOf(TMODULEINFO));
  fModInfo := MInfo;
END{ Create };

{------------------------------------------------------------------------------}
FUNCTION TModuleInfo.GetSizeOfImage: DWORD;
BEGIN
  Result := fModInfo.SizeOfImage;
END{ GetZizeOfImage };

{------------------------------------------------------------------------------}
CONSTRUCTOR TModules.Create(ProcessID: DWORD);
BEGIN
  INHERITED Create;
  fProcessID := ProcessID;
  FModuleList := TList.Create;
  ListFill;
END{ Create };

{------------------------------------------------------------------------------}
DESTRUCTOR TModules.Destroy;
VAR i: LongInt;
BEGIN
  FOR i:=0 TO FModuleList.Count-1 DO BEGIN
    TModuleInfo(FModuleList[i]).Free;
  END{for};
  FModuleList.Free;
  INHERITED Destroy;
END{ Destroy };

{------------------------------------------------------------------------------}
PROCEDURE TModules.ListFill;
CONST MaxModules = 1024;
VAR Buffer  : ARRAY[0..MaxModules] OF THandle;
    Res     : BOOL;
    cbNeeded: DWORD;
    i       : INTEGER;
    hProcess: THandle;
BEGIN
  hProcess := OpenProcess(PROCESS_QUERY_INFORMATION OR PROCESS_VM_READ,
                          FALSE,FProcessID);

  IF (hProcess<>0) THEN BEGIN
    Res := EnumProcessModules(hProcess, Buffer, SizeOf(Buffer),cbNeeded);
    IF (Res) THEN BEGIN
      FOR i:=0 TO (cbNeeded DIV SizeOf(THandle))-1 DO BEGIN
        FModuleList.Add(TModuleInfo.Create(hProcess,Buffer[i]));
      END;
    END ELSE BEGIN
      { GetLastError - error handling }
    END;
    CloseHandle(hProcess);
  END ELSE BEGIN
    { GetLastError - error handling }
  END;
END{ ListFill };

{------------------------------------------------------------------------------}
FUNCTION TModules.GetModule(Index: INTEGER): TModuleInfo;
BEGIN
  Result := TModuleInfo(FModuleList[Index]);
END{ GetModule };

{------------------------------------------------------------------------------}
FUNCTION TModules.GetCount: INTEGER;
BEGIN
  Result := FModuleList.Count;
END{ GetCount };
{------------------------------------------------------------------------------}


END{ WinProcesses }.
