unit PsApi;
{
  Delphi-Interface for the PSAPI.DLL

  Created: 17. May 1999 by Thomas Gloeckler
}
interface

uses Windows;

type LPVOID = pointer;

(*
typedef struct _MODULEINFO {
   LPVOID lpBaseOfDll;
   DWORD SizeOfImage;
   LPVOID EntryPoint;} MODULEINFO, *LPMODULEINFO;
*)
type TMODULEINFO = record
       lpBaseOfDLL : LPVOID;
       SizeOfImage : DWORD;
       EntryPoint : LPVOID;
     end;

(*
typedef struct _PROCESS_MEMORY_COUNTERS {
    DWORD cb;
    DWORD PageFaultCount;
    DWORD PeakWorkingSetSize;
    DWORD WorkingSetSize;
    DWORD QuotaPeakPagedPoolUsage;
    DWORD QuotaPagedPoolUsage;
    DWORD QuotaPeakNonPagedPoolUsage;
    DWORD QuotaNonPagedPoolUsage;
    DWORD PagefileUsage;
    DWORD PeakPagefileUsage;
} PROCESS_MEMORY_COUNTERS;
typedef PROCESS_MEMORY_COUNTERS *PPROCESS_MEMORY_COUNTERS;
*)
type TPROCESS_MEMORY_COUNTERS = record
       cb : LongInt;
       PageFaultCount : DWORD;
       PeakWorkingSetSize : DWORD;
       WorkingSetSize : DWORD;
       QuotaPeakPagedPoolUsage : DWORD;
       QuotaPagedPoolUsage : DWORD;
       QuotaPeakNonPagedPoolUsage : DWORD;
       QuotaNonPagedPoolUsage : DWORD;
       PagefileUsage : DWORD;
       PeakPagefileUsage : DWORD;
     end;

(*
typedef struct _PSAPI_WS_WATCH_INFORMATION {
    LPVOID FaultingPc;
    LPVOID FaultingVa;
} PSAPI_WS_WATCH_INFORMATION, *PPSAPI_WS_WATCH_INFORMATION;
*)
type TPSAPI_WS_WATCH_INFORMATION = record
       FaultingPc : LPVOID;
       FaultingVa : LPVOID;
     end;

(*
BOOL EmptyWorkingSet(  HANDLE hProcess  // identifies the process);
*)
function EmptyWorkingSet(hProcess: THandle): BOOL; stdcall;

(*
BOOL EnumDeviceDrivers(
  LPVOID *lpImageBase,  // array to receive the load addresses
  DWORD cb,             // size of the array
  LPDWORD lpcbNeeded    // receives the number of bytes returned);
*)
function EnumDeviceDrivers(lpImageBase : LPVOID; cb : DWORD; VAR cbNeeded : DWORD) : BOOL; stdcall;

(*
BOOL EnumProcesses(
  DWORD * lpidProcess,  // array to receive the process identifiers
  DWORD cb,             // size of the array
  DWORD * cbNeeded      // receives the number of bytes returned);
*)

function EnumProcesses(VAR Processes; cb : DWORD; VAR cbNeeded : DWORD): BOOL; stdcall;

(*
BOOL EnumProcessModules(
  HANDLE hProcess,      // handle to the process
  HMODULE * lphModule,  // array to receive the module handles
  DWORD cb,             // size of the array
  LPDWORD lpcbNeeded    // receives the number of bytes returned);
*)

function EnumProcessModules(hProcess : THandle; VAR Modules;
                            cb : DWORD; VAR cbNeeded : DWORD): BOOL; stdcall;

(*
DWORD GetDeviceDriverBaseName(
  LPVOID ImageBase,  // the load address of the driver
  LPTSTR lpBaseName, // receives the base name of the driver
  DWORD nSize        // size of the buffer);
*)

function GetDeviceDriverBaseName(ImageBase : DWORD; lpBaseName : pchar;
                                 nSize : DWORD): DWORD; stdcall;

(*
DWORD GetDeviceDriverFileName(
  LPVOID ImageBase,  // the load address of the driver
  LPTSTR lpFilename, // buffer that receives the path
  DWORD nSize        // size of the buffer);
*)
function GetDeviceDriverFileName(ImageBase : DWORD; lpFileName : pchar;
                                 nSize : DWORD) : DWORD; stdcall;

(*
DWORD GetMappedFileName(
  HANDLE hProcess,    // handle to the process
  LPVOID lpv,         // the address to verify
  LPTSTR lpFilename,  // buffer that receives the filename
  DWORD nSize         // size of the buffer);
*)
function GetMappedFileName(hProcess : THandle; lpv : LPVOID;
                           lpFileName : pchar; nSize : DWORD): DWORD; stdcall;

(*
DWORD GetModuleBaseName(
  HANDLE hProcess,    // handle to the process
  HMODULE hModule,    // handle to the module
  LPTSTR lpBaseName,  // buffer that receives the base name
  DWORD nSize         // size of the buffer);
*)
function GetModuleBaseName(hProcess : THandle; hModule : THandle;
                           lpFileName : pchar;
                           nSize : DWORD): DWORD; stdcall;

(*
DWORD GetModuleFileNameEx(
  HANDLE hProcess,    // handle to the process
  HMODULE hModule,    // handle to the module
  LPTSTR lpFilename,  // buffer that receives the path
  DWORD nSize         // size of the buffer);
*)
function GetModuleFileNameEx(hProcess : THandle; hModule : THandle;
                             lpFileName : pchar;
                             nSize : DWORD): DWORD; stdcall;

(*
BOOL GetModuleInformation(
  HANDLE hProcess,         // handle to the process
  HMODULE hModule,         // handle to the module
  LPMODULEINFO lpmodinfo,  // structure that receives information
  DWORD cb                 // size of the structure);
*)
function GetModuleInformation(hProcess : THandle; hModule : THandle;
                              VAR lpmodinfo : TMODULEINFO;
                              cb : DWORD): BOOL; stdcall;

(*
BOOL GetProcessMemoryInfo(
  HANDLE Process,  // handle to the process
  PPROCESS_MEMORY_COUNTERS ppsmemCounters,
                   // structure that receives information
  DWORD cb         // size of the structure);
*)
function GetProcessMemoryInfo(hProcess : THandle;
                              VAR psmemCounters : TPROCESS_MEMORY_COUNTERS;
                              cb : DWORD): BOOL; stdcall;

(*
BOOL GetWsChanges(
  HANDLE hProcess,  // handle to the process
  PPSAPI_WS_WATCH_INFORMATION lpWatchInfo,
                    // structure that receives information
  DWORD cb          // size of the structure);
*)
function GetWsChanges(hProcess : THandle;
                      VAR WatchInfo : TPSAPI_WS_WATCH_INFORMATION;
                      cb : DWORD): BOOL; stdcall;

(*
BOOL InitializeProcessForWsWatch(
  HANDLE hProcess   // handle to the process);
*)
function InitializeProcessForWsWatch(hProcess : THandle): BOOL; stdcall;

(*
BOOL QueryWorkingSet(
  HANDLE hProcess,  // handle to the process
  PVOID pv,         // buffer that receives the information
  DWORD cb          // size of the buffer);
*)
function QueryWorkingSet(hProcess : THandle;VAR pv; cb : DWORD): BOOL; stdcall;

implementation
(*
LIBRARY     PSAPI.DLL

EXPORTS
    EmptyWorkingSet                @1   
    EnumDeviceDrivers              @2   
    EnumProcessModules             @3
    EnumProcesses                  @4   
    GetDeviceDriverBaseNameA       @5   
    GetDeviceDriverBaseNameW       @6   
    GetDeviceDriverFileNameA       @7   
    GetDeviceDriverFileNameW       @8   
    GetMappedFileNameA             @9
    GetMappedFileNameW             @10  
    GetModuleBaseNameA             @11  
    GetModuleBaseNameW             @12
    GetModuleFileNameExA           @13
    GetModuleFileNameExW           @14
    GetModuleInformation           @15
    GetProcessMemoryInfo           @16
    GetWsChanges                   @17
    InitializeProcessForWsWatch    @18
    QueryWorkingSet                @19
*)

function EmptyWorkingSet; external 'psapi.dll' index 1;
function EnumDeviceDrivers; external 'psapi.dll' index 2;
function EnumProcessModules; external 'psapi.dll' index 3;
function EnumProcesses; external 'psapi.dll' index 4;
function GetDeviceDriverBaseName; external 'psapi.dll' index 5;
function GetDeviceDriverFileName; external 'psapi.dll' index 7;
function GetMappedFileName; external 'psapi.dll' index 9;
function GetModuleBaseName; external 'psapi.dll' index 11;
function GetModuleFileNameEx; external 'psapi.dll' index 13;
function GetModuleInformation; external 'psapi.dll' index 15;
function GetProcessMemoryInfo; external 'psapi.dll' index 16;
function GetWsChanges; external 'psapi.dll' index 17;
function InitializeProcessForWsWatch; external 'psapi.dll' index 18;
function QueryWorkingSet; external 'psapi.dll' index 19;

end.
