unit fpview;
{
  Testform for units wintask and psapi
  
  Created: 17. May 1999 by Thomas Gloeckler
}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Menus, StdCtrls, WinTasks, XControl;

type
  TMainForm = class(TForm)
    MainMenu: TMainMenu;
    MnuFile: TMenuItem;
    MnuExit: TMenuItem;
    TabbedListBox: TXTabbedListBox;
    Header: THeader;
    MnuView: TMenuItem;
    MnuModulelist: TMenuItem;
    MnuAbout: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure MnuExitClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure MnuModulelistClick(Sender: TObject);
    procedure MnuAboutClick(Sender: TObject);
  private
    FProcessList: TProcesses;
  end;

var MainForm: TMainForm;

implementation

{$R *.DFM}

USES fabout, fmview;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  FProcessList := TProcesses.Create;
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  FProcessList.Free;
end;

procedure TMainForm.MnuExitClick(Sender: TObject);
begin
  Application.Terminate;
end;

procedure TMainForm.FormShow(Sender: TObject);
var i: LongInt;
begin
  TabbedListBox.ColWidths[0] := 100;
  TabbedListBox.ColWidths[1] := 40;
  TabbedListBox.ColWidths[2] := TabbedListBox.Width - 100 - 40;
  for i:=0 to FProcessList.Count-1 do begin
    with FProcessList[i] do begin
      if (name<>'') then begin
        TabbedListBox.items.AddObject(Name+Tab+IntToStr(ID)+Tab+FullPath,pointer(ID));
      end;
    end{with};
  end{for};
end;

procedure TMainForm.MnuModulelistClick(Sender: TObject);
var Item : longint;
    MForm: TFModuleView;
begin
  item := TabbedListBox.CaretIndex;
  MForm := TFModuleView.Create(Self);
  MForm.ShowModules(DWORD(TabbedListbox.items.objects[item]));
end;

procedure TMainForm.MnuAboutClick(Sender: TObject);
begin
   About.Show;
end;

end.
