unit fmview;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, XControl, WinTasks;

type
  TFModuleView = class(TForm)
    Header: THeader;
    TabbedListBox: TXTabbedListBox;
    Panel: TPanel;
    Button: TButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ButtonClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    fModuleList: TModules;
  public
    procedure ShowModules(ProcessID: DWORD);
  end;


implementation

{$R *.DFM}

procedure TFModuleView.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  FModuleList.Free;
end;

procedure TFModuleView.ShowModules(ProcessID: DWORD);
begin
  FModuleList := TModules.Create(ProcessID);
  show;
end;

procedure TFModuleView.ButtonClick(Sender: TObject);
begin
  Close;
end;

procedure Tfmoduleview.FormShow(Sender: TObject);
var i: LongInt;
begin
  if (FModuleList<>nil) AND (FModuleList.Count>0) then begin
    TabbedListBox.ColWidths[0] := 100;
    TabbedListBox.ColWidths[1] := 100;
    TabbedListBox.ColWidths[2] := TabbedListBox.Width - 100 - 40;
    for i:=0 to FModuleList.Count-1 do begin
      with FModuleList[i] do begin
        if (Name<>'') then begin
          TabbedListBox.items.Add(Name+Tab+IntToStr(SizeOfImage)+Tab+FullPath);
        end;
      end{with};
    end{for};
  end;  
end;

end.
