{********************************************************************
TPROPSCROLLBAR component
for Delphi 2.0 & 3.0
version 1.0

written by Bruno Fierens,
           TMS Software
           copyright _ 1997
           Email : tms@theLinx.com
           Website : http://theLinx.com/tms
           Component page : http://www.ven.be/freestyle/delphi.htm

The source code is given as is. The author is not responsible
for any possible damage done due to the use of this code.
The component can be freely used in any application. The source
code remains property of the author and may not be distributed
freely as such.
********************************************************************}
unit propscrl;

interface

uses
  stdctrls,winprocs,classes;

type

  TPropScrollbar = class(TScrollbar)
  private
   FPageSize:integer;
   procedure SetPageSize(pagesize:integer);
  public
  protected
  published
   property PageSize:integer read FPageSize write SetPageSize;
  end;

procedure Register;


implementation

procedure TPropScrollbar.SetPageSize(pagesize:integer);
var
 scrollinfo:tscrollinfo;
begin
 fPageSize:=pagesize;

 scrollinfo.cbSize:=sizeof(scrollinfo);
 scrollinfo.fMask:=SIF_RANGE;
 getscrollinfo(Handle,SB_CTL,scrollinfo);

 {set vertical page size}
 scrollinfo.cbSize:=sizeof(scrollinfo);
 scrollinfo.fMask:=SIF_PAGE;
 scrollinfo.nPage:=PageSize;

 setscrollinfo(Handle,SB_CTL,scrollinfo,true);
end;

procedure Register;
begin
  RegisterComponents('MyStuff', [TPropScrollBar]);
end;


end.
