unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Progress, StdCtrls, Spin;

type
  TForm1 = class(TForm)
    CheckBox1: TCheckBox;
    SpinEdit1: TSpinEdit;
    procedure CheckBox1Click(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    Progress: TProgressWindow;
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  Progress.Visible := CheckBox1.Checked;
end;

procedure TForm1.SpinEdit1Change(Sender: TObject);
begin
  Progress.Value := SpinEdit1.Value;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Progress := TProgressWindow.Create(Self);
  with Progress do begin
    Font.Name := 'MS Sans Serif';
    Font.Style := [fsBold];
    Font.Color := clWhite;
    Caption := 'Showing progress...';
    Boxes := 20;
  end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  Progress.Free;
end;

end.
