unit ProgWdw;
{
Encapsulates a small modeless, captionless window containing a progress gauge.

by Justin Turberville
email:  JustinT @ cyberjoe.co.za
}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, ComCtrls;

type
  TProgressForm = class(TForm)
    Panel: TPanel;
    Text: TLabel;
    Bar: TProgressBar;
  private
  public
  end;

  TProgressWindow = class(TComponent)
  private
    FProgressForm: TProgressForm;
    FColor:     TColor;
    FCursor:    TCursor;
    FFont:      TFont;
    FHeight:    Integer;
    FHint:      string;
    FLeft:      Integer;
    FMax:       Integer;
    FMin:       Integer;
    FPosition:  TPosition;
    FProgress:  Integer;
    FStayOnTop: Boolean;
    FScaled:    Boolean;
    FStep:      Integer;
    FText:      string;
    FTop:       Integer;
    FWidth:     Integer;
    procedure SetColor(Value: TColor);
    procedure SetCursor(Value: TCursor);
    procedure SetFont(Value: TFont);
    procedure SetHint(Value: string);
    procedure SetProgress(Value: Integer);
    procedure SetText(Value: string);
    function GetVisible: Boolean;
    procedure SetVisible(Value: Boolean);
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Show;
    procedure Hide;
  published
    property Color: TColor read FColor write SetColor;
    property Cursor: TCursor read FCursor write SetCursor
      default crHourglass;
    property Font: TFont read FFont write SetFont;
    property Height: Integer read FHeight write FHeight default 69;
    property Hint: string read FHint write SetHint;
    property Left: Integer read FLeft write FLeft default 200;
    property Max: Integer read FMax write FMax default 100;
    property Min: Integer read FMin write FMin;
    property Position: TPosition read FPosition write FPosition
      default poScreenCenter;
    property Progress: Integer read FProgress write SetProgress;
    property StayOnTop: Boolean read FStayOnTop write FStayOnTop default True;
    property Scaled: Boolean read FScaled write FScaled default True;
    property Step: Integer read FStep write FStep default 10;
    property Text: string read FText write SetText;
    property Visible: Boolean read GetVisible write SetVisible;
    property Top: Integer read FTop write FTop default 180;
    property Width: Integer read FWidth write FWidth default 298;
  end;

var
  ProgressForm: TProgressForm;

procedure Register;

implementation

{$R *.DFM}

procedure Register;

begin
  RegisterComponents('Samples', [TProgressWindow]);
end;
constructor TProgressWindow.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FProgressForm := nil;
  FCursor    := crHourglass;
  FHeight    := 69;
  FLeft      := 200;
  FMax       := 100;
  FPosition  := poScreenCenter;
  FStayOnTop := True;
  FScaled    := True;
  FStep      := 10;
  FText      := 'Progress';
  FTop       := 180;
  FWidth     := 298;
end;

destructor TProgressWindow.Destroy;
begin
  Visible := False;
  inherited Destroy;
end;


procedure TProgressWindow.Show;

begin

  if ProgressForm <> nil then begin

    FProgressForm.Show;

    FProgressForm.Update;

  end

  else Visible := True;

end;


procedure TProgressWindow.Hide;

begin

  Visible := False;

end;


function TProgressWindow.GetVisible: Boolean;

begin

  Result := FProgressForm <> nil;

end;


procedure TProgressWindow.SetVisible(Value: Boolean);

begin

  if Value then

    if FProgressForm <> nil then begin

      FProgressForm.Show;

      FProgressForm.Update;

    end

    else begin

      FProgressForm := TProgressForm.Create(Application);

      with FProgressForm do begin

        Cursor       := FCursor;

        Font         := FFont;
        ClientHeight := FHeight;
        Bar.Height   := ClientHeight - Bar.Top - 16;
        Bar.Hint     := FHint;
        Left         := FLeft;
        Bar.Max      := FMax;
        Bar.Min      := FMin;
        Position     := FPosition;
        Bar.Position := FProgress;
        if FStayOnTop then
          FormStyle := fsStayOnTop else
          FormStyle := fsNormal;
        Scaled       := FScaled;
        Bar.Step     := FStep;
        Text.Caption := FText;
        Top          := FTop;
        ClientWidth  := FWidth;
        Bar.Width    := ClientWidth - 32;
        Show;
        Update;
      end;
    end

  else if FProgressForm <> nil then begin

    FProgressForm.Hide;

    FProgressForm.Free;

    FProgressForm := nil;

  end;

end;


procedure TProgressWindow.SetColor(Value: TColor);

begin

  FColor := Value;

  if FProgressForm <> nil then begin

    FProgressForm.Color := Value;

    FProgressForm.Update;

  end;

end;


procedure TProgressWindow.SetCursor(Value: TCursor);
begin
  FCursor := Value;

  if FProgressForm <> nil then begin

    FProgressForm.Cursor := Value;

    FProgressForm.Update;

  end;

end;


procedure TProgressWindow.SetFont(Value: TFont);
begin
  FFont := Value;

  if FProgressForm <> nil then begin

    FProgressForm.Font := Value;

    FProgressForm.Update;

  end;

end;


procedure TProgressWindow.SetHint(Value: string);
begin
  FHint := Value;

  if FProgressForm <> nil then begin

    FProgressForm.Bar.Hint := Value;

    FProgressForm.Update;

  end;

end;


procedure TProgressWindow.SetProgress(Value: Integer);
begin
  FProgress := Value;

  if FProgressForm <> nil then begin

    FProgressForm.Bar.Position := Value;

    FProgressForm.Update;

  end;

end;


procedure TProgressWindow.SetText(Value: string);
begin
  FText := Value;

  if FProgressForm <> nil then begin

    FProgressForm.Text.Caption := Value;

    FProgressForm.Update;

  end;

end;


end.

