{*******************************************************************************

		Programmer: Joel Jean
    Date: 30/11/1998
    Copyright  1998

    Animated Progress Dialog Component...

    This dialog box provide a wrapper for the windows animated dialog box. The
    animation may be modified by selecting from the CommonAvi property. The
    MaxProgress and MinProgress will allow to determine a range. The caption of
    the dialog box can also be modified by using the Caption property.

    To increment the progress bar or modify the status labels, you can use the
    UpdateProgress procedure. This procedure take tree param, the first one is
    the current progress ID, the other are sting param which indicates which are
    used for the status ID.

    This component is freeware... bring any modification to it has needed.
    Please report any changes so I could update this component.

    Please send comments to: jeanj@nb.sympatico.ca
                             joel.jean@hrdc-drhc.gc.ca

*******************************************************************************}
unit ProgressDialog;
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, UnitFormProgress;

type
  TProgressDialog = class(TComponent)
  private
    { Private declarations }
    FCaption: String;
    FCommonAvi: TCommonAVI;
    FMaxProgress: integer;
    FMinProgress: integer;
    FStatus1: String;
    FStatus2: String;
    Progress: integer;
    function GetActiveState: boolean;
    function GetCaption: String;
    function GetCommonAvi: TCommonAVI;
    function GetStatus1: String;
    function GetStatus2: String;
    function GetMaxProgress: integer;
    function GetMinProgress: integer;
    procedure SetCaption(const Value: String);
    procedure SetStatus1(const Value: String);
    procedure SetStatus2(const Value: String);
    procedure SetCommonAvi(const Value: TCommonAVI);
    procedure SetMaxProgress(const Value: integer);
    procedure SetMinProgress(const Value: integer);
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Execute;
    procedure UpdateProgress(Progress: integer; Status1, Status2: String);
  published
    { Published declarations }
    property Active: boolean read GetActiveState;
    property Caption: String read GetCaption write SetCaption;
    property CommonAvi: TCommonAVI read GetCommonAvi write SetCommonAvi default aviCopyFile;
    property Status1: String read GetStatus1 write SetStatus1;
    property Status2: String read GetStatus2 write SetStatus2;
    property MaxProgress: integer read GetMaxProgress write SetMaxProgress default 100;
    property MinProgress: integer read GetMinProgress write SetMinProgress default 0;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Custom Components', [TProgressDialog]);
end;

{ TProgressDialog }


constructor TProgressDialog.Create(AOwner: TComponent);
begin
	inherited Create( AOwner );

  CommonAvi := aviCopyFile;
  Caption := '';
  Status1 := '';
  Status2 := '';
  Progress := 0;
end;

destructor TProgressDialog.Destroy;
begin
	inherited;
end;

procedure TProgressDialog.Execute;
begin
  Form_Progress := TForm_Progress.Create( Self );

	with Form_Progress do
  begin
		Caption                         := Self.Caption;
		Animate_SelectedAvi.CommonAVI   := CommonAvi;
    Animate_SelectedAvi.Active      := True;
		Label_ProcessStatus1.Caption    := Status1;
    Label_ProcessStatus2.Caption    := Status2;
    ProgressBar_StatusIndicator.Max := MaxProgress;
    ProgressBar_StatusIndicator.Min := MinProgress;
    HelpContext                     := HelpContext;

    // Display the form...
    Show;
  end;
end;

function TProgressDialog.GetCaption: String;
begin
	Result := FCaption;
end;

function TProgressDialog.GetCommonAvi: TCommonAVI;
begin
	Result := FCommonAvi;
end;

function TProgressDialog.GetMaxProgress: integer;
begin
	Result := FMaxProgress;
end;

function TProgressDialog.GetMinProgress: integer;
begin
	Result := FMinProgress;
end;

function TProgressDialog.GetStatus1: String;
begin
	Result := FStatus1;
end;

function TProgressDialog.GetStatus2: String;
begin
	Result := FStatus2;
end;

procedure TProgressDialog.SetCaption(const Value: String);
begin
	if (FCaption <> Value) then
  	FCaption := Value;
end;

procedure TProgressDialog.SetCommonAvi(const Value: TCommonAVI);
begin
	if (FCommonAvi <> Value) then
  	FCommonAvi := Value;
end;

procedure TProgressDialog.SetMaxProgress(const Value: integer);
begin
	if (FMaxProgress <> Value) then
  	FMaxProgress := Value;
end;

procedure TProgressDialog.SetMinProgress(const Value: integer);
begin
	if (FMinProgress <> Value) then
  	FMinProgress := Value;
end;


procedure TProgressDialog.SetStatus1(const Value: String);
begin
	if (FStatus1 <> Value) then
  	FStatus1 := Value;
end;

procedure TProgressDialog.SetStatus2(const Value: String);
begin
	if (FStatus2 <> Value) then
  	FStatus2 := Value;
end;

procedure TProgressDialog.UpdateProgress(Progress: integer; Status1,
  Status2: String);
begin
  Application.ProcessMessages;

  // Before modifying any visual aspect first check if the form is still around...
	if not (Form_Progress = nil) then
  begin
		with Form_Progress do
    begin
			ProgressBar_StatusIndicator.Position := Progress;
      Label_ProcessStatus1.Caption := Status1;
      Label_ProcessStatus2.Caption := Status2;

      // Check if progress meter has reached the end...
      if (ProgressBar_StatusIndicator.Max <= ProgressBar_StatusIndicator.Position) then
      	Close;
    end;
  end;
end;


function TProgressDialog.GetActiveState: boolean;
begin
	Result := not (Form_Progress = nil);
end;

end.
