unit UnitThread;

interface

uses
  Classes;

type
  TCopyFilesThread = class(TThread)
  private
    { Private declarations }
  protected
    procedure Execute; override;
  end;

implementation

{ Important: Methods and properties of objects in VCL can only be used in a
  method called using Synchronize, for example,

      Synchronize(UpdateCaption);

  and UpdateCaption could look like,

    procedure TCopyFilesThread.UpdateCaption;
    begin
      Form1.Caption := 'Updated in a thread';
    end; }

{ TCopyFilesThread }

procedure TCopyFilesThread.Execute;
begin
  { Place thread code here }
	with ProgressDialog1 do
  begin
    MaxProgress   := 1000;
    MinProgress   := 0;

    Execute;

    for i := 0 to 1000 do
    begin
      if not (ProgressDialogActive) then
        Break;

      UpdateProgress( i, 'from 0 to 1000', 'Coping ' + IntToStr( i ) );
    end;
  end;
end;

end.
 