//PROFILE-NO
{$O+}
{$D-}
{$B-}
{$Q-}
{$I-}
{$R-}
{$X+}

unit ProfInt;

interface

USES
  Dialogs, Windows;

TYPE
{$IFDEF VER120 }
  TMyComp  = Int64;
{$ELSE }
  TMyComp  = Comp;
{$ENDIF }

  TMyLargeInteger = RECORD
                    CASE Byte OF
                     0 : ( LowPart  : DWORD; HighPart : LongInt );
                     1 : ( QuadPart : TMyComp );
                  END;
  TPLargeInteger = ^TMyLargeInteger;

{$IFNDEF VER90}
  TObjFunction = FUNCTION ( Text, Caption : PChar;
                            Flags : Longint ) : Integer OF Object;
{$ELSE}
  TObjFunction = FUNCTION ( Text, Caption : PChar;
                            Flags : Word ) : Integer OF Object;
{$ENDIF}

// Profiler-Measurement-Functions
PROCEDURE ProfStop  ( l : DWord; h : Integer);    external 'PROFMEAS.DLL';
FUNCTION  ProfEnter ( mptr : Pointer; prozNr : Integer ) : TPLargeInteger; external 'PROFMEAS.DLL';
FUNCTION  ProfExit  ( lc   : DWORD;   hc : Integer; prozNr : Integer ) : TPLargeInteger; external 'PROFMEAS.DLL';
PROCEDURE ProfActivate;     external 'PROFMEAS.DLL';
PROCEDURE ProfDeActivate;   external 'PROFMEAS.DLL';
PROCEDURE ProfSetComment  ( comm   : PChar );     external 'PROFMEAS.DLL';
PROCEDURE ProfAppendResults;                      external 'PROFMEAS.DLL';

// Post-Mortem-Review-Functions
PROCEDURE PomoEnter       ( prozNr : SmallInt );  external 'PROFMEAS.DLL';
PROCEDURE PomoExce;                               external 'PROFMEAS.DLL';
PROCEDURE PomoExit        ( prozNr : SmallInt );  external 'PROFMEAS.DLL';

// Functions to interrupt and continue measurement for calls which could set the
//  Process idle. Use these calls to implement own Non-measured Calls. If METHODS
//  can set a process idle, the only possibility is, to put these calls into your
//  sources (included by an IFDEF-statement).
//  USE 2 or more spaces between IFDEF and PROFILE, otherwise it will be deleted
//  by the ProDelphi. Example:
//  {$IFDEF     PROFILE } StopCounting;     {$ENDIF }
//    ObjectReference.MethodThatMightSetProcessIdle;
//  {$IFDEF     PROFILE } ContinueCounting; {$ENDIF }

// Normal procedures that set the process idle can be handled like the Sleep-
//  function in this unit.
PROCEDURE StopCounting;                           external 'PROFMEAS.DLL';
PROCEDURE ContinueCounting;                       external 'PROFMEAS.DLL';

// Delphi-Functions that set process idle
PROCEDURE ShowMessage ( CONST Msg  : String );
{$IFNDEF VER90 }
PROCEDURE ShowMessageFmt(const Msg : string; Params : array of const );
{$ENDIF}
          // If you need to compile the VCL, the next function must be deleted,
          // Sorry ! The USES statement for Dialogs has to be moved to the
          // Implementation part !!!
function  MessageDlg( const Msg : string;         AType   : TMsgDlgType;
                      AButtons  : TMsgDlgButtons; HelpCtx : Longint ) : Word;

// Delphi-TApplication-Functions that set process idle (handled in DLL)
PROCEDURE ProcessMessages;                        external 'PROFMEAS.DLL';
PROCEDURE HandleMessage;                          external 'PROFMEAS.DLL';
{$IFDEF VER90 }
FUNCTION  AMessageBox( Text, Caption  : PChar;
                       Flags : Word ) : Integer;
{$ELSE }
FUNCTION  AMessageBox( Text, Caption   : PChar;
                       Flags : Longint): Integer;
{$ENDIF }

// Windows-Functions that set process idle
FUNCTION  DispatchMessage(CONST lpMsg  : TMsg) : Longint;
FUNCTION  DialogBox( hInstance  : HINST; lpTemplate   : PChar;
                     hWndParent : HWND;  lpDialogFunc : TFNDlgProc): Integer;
FUNCTION  DialogBoxIndirect( hInstance  : HINST; const lpDialogTemplate : TDlgTemplate;
                             hWndParent : HWND;        lpDialogFunc     : TFNDlgProc): Integer;
FUNCTION  MessageBox ( hWnd : HWND; lpText, lpCaption: PChar; uType : UINT ) : Integer;
FUNCTION  MessageBoxEx( hWnd : HWND; lpText, lpCaption: PChar; uType : UINT; lang : Word ) : Integer;
{$IFNDEF VER90 }
FUNCTION  SignalObjectAndWait ( h1, h2 : THandle;
                                ms     : DWord;
                                al     : BOOL) : BOOL;
{$ENDIF}
FUNCTION  WaitForSingleObject ( h1     : THandle;
                                MS     : DWORD ) : DWORD;
FUNCTION  WaitForSingleObjectEx ( h1   : THandle;
                                  MS   : DWORD;
                                  al   : BOOL ) : DWORD;

FUNCTION  WaitForMultipleObjects ( ct  : DWORD;
                                   CONST pH : PWOHandleArray;
                                   wait     : BOOL;
                                   ms       : DWORD ) : DWORD;
FUNCTION  WaitForMultipleObjectsEx ( ct  : DWORD;
                                     CONST pH : PWOHandleArray;
                                     wait     : BOOL;
                                     ms       : DWORD;
                                     al       : Boolean) : DWORD;
FUNCTION  MsgWaitForMultipleObjects ( ct      : DWORD;
                                      VAR pH  : PWOHandleArray;
                                      wait    : BOOL;
                                      ms      : DWORD;
                                      wm      : DWORD ) : DWORD;
{$IFNDEF VER90 }
FUNCTION  MsgWaitForMultipleObjectsEx ( ct     : DWORD;
                                        VAR pH : PWOHandleArray;
                                        ms     : DWORD;
                                        wm     : DWORD;
                                        fl     : DWORD ) : DWORD;
{$ENDIF}
PROCEDURE Sleep   (zeit : DWORD );
PROCEDURE SleepEx (zeit : DWORD; alertable : BOOL );
FUNCTION  WaitCommEvent ( hd  : THandle; VAR em : DWORD;
                          lpo : POverlapped ) : BOOL;
FUNCTION  WaitForInputIdle ( hp : THandle; ms : DWORD ) : DWORD;
FUNCTION  WaitMessage : BOOL;
FUNCTION  WaitNamedPipe ( np : PAnsiChar; ms : DWORD ) : BOOL;
// Registration-Functions (internal Use only)
PROCEDURE RegisterMessageBox( MBProc : TObjFunction );

IMPLEMENTATION

// Profiler-Internal-Functions, DO NOT USE
FUNCTION  ProfGlobalInit1 : Boolean;              external 'PROFMEAS.DLL';
PROCEDURE ProfGlobalInit2 ( j : Integer );        external 'PROFMEAS.DLL';
PROCEDURE ProfUnInitTimer;                        external 'PROFMEAS.DLL';
FUNCTION  ProfIsInitialised : Integer;            external 'PROFMEAS.DLL';
FUNCTION  ProfMustBeUnInitialised : Integer;      external 'PROFMEAS.DLL';

// Calibration - Function - DO NOT USE
PROCEDURE CalcQPCTime; external 'PROFCALI.DLL';

VAR
  MessBox : TObjFunction;

// Check if CPU is intel-Compatible
PROCEDURE PruefeKompatibilitaet;
VAR
  ts : TMyLargeInteger;
BEGIN
  Try
    asm
      DW 310FH;
      mov ts.highpart,edx
      mov ts.lowpart,eax
    end;
  Except
    Windows.MessageBox(0, 'This CPU is not Intel-Compatible', 'ProDelphi - ERROR', MB_OK);
    halt(0);
  End;
END;

PROCEDURE ShowMessage ( CONST Msg  : String );
BEGIN
  StopCounting;
  Dialogs.ShowMessage(Msg);
  ContinueCounting;
END;

PROCEDURE RegisterMessageBox( MBProc : TObjFunction );
BEGIN
  MessBox := MBProc;
END;

{$IFNDEF VER90 }
PROCEDURE ShowMessageFmt(const Msg : string; Params : array of const );
BEGIN
  StopCounting;
  Dialogs.ShowMessageFmt(Msg, Params);
  ContinueCounting;
END;

FUNCTION AMessageBox( Text, Caption     : PChar;
                      Flags : LongInt ) : Integer;
BEGIN
  StopCounting;
  IF Assigned(MessBox) THEN
    Result := MessBox(Text, Caption, Flags)
  ELSE BEGIN
    Result := Windows.MessageBox(0, Text, Caption, Flags);
  END;
  ContinueCounting;
END;

{$ELSE }

FUNCTION AMessageBox( Text, Caption    : PChar;
                      Flags : Word  )  : Integer;
BEGIN
  StopCounting;
  IF Assigned(MessBox) THEN
    Result := MessBox(Text, Caption, Flags)
  ELSE BEGIN
    Result := Windows.MessageBox(0, Text, Caption, Flags);
  END;
  ContinueCounting;
END;
{$ENDIF }

FUNCTION MessageDlg( const Msg : string;         AType   : TMsgDlgType;
                     AButtons  : TMsgDlgButtons; HelpCtx : Longint ) : Word;
BEGIN
  StopCounting;
  Result := Dialogs.MessageDlg(Msg, AType, AButtons, HelpCtx);
  ContinueCounting;
END;

FUNCTION  DialogBox( hInstance  : HINST; lpTemplate   : PChar;
                     hWndParent : HWND;  lpDialogFunc : TFNDlgProc): Integer;
BEGIN
  StopCounting;
  Result := Windows.DialogBox(hInstance, lpTemplate, hWndParent, lpDialogFunc);
  ContinueCounting;
END;

FUNCTION  DialogBoxIndirect( hInstance  : HINST; const lpDialogTemplate : TDlgTemplate;
                             hWndParent : HWND;        lpDialogFunc     : TFNDlgProc): Integer;
BEGIN
  StopCounting;
  Result := Windows.DialogBoxIndirect(hInstance, lpDialogTemplate, hWndParent, lpDialogFunc);
  ContinueCounting;
END;

FUNCTION MessageBox ( hWnd : HWND; lpText, lpCaption: PChar; uType : UINT ) : Integer;
BEGIN
  StopCounting;
  Result := Windows.MessageBox(hWnd, lpText, lpCaption, uType);
  ContinueCounting;
END;

FUNCTION MessageBoxEx ( hWnd : HWND; lpText, lpCaption: PChar; uType : UINT; lang : Word ) : Integer;
BEGIN
  StopCounting;
  Result := Windows.MessageBoxEx(hWnd, lpText, lpCaption, uType, lang);
  ContinueCounting;
END;

FUNCTION DispatchMessage( CONST lpMsg: TMsg ) : Longint;
BEGIN
  StopCounting;
  Result := Windows.DispatchMessage(lpMsg);
  ContinueCounting;
END;

PROCEDURE Sleep( zeit : DWORD );
BEGIN
  StopCounting;
  Windows.Sleep(zeit);
  ContinueCounting;
END;

PROCEDURE SleepEx( zeit : DWORD; alertable : BOOL );
BEGIN
  StopCounting;
  Windows.SleepEx(zeit, alertable);
  ContinueCounting;
END;
{$IFNDEF VER90 }
FUNCTION SignalObjectAndWait ( h1, h2 : THandle;
                               ms     : DWord;
                               al     : BOOL) : BOOL;
BEGIN
  StopCounting;
  Result := Windows.SignalObjectAndWait(h1, h2, ms, al);
  ContinueCounting;
END;
{$ENDIF }

FUNCTION WaitForSingleObject ( h1     : THandle;
                               MS     : DWORD ) : DWORD;
BEGIN
  StopCounting;
  Result := Windows.WaitForSingleObject ( h1, MS );
  ContinueCounting;
END;

FUNCTION WaitForSingleObjectEx ( h1   : THandle;
                                 MS   : DWORD;
                                 al   : BOOL ) : DWORD;
BEGIN
  StopCounting;
  Result := Windows.WaitForSingleObjectEx (h1, MS, al);
  ContinueCounting;
END;

FUNCTION WaitForMultipleObjects ( ct  : DWORD;
                                  CONST pH : PWOHandleArray;
                                  wait     : BOOL;
                                  ms       : DWORD ) : DWORD;
BEGIN
  StopCounting;
  Result := Windows.WaitForMultipleObjects(ct, pH, wait, ms);
  ContinueCounting;
END;

FUNCTION WaitForMultipleObjectsEx ( ct  : DWORD;
                                    CONST pH : PWOHandleArray;
                                    wait     : BOOL;
                                    ms       : DWORD;
                                    al       : Boolean ) : DWORD;
BEGIN
  StopCounting;
  Result := Windows.WaitForMultipleObjectsEx(ct, pH, wait, ms, al);
  ContinueCounting;
END;

FUNCTION MsgWaitForMultipleObjects ( ct     : DWORD;
                                     VAR pH : PWOHandleArray;
                                     wait   : BOOL;
                                     ms     : DWORD;
                                     wm     : DWORD ) : DWORD;
BEGIN
  StopCounting;
  Result := Windows.MsgWaitForMultipleObjects(ct, pH, wait, ms, wm);
  ContinueCounting;
END;

{$IFNDEF VER90 }
FUNCTION MsgWaitForMultipleObjectsEx ( ct     : DWORD;
                                       VAR pH : PWOHandleArray;
                                       ms     : DWORD;
                                       wm     : DWORD;
                                       fl     : DWORD ) : DWORD;
BEGIN
  StopCounting;
  Result := Windows.MsgWaitForMultipleObjectsEx(ct, pH, ms, wm, fl);
  ContinueCounting;
END;
{$ENDIF}
FUNCTION WaitCommEvent ( hd : THandle; VAR em : DWORD; lpo : POverlapped ) : BOOL;
BEGIN
  StopCounting;
  Result := Windows.WaitCommEvent(hd, em, lpo);
  ContinueCounting;
END;

FUNCTION WaitForInputIdle ( hp : THandle; ms : DWORD ) : DWORD;
BEGIN
  StopCounting;
  Result := Windows.WaitForInputIdle(hp, ms);
  ContinueCounting;
END;

FUNCTION WaitMessage : BOOL;
BEGIN
  StopCounting;
  Result := Windows.WaitMessage;
  ContinueCounting;
END;

FUNCTION WaitNamedPipe ( np : PAnsiChar; ms : DWORD ) : BOOL;
BEGIN
  StopCounting;
  Result := Windows.WaitNamedPipe(np, ms);
  ContinueCounting;
END;

INITIALIZATION
  IF ProfIsInitialised = 1 THEN BEGIN
    PruefeKompatibilitaet;
    IF ProfGlobalInit1 = TRUE THEN
      CalcQPCTime;
    ProfGlobalInit2(0);
  END;
FINALIZATION
  IF ProfMustBeUnInitialised = 1 THEN BEGIN
    ProfSetComment('At finishing application');
    ProfAppendResults;
    ProfUnInitTimer;
  END;
end.
