{Unit para guardar la configuracion de las impresoras en windows}
unit PrinterSetup;

interface
Uses Printers,Windows,SysUtils,Classes,WinSpool,Consts;

Type
{Excepcion de que el archivo no es valido}
EPrinterSetup=Class(Exception);
EInvalidFile=Class(EPrinterSetup);
EFileNoExists=Class(EPrinterSetup);
{Registro que guarda la configuracin}
TPrinterConfig=record
IDFile:string[6];//Identificardor para validar archivos
Device, Driver, Port: array[0..CCHDEVICENAME] of char; //Datos de la impredora
SizeOfDeviceMode:DWORD;//Tamao de DeviceMode
end;

TPrinterSetup = class
public
  {Declaraciones publicas}
  Procedure SaveToFile(Filename:TFilename);
  Procedure LoadFromFile(Filename:TFilename);
end;
const
     SOutOfMemory = 65415;
implementation
{Salva en un fichero la configuracion de la impresora}
Procedure TPrinterSetup.SaveToFile(Filename:TFilename);
var
SetupPrinter:TPrinterConfig;
DeviceMode:THandle;
StubDevMode: TDeviceMode;
FPrinterHandle:THandle;
fFileConfig:file of TPrinterConfig;
fFileDevMode:file of Char;
pDevMode:Pchar;
begin
{$I+}
With SetupPrinter do
   Begin
   IDFile:='PRNCFG';
   Printer.GetPrinter(Device, Driver, Port, DeviceMode);
   OpenPrinter(Device, FPrinterHandle, nil);
   SizeOfDeviceMode:=DocumentProperties(0,FPrinterHandle, Device, StubDevMode,StubDevMode, 0);
   end;
{Creamos el archivo}
AssignFile(fFileConfig, FileName);
try
    try
    ReWrite(fFileConfig);
    {Escribimos la cabecera}
    write(fFileConfig,SetupPrinter);
    finally
    CloseFile(fFileConfig);
    end;
except
    raise;
end;
{Obtengo puntero a los datos}
pDevMode:=GlobalLock(DeviceMode);
if pDevMode=nil then
   raise EOutOfMemory.CreateRes(SOutOfMemory);
try
    {Lo abrimos de nuevo para escribir los datos}
    AssignFile(fFileDevMode, FileName);
    try
        try
            Reset(fFileDevMode);
            {Vamos al final del archivo}
            Seek(fFileDevMode,FileSize(fFileDevMode));
            {Grabo los datos}
            BlockWrite(fFileDevMode,pDevMode^,SetupPrinter.SizeOfDeviceMode);
        finally
            {Cierro el fichero}
            CloseFile(fFileDevMode);
        end;
    except
        raise;
    end;
finally
    {Libero el puntero}
    GlobalUnLock(DeviceMode);
end;
{$I-}
end;

{Recupera de un fichero la configuracion de la impresora}
Procedure TPrinterSetup.LoadFromFile(Filename:TFilename);
var
SetupPrinter:TPrinterConfig;
DeviceMode:THandle;
fFileConfig:file of TPrinterConfig;
fFileDevMode:file of Char;
pDevMode:Pchar;
begin
{$I+}
{Solo si existe el archivo}
if FileExists(Filename) then
    begin
    {Leemos la cabecera}
    AssignFile(fFileConfig, FileName);
    try
        try
        Reset(fFileConfig);
        read(fFileConfig,SetupPrinter);
        finally
            CloseFile(fFileConfig);
        end;
    except
        raise;
    end;
    if SetupPrinter.IDFile<>'PRNCFG' then
       Raise EInvalidFile.CreateFmt('El archivo %s no es valido',[Filename]);
    {Obtenemos el handle para DeviceMode}
    DeviceMode:=GlobalAlloc(GHND,SetupPrinter.SizeOfDeviceMode);
    if DeviceMode=0 then
       raise EOutOfMemory.CreateRes(SOutOfMemory);
    {Obtengo puntero a los datos}
    pDevMode:=GlobalLock(DeviceMode);
    if pDevMode=nil then
       raise EOutOfMemory.CreateRes(SOutOfMemory);
    {Leemos los datos del DeviceMode}
try
    AssignFile(fFileDevMode, FileName);
    try
        try
        Reset(fFileDevMode);
        {Vamos principio de los datos de Device Mode}
        Seek(fFileDevMode,SizeOf(SetupPrinter));
        {Leo los datos}
        BlockRead(fFileDevMode,pDevMode^,SetupPrinter.SizeOfDeviceMode);
        finally
        {Cierro el fichero}
        CloseFile(fFileDevMode);
        end;
    except
        {Libero la memoria}
        GlobalFree(DeviceMode);
        raise;
        end;
finally
    {Libero el puntero}
    GlobalUnLock(DeviceMode);
end;
    {Asigno la nueva impresora}
    With SetupPrinter do
       Printer.SetPrinter(Device,Driver,Port, DeviceMode);
    end
else
    Raise EFileNoExists.CreateFmt('El archivo %s no existe',[Filename]);
{$I-}
end;
end.

