unit Preview1;
// This is the main form for this demo app.

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, PrintDrv, Printers,  ExtCtrls, Buttons, FileCtrl;

const
	LeftMargin:double = 0.5;
  RightMargin:double = 8.0;
  TopMargin:double = 0.5;
  LetterBottomMargin:double = 10.5;
  LegalBottomMargin:double = 13.5;

  olMailitem = 0 ;
  olImportanceLow = 0 ;
  olImportanceNormal = 1 ;
  olImportanceHigh = 2 ;


type
  TMainForm = class(TForm)
    Label1: TLabel;
    Demo1: TButton;
    PrintOrient: TCheckBox;
    Image1: TImage;
    Demo2: TButton;
    LegalSize: TCheckBox;
    Image2: TImage;
    DisplayGraphic: TBitBtn;
    DisplayText: TBitBtn;
    Prn: TMWPrintObject;
    ColorType: TRadioGroup;
    GraphicDemo: TBitBtn;
    Red: TEdit;
    Blue: TEdit;
    Green: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    PrinterSetupDialog1: TPrinterSetupDialog;
    SpeedButton1: TSpeedButton;
    SpecialBtn: TBitBtn;
    FD1: TFontDialog;
    procedure Demo1Click(Sender: TObject);
    procedure Demo2Click(Sender: TObject);
    procedure PrnNewPage(Sender: TObject);
    procedure SetPageDefaults;
    procedure LegalSizeClick(Sender: TObject);
    procedure DisplayGraphicClick(Sender: TObject);
    procedure DisplayTextClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure GraphicDemoClick(Sender: TObject);
    procedure ColorTypeClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpecialBtnClick(Sender: TObject);
    procedure PrnAfterPrint(Sender: TObject);
    procedure PrnBeforePrint(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
    procedure DoTestPreview;
    procedure PrintTestFile;
    procedure PrintTestDemo;
    procedure CreateColumns;
    procedure PrintTextImage;
    procedure TestProc;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;
  Cleared,
  TestNumber: integer;
  Shading: TColor;
  BottomMargin: double;
  CancelMe: boolean;
  TestText: string;

implementation

{$R *.DFM}

procedure TMainForm.SetPageDefaults;
// I usually create separate default routines so that I can call them separately
// based on the type of report I want to perform.
var
	Font: TFont;

begin
	with Prn do
  begin
  	SetMeasure(mtInches);
  	Font := TFont.Create;
    Font.Name := 'Times New Roman';
    Font.Size := 10;
    Font.Style := [];
    Font.Color := clBlack;
    SetFontInfo(Font);
    SetMargins(TopMargin,BottomMargin,LeftMargin,RightMargin);
    Font.Color := clBlue;
    Font.Size := 12;
    Font.Style := [fsBold];
    SetHeaderInfo(1,0.6,'Test Preview Program',wtCenter,Font);
    Font.Color := clRed;
    SetHeaderInfo(2,0.75,'Second Header Line',wtCenter,Font);
    SaveCurrentFont;
    Font.Size := 16;
    Font.Style := [fsBold];
    SetFontInfo(Font);
    SetHeaderDim(LeftMargin,0.5,RightMargin,0.625 + (GetLineHeightInches * 1.5),true,0,RGB(255,255,230));
    SetDetailTopBottom(0.625 + (GetLineHeightInches * 2),BottomMargin-0.5);
    RestoreCurrentFont;
    Font.Name := 'Times New Roman';
    Font.Size := 8;
    Font.Style := [];
    Font.Color := clBlack;
    case TestNumber of
     	1: SetPageNumberInfo(0.5,'Page %d',2,True,Font);
      2: SetPageNumberInfo(BottomMargin + GetLineHeightInches,'Page %d',1,True,Font);
    end;
    Font.Name := 'Arial';
    Font.Size := 10;
    Font.Style := [];
    Font.Color := clBlue;
    SetFooterDim(LeftMargin,BottomMargin-0.4,RightMargin,BottomMargin,true,0,RGB(230,255,255));
    SetFooterInfo(1,BottomMargin - 0.25,'Page Footer Line #1.',1,Font);
    SetPageNumberInfo(BottomMargin-0.1,'page %d',wtRight,false,Font);
    Font.Free;
  end;
end;

Procedure TMainForm.DoTestPreview;
// entry point for both demo print routines to set up the defaults
var
	TempX: single;
  tmpFont: TFont;

begin
  try
//  	Hide;
    Shading := RGB(235,235,235);
    CancelMe := false;
    with Prn do
    begin
      if PrintOrient.Checked then
      begin
      	Orientation := poLandscape;
        if LegalSize.Checked then
        	RightMargin := 13.5
        else
    			RightMargin := 10.5;
        BottomMargin := 8.0;
      end
      else
      begin
      	Orientation := poPortrait;
    		RightMargin := 8.0;
        if LegalSize.Checked then
        	BottomMargin := 13.5
        else
        	BottomMargin := 10.5;
      end;
  		if not Start then
      	exit;
      SetPageDefaults;
  		TestText := '  Some text here to show how word wrapping is accomplished. By ' +
      						'passing this long string to the WriteLineWrap method, the TPrintObject '+
                  'component will automatically wrap the text within the given bounds.';
      case TestNumber of
      	1: PrintTestFile;
        2: PrintTestDemo;
      end;
     	Quit
    end;
  finally
  	Show;
  end;
end;

procedure TMainForm.PrintTestFile;
// demo printing for AutoPaging set to true
label
	DoneProcessing;
var

	tFile: TextFile;
  sLine: string;
  fY: integer;
  fX,fW: single;

begin
	try
		with Prn do
  	begin
    	if Not FileExists(ExtractFilePath(ParamStr(0))+'Readme.Txt') then
      begin
      	ShowMessage('Could not find test file...');
        exit;
      end;
      AutomaticPaging := true;
			AssignFile(tFile,ExtractFilePath(ParamStr(0))+'Readme.Txt');
      Reset(tFile);
      fY := 0;
      SetYPosition(PixelsToInchesVertical(Image1.Height div 2) + TopMargin);
      while not Eof(tFile) do //first loop to get a test count for progress bar...
      begin
      	readln(tFile,sLine);
    		if Not PrintingStatus then goto DoneProcessing;
        inc(fY);
      end;
     	SetProgressMax(fY * 20);
      UpdateBar(0);
   		CloseFile(tFile);
			AssignFile(tFile,ExtractFilePath(ParamStr(0))+'Readme.Txt');
   		Reset(tFile);
   		CreateColumn(1,LeftMargin,RightMargin-LeftMargin);
   		SetTopOfPage;
   		NextLine;
   		while not Eof(tFile) do
   		begin
 				if Not PrintingStatus then goto DoneProcessing;
   			Readln(tFile,sLine);
   			WriteLine(LeftMargin,-1,sLine);
     		Increment;
   		end;
    	if PrintingStatus then
    		NewPage;
DoneProcessing:
			CloseFile(tFile);
  	end;
  except
  	on Exception do
    	ShowMessage('Sorry, something didn''t work right!');
  end;
end;

procedure TMainForm.PrintTestDemo;
// demo printing for AutoPaging set to false for manual control.
var
	x,y: integer;
  z: single;
  s: string;
  MyImage: TImage;

begin
	with Prn do
  begin
  	ProgressBarInc := 2;
  	AutomaticPaging := false;
		SetTopOfPage;
    CreateColumns;
    TextColumnBox(GetColumnLeft(1),GetYPosition - 0.02,GetColumnRight(1),
    						GetYPosition + GetLineHeightInches + 0.02,1,Shading,
                'Column 1',1,1);
    TextColumnBox(GetColumnLeft(2),GetYPosition - 0.02,GetColumnRight(2),
    						GetYPosition + GetLineHeightInches + 0.02,1,Shading,
                'Column 2',2,1);
    TextColumnBox(GetColumnLeft(3),GetYPosition - 0.02,GetColumnRight(3),
    						GetYPosition + GetLineHeightInches + 0.02,1,Shading,
                'Column 3',3,1);
    TextColumnBox(GetColumnLeft(4),GetYPosition - 0.02,GetColumnRight(4),
    						GetYPosition + GetLineHeightInches + 0.02,1,Shading,
                'Column 4',4,1);
		NextLine;
    Increment;
//    SetMeasure(mtMM);
    SetFontColor(clBlue);
    WriteLineCenter(-1.0,'Centered column text...');
    SetFontColor(clBlack);
    NextLine;
    for x := 1 to 10 do
    begin
    	for y := 1 to 4 do
      	WriteLineColumnCenter(y,GetYPosition,'Line: ' + IntToStr(x) + '  Col: ' + IntToStr(y));
      NextLine;
      Increment;
    end;
    if CancelMe then exit;
    NextLine;
    SetFontColor(clBlue);
    WriteLineCenter(-2.0,'Left justified column text...');
    SetFontColor(clBlack);
    NextLine;
    for x := 1 to 10 do
    begin
    	for y := 1 to 4 do
      	WriteLineColumn(y,-2.0,'Line: ' + IntToStr(x) + '  Col: ' + IntToStr(y));
      NextLine;
      Increment;
    end;
    if not PrintingStatus then exit;
    NextLine;
    SetFontColor(clBlue);
    WriteLineCenter(-2.0,'Right justified column text...');
    SetFontColor(clBlack);
    NextLine;
    for x := 1 to 10 do
    begin
    	for y := 1 to 4 do
      	WriteLineColumnRight(y,-2.0,'Line: ' + IntToStr(x) + '  Col: ' + IntToStr(y));
      NextLine;
      Increment;
    end;
    SetFontStyle([]);
    if not PrintingStatus then exit;
    NextLine;
    SetFontColor(clBlue);
    WriteLineCenter(-1.0,'Decimal justified column text...');
    SetFontColor(clBlack);
    NextLine;
    for x := 1 to 10 do
    begin
    	for y := 1 to 4 do
      	WriteLineColumnDecimal(y,1.1,-2.0,Format('%5.2m',[(x*y)*0.92]));
      NextLine;
      Increment;
    end;
    Newlines(3);
    SetMeasure(mtPixels);
    MyImage := TImage.Create(Self);
    MyImage.Visible := false;
    MyImage.AutoSize := true;
    if FileExists(ExtractFilePath(ParamStr(0))+'TMW.bmp') then
    begin
    	MyImage.Picture.LoadFromFile(ExtractFilePath(ParamStr(0))+'TMW.bmp');
    	PrintGraphic(InchesToPixelsHorizontal(LeftMargin),InchesToPixelsVertical(BottomMargin),
    							MyImage.Width,MyImage.Height,MyImage);
    end;
    MyImage.Free;
    {
    	OR using -1.0 to default to graphic width and height.....
    PrintGraphic(LeftMargin,GetYPosition,-1.0,-1.0,Image1);
    }
    SetMeasure(mtInches);
    if not PrintingStatus then exit;
    NewPage;
    SetPenColor(clRed);
    DrawBoxShade(LeftMargin,GetYPosition - 0.1,1.5,3.0,10,Shading);
    SetPenColor(clBlack);
    Increment;
    SetTab(0.1);
    WriteLine(LeftMargin,-1.0,'[Shaded Box]');
    SetTab(0.0);
    Increment;
    if CancelMe then exit;
    WriteLine(2.6,-2.0,'[Regular Box]');
    DrawBox(2.4,GetYPosition - 0.1,4.0,GetYPosition + 0.3,1);
    Increment;
    SetYPosition(3.0);
    WriteLineCenter(-1.0,'Center Justification');
    Increment;
    WriteLineCenterToX(2.5,-1.0,'Center at 2.5"');
    if CancelMe then exit;
    SaveCurrentFont;
    SetFontName('Arial');
    SetFontSize(8);
    SetFontStyle([fsBold,fsUnderline]);
    WriteLineRight(-2.0,'Right Justified Text [fsBold,fsUnderline]');
    NextLine;
    RestoreCurrentFont;
    Increment;
    if CancelMe then exit;
    SetYPosition(6.0);
    WriteLine(LeftMargin,-1.0,'Text printed without a tab set...');
    SetTab(0.25);
    WriteLine(LeftMargin,-1.0,'Text printed using a 0.25" tab setting...');
    SetTab(0.0);
    NextLine;
    WriteLine(LeftMargin,-1.0,'Equation:  2x');
    SaveCurrentY;
    if CancelMe then exit;
    SaveCurrentFont;
    SetFontSize(6);
    SetFontStyle([]);
  // using -1.0 for X position places text after last printed horizontal location
    WriteLine(-1.0,GetYPosition - 0.02,'2');
    RestoreCurrentFont;
    RestoreCurrentY;
    WriteLine(-1.0,-2.0,' = 12');
    NextLine;
    if CancelMe then exit;
    WriteLine(LeftMargin,-1.0,'Memo field printing...');
    SetTab(0.1);
    z := GetYPosition + GetLineHeightInches;
  // Command to wrap text within a given bounds...
    WriteLineWrap(LeftMargin,3.5,-1.0,TestText,false,false);
    SetTab(0.0);
    SetPenColor(clBlue);
    DrawBox(LeftMargin,z,LeftMargin + 3.8,
    				GetYPosition + GetLineHeightInches + 0.05,1);
    SetPenColor(clBlack);
    SaveCurrentFont;
    SetFontSize(12);
    SetFontStyle([fsBold,fsItalic]);
    for x := 0 to 7 do
    begin
			SetFontAngle(x * 45);
    	WriteLine(6.0,5.5,'    Rotated text allowed.');
    end;
    SetFontAngle(0);
    RestoreCurrentFont;
    UpdateBar(100);
  end;
end;

procedure TMainForm.CreateColumns;
{This procedure sets up a few columns}
begin
	with Prn do
  begin
  	CreateColumn(1,0.5,1.5); //column 1
    CreateColumn(2,2.5,1.5); //column 2
    CreateColumn(3,4.5,1.5); //column 3
    CreateColumn(4,6.5,1.5); //column 4
  end;
end;

procedure TMainForm.Demo1Click(Sender: TObject);
// do automatic paging demo
begin
	if Prn.PrinterCanvas <> nil then
  	exit;
	TestNumber := 1;
	DoTestPreview;
end;

procedure TMainForm.Demo2Click(Sender: TObject);
// do manual paging demo
begin
	if Prn.PrinterCanvas <> nil then
  	exit;
	TestNumber := 2;
	DoTestPreview;
end;

procedure TMainForm.PrnNewPage(Sender: TObject);
// This routine is called in the OnNewPage event to place my graphic
// at the top of each page.
begin
	Prn.PrintGraphic(0.25,0.25,-1.0,-1.0,Image1);
end;

procedure TMainForm.LegalSizeClick(Sender: TObject);
begin
	if TCheckBox(Sender).Checked then
  	Prn.PaperSize := PAPER_LEGAL
  else
  	Prn.PaperSize := PAPER_LETTER;
end;

procedure TMainForm.PrintTextImage;
// here is a demo of how to print to an image canvas. Setting the
// PrinterCanvas property to a canvas instead of NIL will print to
// to that canvas without the preview stuff interfering. The component
// recognizes this as your desire not to do normal printing but to
// do other things. Because of this, you can not do things such as
// NewPage which are really not applicable to canvases. To clear the
// current canvas, use the ClearCanvas command. The margins should be
// set to the image width and height because the TCanvas has no such
// properties to get to.
var
	x,y: integer;
  s: string;
  p1,p2,p3,p4: TPoint;

begin
	with Prn do
  begin
// first set PrinterCanvas to the image canvas for printing...
  	PrinterCanvas := Image2.Canvas;
    Start;
    SetMeasure(mtInches);
// setting the margins gives the component the size of the canvas...
    SetMargins(0,PixelsToInchesVertical(Image2.Height),0,PixelsToInchesHorizontal(Image2.Width));
// now just print to it like any other time...
    SetFontName('Arial');
    SetFontSize(10);
    SetFontStyle([fsBold]);
    case ColorType.ItemIndex of
    	0: SetBrushColor(clWhite);
      1: SetBrushColor(clBlue);
      2: SetBrushColor(clRed);
      3: SetBrushColor(RGB(StrToInt(Red.Text),StrToInt(Green.Text),StrToInt(Blue.Text)));
    end;
    case GetBrushColor of
    	clWhite: SetFontColor(clBlue);
      clBlue: SetFontColor(clYellow);
      clRed: SetFontColor(clWhite);
    end;
    s := 'Print Preview Component';
    // only do this little eye catcher if the form is already showing...
    if Cleared > 0 then
  		for x := 1 to length(s) do
  		begin
  			ClearCanvas(GetBrushColor);
    		WriteLineCenter(0.2,copy(s,1,x));
      	Application.ProcessMessages;
    		sleep(100);
  		end
    else
    begin
    	ClearCanvas(GetBrushColor);
      WriteLineCenter(0.2,s);
    end;
    NextLine;
    SetFontStyle([]);
    case GetBrushColor of
    	clWhite: SetFontColor(clBlack);
      clBlue: SetFontColor(clWhite);
      clRed: SetFontColor(clAqua);
    end;
    SetPenColor(GetFontColor);
    WriteLineWrap(0.3,2.9,-1.0,
    	'This component allows you to print to the printer as you normally would. ' +
    	'The only difference is that it will also show a preview of the printed ' +
      'pages if you want. It also allows you to print to any TCanvas object such ' +
      'as this image.',false,false);
    SetBrushStyle(bsClear);
    SetMeasure(mtPixels); {change to pixels to draw with}
		MoveTo(64,45);
    LineTo(247,45);
    Ellipse(0,0,Image2.Width,Image2.Height);
    Arc(25,5,284,100,284,5,25,5);
    PolyLine([10,10,60,19,36,30,10,10]);
    PolyLine([296,10,246,19,270,30,296,10]);
    Measurement := mtInches; {change back to inches for default printing}
    Quit; { quit removes the reference of PrinterCanvas and sets it to nil.. }
  end;
end;

procedure TMainForm.DisplayGraphicClick(Sender: TObject);
var
	x,y,z: integer;
  nColor: TColor;

begin
	with Prn do
  begin
  	if PrinterCanvas <> nil then
    	exit;
  	PrinterCanvas := Image2.Canvas;
    Start;
    SetMargins(0,PixelsToInchesHorizontal(Image2.Height),0,PixelsToInchesVertical(Image2.Width));
    SetMeasure(mtPixels);
    // let's clear the image a little at a time...
    case ColorType.ItemIndex of
    	0: SetBrushColor(clWhite);
      1: SetBrushColor(clBlue);
      2: SetBrushColor(clRed);
      3: SetBrushColor(RGB(StrToInt(Red.Text),StrToInt(Green.Text),StrToInt(Blue.Text)));
    end;
		for y := 0 to Image2.Height do
    begin
    	x := 0;
      while x < Image2.Width do
      begin
      	ClearCanvasArea(x,y,x+50,y+30,GetBrushColor);
        inc(x,50);
        Application.ProcessMessages;
      end;
    end;
  	nColor := GetBrushColor;
    case GetBrushColor of
    	clWhite: SetFontColor(clBlue);
      clBlue: SetFontColor(clYellow);
      clRed: SetFontColor(clWhite);
    end;
    SetMeasure(mtInches);
    WriteLineCenter(0.05,'Graphic displays as well as shown below.');
    PrintGraphic(PixelsToInchesHorizontal((Image2.Width-Image1.Width) div 2),
    						PixelsToInchesVertical((Image2.Height-Image1.Height) div 2),-1.0,-1.0,
                Image1);
    SetFontAngle(-15);
    WriteLine(0.7,0.2,'New! Rotated text!');
    WriteLine(0.65,0.35,'Wow!!');
    SetMeasure(mtPixels);
    nColor := GetBrushColor;
  	SetBrushColor(GetFontColor);
    // This moves a circle about 2/3 across the image canvas...
  	for x := -60 to 160 do
  	begin
  		ClearCanvasArea(x-1,120,x+47,174,nColor);
    	Ellipse(x,122,x+48,170);
      Ellipse(x+10,136,x+16,142);
      Ellipse(x+32,136,x+38,142);
      Arc(x+10,140,x+38,165,x,160,x+48,160);
    	sleep(10);
    	Application.ProcessMessages;
  	end;
    // Now, let's add some fun. Make the circle jump and down...
    for z := 1 to 5 do
    begin
    	for x := 122 downto 116 do
      begin
      	ClearCanvasArea(158,x+1,210,x+49,nColor);
				Ellipse(160,x,208,x+48);
        Ellipse(170,x+14,176,x+20);
        Ellipse(192,x+14,198,x+20);
        Arc(170,x+18,198,x+43,160,x+38,208,x+38);
        sleep(20);
        Application.ProcessMessages;
      end;
    	for x := 116 to 122 do
      begin
      	ClearCanvasArea(158,x-1,210,x+48,nColor);
				Ellipse(160,x,208,x+48);
        Ellipse(170,x+14,176,x+20);
        Ellipse(192,x+14,198,x+20);
        Arc(170,x+18,198,x+43,160,x+38,208,x+38);
        sleep(20);
        Application.ProcessMessages;
      end;
    end;
    // Now let's make him wink...
    ClearCanvasArea(192,136,198,142,GetBrushColor);
    Arc(192,136,198,142,192,142,198,142);
    Application.ProcessMessages;
    sleep(300);
    ClearCanvasArea(192,130,198,136,GetBrushColor);
    Ellipse(192,130,198,136);
    // Now complete the journey across the image canvas...
  	for x := 160 to Image2.Width + 60 do
  	begin
  		ClearCanvasArea(x-1,120,x+47,174,nColor);
    	Ellipse(x,122,x+48,170);
      Ellipse(x+10,136,x+16,142);
      Ellipse(x+32,136,x+38,142);
     	Arc(x+10,140,x+38,165,x,160,x+48,160);
    	sleep(10);
    	Application.ProcessMessages;
  	end;
  	SetBrushColor(nColor);
    Quit;
  end;
  inc(Cleared);
end;

procedure TMainForm.DisplayTextClick(Sender: TObject);
begin
	if Prn.PrinterCanvas <> nil then
  	exit;
	PrintTextImage;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
	Cleared := 0;
  Randomize;
end;

procedure TMainForm.GraphicDemoClick(Sender: TObject);
// This will give you some idea of how to use the drawing methods.
// Basically, they work just like the standard calls.
var
	w: integer;
  x,y,z: single;

begin
	with Prn do
  begin
  	if PrinterCanvas <> nil then
    	exit;
  	try
    	Start;
      SetBrushStyle(bsSolid);
      for w := 1 to 10 do
      begin
      	x := Random*3 + 1.0;
      	y := Random*4 + 1.0;
        z := Random*2;
        SetBrushColor(RGB(Random(255),Random(255),Random(255)));
      	Ellipse(x,y,x+z,y+z);
      end;
      SetBrushColor(clGray);
      FillRect(2.0,8.0,3.5,9.0);
      SetBrushColor(clAqua);
      FillRect(5.5,8.0,7.0,9.0);
      SetBrushColor(clRed);
      FrameRect(3.5,8.0,5.5,9.0);
      FrameRect(2.0,8.0,7.0,9.0);
      SetBrushColor(RGB(Random(255),Random(255),Random(255)));
//      SetMeasure(mtPixels);
      Arc(6.0,2.0,8.0,4.0,6.0,2.98,8.0,2.98);
      Pie(6.0,5.0,8.0,7.0,6.99,4.98,8.0,5.99);
//      SetMeasure(mtInches);
      SetFontName('Arial');
      SetFontSize(12);
      SetFontStyle([fsBold]);
      SetFontColor(clBlue);
      SetPenColor(GetFontColor);
      PolyLine([1.0,1.0,5.0,2.5,3.0,6.0,1.0,1.0]);
      SetBrushColor(RGB(Random(255),Random(255),Random(255)));
      Polygon([1.5,6.8,4.0,6.8,4.3,8.0,1.2,8.0]);
			SetBrushStyle(bsClear);
      WriteLineCenter(9.8,'Demonstration of graphic drawing stuff.');
      SetBrushStyle(bsSolid);
      Quit;
    except
    	on E: Exception do
      begin
      	ShowMessage(E.Message);
      	Abort;
      end;
    end;
  end;
end;

procedure TMainForm.ColorTypeClick(Sender: TObject);
begin
	Red.Enabled := ColorType.ItemIndex = 3;
	Green.Enabled := ColorType.ItemIndex = 3;
	Blue.Enabled := ColorType.ItemIndex = 3;
end;

procedure TMainForm.SpeedButton1Click(Sender: TObject);
begin
	PrinterSetupDialog1.Execute;
  Prn.GetPrinterSpecs;
end;


// TestProc is here just to do testing so I don't have to keep modifying the
// main example printing routines. This is executed when pushing the button
// that says Special Test....

procedure TMainForm.TestProc;
var
	x: integer;
	Font: TFont;

begin
	with Prn do
  begin
      if PrintOrient.Checked then
      begin
      	Orientation := poLandscape;
        if LegalSize.Checked then
        	RightMargin := 13.5
        else
    			RightMargin := 10.5;
        BottomMargin := 8.0;
      end
      else
      begin
      	Orientation := poPortrait;
    		RightMargin := 8.0;
        if LegalSize.Checked then
        	BottomMargin := 13.5
        else
        	BottomMargin := 10.5;
      end;
  	Start;
  	SetMeasure(mtInches);
  	Font := TFont.Create;
    Font.Name := 'Times New Roman';
    Font.Size := 10;
    Font.Style := [];
    Font.Color := clBlack;
    SetFontInfo(Font);
    SetMargins(TopMargin,BottomMargin,LeftMargin,RightMargin);
    Font.Color := clBlue;
    Font.Size := 12;
    Font.Style := [fsBold];
    SetHeaderInfo(1,0.5,'Test Preview Program',1,Font);
    Font.Color := clRed;
    SetHeaderInfo(2,0.7,'Second Header Line',2,Font);
    SaveCurrentFont;
    Font.Size := 16;
    Font.Style := [fsBold];
    SetFontInfo(Font);
    SetHeaderDim(LeftMargin,0.625,RightMargin,0.625 + (GetLineHeightInches * 1.5),true,0,RGB(255,255,230));
    SetDetailTopBottom(0.625 + (GetLineHeightInches * 2),BottomMargin-0.5);
    RestoreCurrentFont;
    Font.Name := 'Arial';
    Font.Size := 10;
    Font.Style := [];
    Font.Color := clBlue;
    SetFooterDim(LeftMargin,BottomMargin-0.4,
    							RightMargin-1.5,BottomMargin,true,0,RGB(230,255,255));
    SetFooterInfo(1,BottomMargin - 0.25,'Page Footer Line #1.',1,Font);
    Font.Free;
    SetTopOfPage;
    SetMeasure(mtPixels);
    DrawBoxShade(100,100,700,100+GetLineHeightPixels,1,RGB(240,220,200));
    WriteLineCenter(100-GetLineHeightPixels,'Testing this pixel positioning above the line.');
    WriteLineCenter(100+GetLineHeightPixels,'Testing this pixel positioning below the line.');


//    for x := 1 to 10 do
//    	WriteLineRight(-1.0,'Testing the automatic line feed...');
    Quit;
  end;
end;

procedure AnotherTest(Sender: TMainForm);
var
	x,y: integer;
  nColor: TColor;
  x1,y1,
  x2,y2: single;

begin
	with Sender do
	with Prn do
  begin
  	if PrinterCanvas <> nil then
    	exit;
  	PrinterCanvas := Image2.Canvas;
    Start;
    SetMargins(0,PixelsToInchesHorizontal(Image2.Height),0,PixelsToInchesVertical(Image2.Width));
    SetMeasure(mtPixels);
    // let's clear the image a little at a time...
    case ColorType.ItemIndex of
    	0: SetBrushColor(clWhite);
      1: SetBrushColor(clBlue);
      2: SetBrushColor(clRed);
      3: SetBrushColor(RGB(StrToInt(Red.Text),StrToInt(Green.Text),StrToInt(Blue.Text)));
    end;
		for y := 0 to Image2.Height do
    begin
    	x := 0;
      while x < Image2.Width do
      begin
      	ClearCanvasArea(x,y,x+50,y+30,GetBrushColor);
        inc(x,50);
        Application.ProcessMessages;
      end;
    end;
    SetMeasure(mtInches);
  	nColor := GetBrushColor;
  	SetBrushColor(GetFontColor);
    x1 := -1; y1 := -1;
    for x := 1 to 1000 do
    begin
    	SetPenColor(RGB(Random(255),Random(255),Random(255)));
    	x2 := random * 2;
      y2 := random * 2;
      if (x1 <> -1) then
      	DrawLine(x1,y1,x2,y2,1);
			x1 := x2; y1 := y2;
    end;
    SetBrushColor(nColor);
    Quit;
  end;
end;

procedure TMainForm.SpecialBtnClick(Sender: TObject);
var
 Font : TFont;
 x,y,
 i,j  : integer;
 ts: TStringList;

begin
	// just testing some silly stuff here for special effects on forms...
  for I := 1 to 10 do
    begin
    	for j := 1 to 5 do
      begin
      	SetBounds(Left - j, Top - j, Width + (j * 2), Height + (j * 2));
      	Update;
        sleep(10);
      end;
      Update;
      Sleep(100);
    	for j := 1 to 5 do
      begin
      	SetBounds(Left + j, Top + j, Width - (j * 2), Height - (j * 2));
      	Update;
        sleep(10);
      end;
      Sleep(100);
    end;
    ShowMessage('Cool, huh?');
//	AnotherTest(self);
  exit;

	TestProc;
end;

procedure TMainForm.PrnAfterPrint(Sender: TObject);
begin
	ShowMessage('The AfterPrint event executes just after issuing an EndDoc.'+chr(10)+
  						'It does not execute if a print job is aborted.');
end;

procedure TMainForm.PrnBeforePrint(Sender: TObject);
begin
	ShowMessage('The BeforePrint event executes just before outputting to the printer.');
end;

procedure TMainForm.FormShow(Sender: TObject);
begin
	PrintTextImage;
end;

end.
